/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.ejml.data.DMatrixRMaj;

public class Polygon3DSequenceViewer
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    final List<Poly> polygons = new ArrayList<Poly>();
    final Se3_F64 worldToCamera = new Se3_F64();
    DMatrixRMaj K = new DMatrixRMaj(3, 3);
    double stepSize;
    int prevX;
    int prevY;
    Line2D.Double line = new Line2D.Double();
    Point3D_F64 p1 = new Point3D_F64();
    Point3D_F64 p2 = new Point3D_F64();
    Point2D_F64 x1 = new Point2D_F64();
    Point2D_F64 x2 = new Point2D_F64();
    CameraPinhole camera = new CameraPinhole();

    public Polygon3DSequenceViewer() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.camera.fx = 300.0;
        this.camera.fy = 300.0;
    }

    public void setFocalLength(double focalLength) {
        this.camera.fx = focalLength;
        this.camera.fy = focalLength;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.worldToCamera;
        synchronized (object) {
            this.worldToCamera.reset();
        }
        object = this.polygons;
        synchronized (object) {
            this.polygons.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Color color, Point3D_F64 ... polygon) {
        Poly p = new Poly(polygon.length, color);
        for (int i = 0; i < polygon.length; ++i) {
            p.pts[i] = polygon[i].copy();
        }
        List<Poly> list = this.polygons;
        synchronized (list) {
            this.polygons.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Point3D_F64 ... polygon) {
        Poly p = new Poly(polygon.length, Color.BLACK);
        for (int i = 0; i < polygon.length; ++i) {
            p.pts[i] = polygon[i].copy();
        }
        List<Poly> list = this.polygons;
        synchronized (list) {
            this.polygons.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.camera.width = this.getWidth();
        this.camera.height = this.getHeight();
        this.camera.cx = this.camera.width / 2;
        this.camera.cy = this.camera.height / 2;
        PerspectiveOps.pinholeToMatrix(this.camera, this.K);
        List<Poly> list = this.polygons;
        synchronized (list) {
            this.renderPolygons(g2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPolygons(Graphics2D g2) {
        Se3_F64 worldToCamera;
        Se3_F64 se3_F64 = this.worldToCamera;
        synchronized (se3_F64) {
            worldToCamera = this.worldToCamera.copy();
        }
        for (Poly poly : this.polygons) {
            SePointOps_F64.transform(worldToCamera, poly.pts[0], this.p1);
            GeometryMath_F64.mult(this.K, this.p1, this.x1);
            if (this.p1.z < 0.0) continue;
            g2.setColor(poly.color);
            boolean skip = false;
            for (int i = 1; i < poly.pts.length; ++i) {
                SePointOps_F64.transform(worldToCamera, poly.pts[i], this.p2);
                GeometryMath_F64.mult(this.K, this.p2, this.x2);
                if (this.p2.z < 0.0) {
                    skip = true;
                    break;
                }
                this.line.setLine(this.x1.x, this.x1.y, this.x2.x, this.x2.y);
                g2.draw(this.line);
                Point3D_F64 tempP = this.p1;
                Point2D_F64 tempX = this.x1;
                this.p1 = this.p2;
                this.p2 = tempP;
                this.x1 = this.x2;
                this.x2 = tempX;
            }
            if (skip) continue;
            SePointOps_F64.transform(worldToCamera, poly.pts[0], this.p2);
            GeometryMath_F64.mult(this.K, this.p2, this.x2);
            this.line.setLine(this.x1.x, this.x1.y, this.x2.x, this.x2.y);
            g2.draw(this.line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent e) {
        Se3_F64 se3_F64 = this.worldToCamera;
        synchronized (se3_F64) {
            Vector3D_F64 T = this.worldToCamera.getT();
            if (e.getKeyChar() == 'w') {
                T.z -= this.stepSize;
            } else if (e.getKeyChar() == 's') {
                T.z += this.stepSize;
            } else if (e.getKeyChar() == 'a') {
                T.x += this.stepSize;
            } else if (e.getKeyChar() == 'd') {
                T.x -= this.stepSize;
            } else if (e.getKeyChar() == 'q') {
                T.y -= this.stepSize;
            } else if (e.getKeyChar() == 'e') {
                T.y += this.stepSize;
            } else if (e.getKeyChar() == 'h') {
                this.worldToCamera.reset();
            }
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.grabFocus();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        double rotX = 0.0;
        double rotY = 0.0;
        double rotZ = 0.0;
        Se3_F64 rotTran = new Se3_F64();
        ConvertRotation3D_F64.eulerToMatrix(EulerType.XYZ, rotX += (double)(this.prevY - e.getY()) * 0.005, rotY += (double)(e.getX() - this.prevX) * 0.005, rotZ, rotTran.getR());
        Se3_F64 se3_F64 = this.worldToCamera;
        synchronized (se3_F64) {
            Se3_F64 temp = this.worldToCamera.concat(rotTran, (Se3_F64)null);
            this.worldToCamera.setTo(temp);
        }
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private static class Poly {
        Point3D_F64[] pts;
        Color color;

        public Poly() {
        }

        public Poly(int length, Color color) {
            this.pts = new Point3D_F64[length];
            this.color = color;
        }
    }
}

