/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.feature.detect.interest.ConfigPointDetector;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.JConfigLength;
import boofcv.gui.controls.JPyramidLevels;
import boofcv.gui.feature.ControlPanelPointDetector;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;

public class ControlPanelPointTrackerKlt
extends StandardAlgConfigPanel {
    public ConfigPKlt configKlt;
    public ConfigPointDetector configDetect;
    private final Listener listener;
    private final JPyramidLevels controlLevels;
    private final JConfigLength spinnerMaxTracks;
    private final JCheckBox checkPruneClose;
    private final JSpinner spinnerIterations;
    private final JSpinner spinnerMaxError;
    private final JSpinner spinnerDescRadius;
    private final JSpinner spinnerForwardsBackwards;
    private final ControlPanelPointDetector controlDetector;

    public ControlPanelPointTrackerKlt(Listener listener) {
        this(listener, new ConfigPointDetector(), ConfigPKlt.levels(4));
    }

    public ControlPanelPointTrackerKlt(Listener listener, ConfigPointDetector configDetect, ConfigPKlt configKlt) {
        this.listener = listener;
        this.configDetect = configDetect;
        this.configKlt = configKlt;
        this.initializeConfiguration();
        this.controlLevels = new JPyramidLevels(this.configKlt.pyramidLevels, listener::changedPointTrackerKlt);
        this.spinnerMaxTracks = this.configLength(configKlt.maximumTracks, 0.0, 50000.0);
        this.checkPruneClose = this.checkbox("Prune Close", this.configKlt.pruneClose, "If true then tracks which are clustered close to each other are pruned");
        this.spinnerIterations = this.spinner(this.configKlt.config.maxIterations, 1, 500, 1);
        this.spinnerMaxError = this.spinner(this.configKlt.config.maxPerPixelError, 0.0, 255.0, 5.0);
        this.spinnerDescRadius = this.spinner(this.configKlt.templateRadius, 1, 100, 1);
        this.spinnerForwardsBackwards = this.spinner(this.configKlt.toleranceFB, -1.0, 100.0, 1.0);
        if (configDetect != null) {
            this.controlDetector = new ControlPanelPointDetector(this.configDetect, listener::changedPointTrackerKlt);
            this.controlDetector.setBorder(BorderFactory.createTitledBorder("Detect"));
            this.controlDetector.getControlGeneralCorner().getSpinnerMaxFeatures().setEnabled(false);
        } else {
            this.controlDetector = null;
        }
        this.addLabeled(this.controlLevels, "Pyramid");
        this.addLabeled(this.spinnerMaxTracks, "Track Limit", "Maximum number of allowed tracks. 0 = unlimited");
        this.addAlignLeft(this.checkPruneClose);
        this.addLabeled(this.spinnerDescRadius, "Template Radius", "Radius of square template that is tracked");
        this.addLabeled(this.spinnerIterations, "Max Iterations", "KLT iterations when tracking");
        this.addLabeled(this.spinnerMaxError, "Max Error", "Drop tracks with an error larger than this value");
        this.addLabeled(this.spinnerForwardsBackwards, "F-to-B Tol.", "Forwards-Backwards tolerance. 0 = disable (Pixels)");
        if (this.isConfigureDetector()) {
            this.add(this.controlDetector);
        }
    }

    protected void initializeConfiguration() {
    }

    public boolean isConfigureDetector() {
        return this.controlDetector != null;
    }

    public <T extends ImageBase<T>> PointTracker<T> createTracker(ImageType<T> imageType) {
        return FactoryPointTracker.klt(this.configKlt, this.configDetect, imageType.getImageClass(), null);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerDescRadius) {
            this.configKlt.templateRadius = ((Number)this.spinnerDescRadius.getValue()).intValue();
        } else if (source == this.spinnerMaxTracks) {
            this.configKlt.maximumTracks.setTo(this.spinnerMaxTracks.getValue());
        } else if (source == this.spinnerMaxError) {
            this.configKlt.config.maxPerPixelError = ((Number)this.spinnerMaxError.getValue()).floatValue();
        } else if (source == this.spinnerForwardsBackwards) {
            this.configKlt.toleranceFB = ((Number)this.spinnerForwardsBackwards.getValue()).doubleValue();
        } else if (source == this.spinnerIterations) {
            this.configKlt.config.maxIterations = ((Number)this.spinnerIterations.getValue()).intValue();
        } else if (source == this.checkPruneClose) {
            this.configKlt.pruneClose = this.checkPruneClose.isSelected();
        }
        this.listener.changedPointTrackerKlt();
    }

    public static interface Listener {
        public void changedPointTrackerKlt();
    }
}

