/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.controls.ControlPanelPointCloud;
import boofcv.visualize.PointCloudViewer;
import boofcv.visualize.VisualizeData;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point3D_F64;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class PointCloudViewerPanel
extends JPanel {
    private ControlPanelPointCloud controls = new ControlPanelPointCloud(this::handleControlChange);
    private PointCloudViewer viewer = VisualizeData.createPointCloudViewer();
    public double periodBaseline = 1.0;
    public double translateBaseline = 1.0;

    public PointCloudViewerPanel() {
        super(new BorderLayout());
        this.handleControlChange();
        this.add((Component)this.controls, "West");
        this.add((Component)this.viewer.getComponent(), "Center");
    }

    public void clearPoints() {
        BoofSwingUtil.checkGuiThread();
        this.viewer.clearPoints();
    }

    public void selectPeriods(List<Point3D_F64> cloud) {
        Point3D_F64 mean = new Point3D_F64();
        UtilPoint3D_F64.mean(cloud, mean);
        double total = 0.0;
        for (int i = 0; i < cloud.size(); ++i) {
            total += mean.distance((GeoTuple_F64)cloud.get(i));
        }
        this.translateBaseline = (total /= (double)cloud.size()) * 0.005;
        this.periodBaseline = total * 0.05;
    }

    public void addCloud64(List<Point3D_F64> cloud, @Nullable DogArray_I32 colorRGB) {
        BoofSwingUtil.checkGuiThread();
        if (colorRGB == null) {
            this.viewer.addCloud(cloud);
        } else {
            assert (cloud.size() == colorRGB.size);
            this.viewer.addCloud(cloud, colorRGB.data);
        }
    }

    public void handleControlChange() {
        this.controls.configure(this.viewer, this.periodBaseline, this.translateBaseline);
        this.viewer.getComponent().repaint();
    }

    public ControlPanelPointCloud getControls() {
        return this.controls;
    }

    public PointCloudViewer getViewer() {
        return this.viewer;
    }
}

