/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.abst.disparity.StereoDisparitySparse;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.EnforceUniqueByScore;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.EstimateNofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.sfm.DepthSparse3D_to_PixelTo3D;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.abst.sfm.d3.MonoOverhead_to_MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonoPlaneInfinity_to_MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometryScaleInput;
import boofcv.abst.sfm.d3.PyramidDirectColorDepth_to_DepthVisualOdometry;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.abst.sfm.d3.StereoVisualOdometryScaleInput;
import boofcv.abst.sfm.d3.VisOdomPixelDepthPnP_to_DepthVisualOdometry;
import boofcv.abst.sfm.d3.WrapVisOdomDualTrackPnP;
import boofcv.abst.sfm.d3.WrapVisOdomMonoStereoDepthPnP;
import boofcv.abst.sfm.d3.WrapVisOdomQuadPnP;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.feature.associate.AssociateStereo2D;
import boofcv.alg.geo.pose.PnPDistanceReprojectionSq;
import boofcv.alg.geo.pose.PnPStereoDistanceReprojectionSq;
import boofcv.alg.geo.pose.PnPStereoEstimator;
import boofcv.alg.geo.pose.PnPStereoRefineRodrigues;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.sfm.StereoSparse3D;
import boofcv.alg.sfm.d3.VisOdomDualTrackPnP;
import boofcv.alg.sfm.d3.VisOdomMonoDepthPnP;
import boofcv.alg.sfm.d3.VisOdomMonoOverheadMotion2D;
import boofcv.alg.sfm.d3.VisOdomMonoPlaneInfinity;
import boofcv.alg.sfm.d3.VisOdomStereoQuadPnP;
import boofcv.alg.sfm.d3.direct.PyramidDirectColorDepth;
import boofcv.alg.sfm.d3.structure.MaxGeoKeyFrameManager;
import boofcv.alg.sfm.d3.structure.TickTockKeyFrameManager;
import boofcv.alg.sfm.d3.structure.VisOdomKeyFrameManager;
import boofcv.alg.sfm.robust.DistancePlane2DToPixelSq;
import boofcv.alg.sfm.robust.GenerateSe2_PlanePtPixel;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.EstimatorToGenerator;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.sfm.ConfigStereoDualTrackPnP;
import boofcv.factory.sfm.ConfigStereoQuadPnP;
import boofcv.factory.sfm.ConfigVisOdomTrackPnP;
import boofcv.factory.sfm.FactoryMotion2D;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import boofcv.struct.sfm.PlanePtPixel;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.fitting.se.ModelManagerSe2_F64;
import georegression.fitting.se.ModelManagerSe3_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.jetbrains.annotations.Nullable;

public class FactoryVisualOdometry {
    public static <T extends ImageGray<T>> MonocularPlaneVisualOdometry<T> monoPlaneInfinity(int thresholdAdd, int thresholdRetire, double inlierPixelTol, int ransacIterations, PointTracker<T> tracker, ImageType<T> imageType) {
        double ransacTOL = inlierPixelTol * inlierPixelTol;
        ModelManagerSe2_F64 manager = new ModelManagerSe2_F64();
        DistancePlane2DToPixelSq distance = new DistancePlane2DToPixelSq();
        GenerateSe2_PlanePtPixel generator = new GenerateSe2_PlanePtPixel();
        Ransac<Se2_F64, PlanePtPixel> motion = new Ransac<Se2_F64, PlanePtPixel>(2323L, manager, generator, distance, ransacIterations, ransacTOL);
        VisOdomMonoPlaneInfinity<T> alg = new VisOdomMonoPlaneInfinity<T>(thresholdAdd, thresholdRetire, inlierPixelTol, motion, tracker);
        return new MonoPlaneInfinity_to_MonocularPlaneVisualOdometry<T>(alg, distance, generator, imageType);
    }

    public static <T extends ImageGray<T>> MonocularPlaneVisualOdometry<T> monoPlaneOverhead(double cellSize, double maxCellsPerPixel, double mapHeightFraction, double inlierGroundTol, int ransacIterations, int thresholdRetire, int absoluteMinimumTracks, double respawnTrackFraction, double respawnCoverageFraction, PointTracker<T> tracker, ImageType<T> imageType) {
        ImageMotion2D<T, Se2_F64> motion2D = FactoryMotion2D.createMotion2D(ransacIterations, inlierGroundTol * inlierGroundTol, thresholdRetire, absoluteMinimumTracks, respawnTrackFraction, respawnCoverageFraction, false, tracker, new Se2_F64());
        VisOdomMonoOverheadMotion2D<T> alg = new VisOdomMonoOverheadMotion2D<T>(cellSize, maxCellsPerPixel, mapHeightFraction, motion2D, imageType);
        return new MonoOverhead_to_MonocularPlaneVisualOdometry<T>(alg, imageType);
    }

    public static <T extends ImageGray<T>> StereoVisualOdometry<T> stereoMonoPnP(ConfigVisOdomTrackPnP configVO, StereoDisparitySparse<T> sparseDisparity, PointTracker<T> tracker, Class<T> imageType) {
        VisOdomKeyFrameManager visOdomKeyFrameManager;
        if (configVO == null) {
            configVO = new ConfigVisOdomTrackPnP();
        }
        StereoSparse3D<T> pixelTo3D = new StereoSparse3D<T>(sparseDisparity, imageType);
        Estimate1ofPnP estimator = FactoryMultiView.pnp_1(configVO.pnp, -1, 1);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>(estimator);
        double ransacTOL = configVO.ransac.inlierThreshold * configVO.ransac.inlierThreshold;
        Ransac<Se3_F64, Point2D3D> motion = new Ransac<Se3_F64, Point2D3D>(configVO.ransac.randSeed, manager, generator, distance, configVO.ransac.iterations, ransacTOL);
        RefinePnP refine = null;
        if (configVO.refineIterations > 0) {
            refine = FactoryMultiView.pnpRefine(1.0E-12, configVO.refineIterations);
        }
        switch (configVO.keyframes.type) {
            case MAX_GEO: {
                visOdomKeyFrameManager = new MaxGeoKeyFrameManager(configVO.keyframes.geoMinCoverage);
                break;
            }
            case TICK_TOCK: {
                visOdomKeyFrameManager = new TickTockKeyFrameManager(configVO.keyframes.tickPeriod);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        VisOdomKeyFrameManager keyframe = visOdomKeyFrameManager;
        VisOdomMonoDepthPnP<T> alg = new VisOdomMonoDepthPnP<T>(motion, pixelTo3D, refine, tracker);
        alg.getBundleViso().bundle.setSba(FactoryMultiView.bundleSparseMetric(configVO.bundle));
        alg.getBundleViso().bundle.configConverge.setTo(configVO.bundleConverge);
        alg.setFrameManager(keyframe);
        alg.setThresholdRetireTracks(configVO.dropOutlierTracks);
        alg.getBundleViso().getSelectTracks().maxFeaturesPerFrame = configVO.bundleMaxFeaturesPerFrame;
        alg.getBundleViso().getSelectTracks().minTrackObservations = configVO.bundleMinObservations;
        return new WrapVisOdomMonoStereoDepthPnP<T>(alg, pixelTo3D, distance, imageType);
    }

    @Deprecated
    public static <Vis extends ImageGray<Vis>, Depth extends ImageGray<Depth>> DepthVisualOdometry<Vis, Depth> depthDepthPnP(double inlierPixelTol, int thresholdAdd, int thresholdRetire, int ransacIterations, int refineIterations, boolean doublePass, DepthSparse3D<Depth> sparseDepth, PointTracker<Vis> tracker, Class<Vis> visualType, Class<Depth> depthType) {
        DepthSparse3D_to_PixelTo3D<Depth> pixelTo3D = new DepthSparse3D_to_PixelTo3D<Depth>(sparseDepth);
        Estimate1ofPnP estimator = FactoryMultiView.pnp_1(EnumPNP.P3P_FINSTERWALDER, -1, 2);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>(estimator);
        double ransacTOL = inlierPixelTol * inlierPixelTol;
        Ransac<Se3_F64, Point2D3D> motion = new Ransac<Se3_F64, Point2D3D>(2323L, manager, generator, distance, ransacIterations, ransacTOL);
        RefinePnP refine = null;
        if (refineIterations > 0) {
            refine = FactoryMultiView.pnpRefine(1.0E-12, refineIterations);
        }
        VisOdomMonoDepthPnP<Vis> alg = new VisOdomMonoDepthPnP<Vis>(motion, pixelTo3D, refine, tracker);
        alg.setThresholdRetireTracks(thresholdRetire);
        return new VisOdomPixelDepthPnP_to_DepthVisualOdometry<Vis, Depth>(sparseDepth, alg, distance, ImageType.single(visualType), depthType);
    }

    public static <Vis extends ImageGray<Vis>, Depth extends ImageGray<Depth>> DepthVisualOdometry<Vis, Depth> depthDepthPnP(ConfigVisOdomTrackPnP configVO, DepthSparse3D<Depth> sparseDepth, PointTracker<Vis> tracker, Class<Vis> visualType, Class<Depth> depthType) {
        VisOdomKeyFrameManager visOdomKeyFrameManager;
        DepthSparse3D_to_PixelTo3D<Depth> pixelTo3D = new DepthSparse3D_to_PixelTo3D<Depth>(sparseDepth);
        Estimate1ofPnP estimator = FactoryMultiView.pnp_1(configVO.pnp, -1, 1);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>(estimator);
        double ransacTOL = configVO.ransac.inlierThreshold * configVO.ransac.inlierThreshold;
        Ransac<Se3_F64, Point2D3D> motion = new Ransac<Se3_F64, Point2D3D>(configVO.ransac.randSeed, manager, generator, distance, configVO.ransac.iterations, ransacTOL);
        RefinePnP refine = null;
        if (configVO.refineIterations > 0) {
            refine = FactoryMultiView.pnpRefine(1.0E-12, configVO.refineIterations);
        }
        switch (configVO.keyframes.type) {
            case MAX_GEO: {
                visOdomKeyFrameManager = new MaxGeoKeyFrameManager(configVO.keyframes.geoMinCoverage);
                break;
            }
            case TICK_TOCK: {
                visOdomKeyFrameManager = new TickTockKeyFrameManager(configVO.keyframes.tickPeriod);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        VisOdomKeyFrameManager keyframe = visOdomKeyFrameManager;
        VisOdomMonoDepthPnP<Vis> alg = new VisOdomMonoDepthPnP<Vis>(motion, pixelTo3D, refine, tracker);
        alg.getBundleViso().bundle.setSba(FactoryMultiView.bundleSparseMetric(configVO.bundle));
        alg.getBundleViso().bundle.configConverge.setTo(configVO.bundleConverge);
        alg.setFrameManager(keyframe);
        alg.setThresholdRetireTracks(configVO.dropOutlierTracks);
        alg.getBundleViso().getSelectTracks().maxFeaturesPerFrame = configVO.bundleMaxFeaturesPerFrame;
        alg.getBundleViso().getSelectTracks().minTrackObservations = configVO.bundleMinObservations;
        return new VisOdomPixelDepthPnP_to_DepthVisualOdometry<Vis, Depth>(sparseDepth, alg, distance, ImageType.single(visualType), depthType);
    }

    public static <T extends ImageGray<T>> StereoVisualOdometry<T> stereoDualTrackerPnP(@Nullable ConfigStereoDualTrackPnP configVO, Class<T> imageType) {
        if (configVO == null) {
            configVO = new ConfigStereoDualTrackPnP();
        }
        configVO.checkValidity();
        PointTracker<T> trackerLeft = FactoryPointTracker.tracker(configVO.tracker, imageType, null);
        PointTracker<T> trackerRight = FactoryPointTracker.tracker(configVO.tracker, imageType, null);
        return FactoryVisualOdometry.stereoDualTrackerPnP(configVO.scene, trackerLeft, trackerRight, configVO, imageType);
    }

    public static <T extends ImageGray<T>, Desc extends TupleDesc> StereoVisualOdometry<T> stereoDualTrackerPnP(ConfigVisOdomTrackPnP configVO, PointTracker<T> trackerLeft, PointTracker<T> trackerRight, ConfigStereoDualTrackPnP hack, Class<T> imageType) {
        VisOdomKeyFrameManager visOdomKeyFrameManager;
        if (configVO == null) {
            configVO = new ConfigVisOdomTrackPnP();
        }
        configVO.checkValidity();
        EstimateNofPnP pnp = FactoryMultiView.pnp_N(configVO.pnp, -1);
        PnPDistanceReprojectionSq distanceMono = new PnPDistanceReprojectionSq();
        PnPStereoDistanceReprojectionSq distanceStereo = new PnPStereoDistanceReprojectionSq();
        PnPStereoEstimator pnpStereo = new PnPStereoEstimator(pnp, distanceMono, 0);
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Stereo2D3D> generator = new EstimatorToGenerator<Se3_F64, Stereo2D3D>(pnpStereo);
        double ransacTOL = 2.0 * configVO.ransac.inlierThreshold * configVO.ransac.inlierThreshold;
        Ransac<Se3_F64, Stereo2D3D> motion = new Ransac<Se3_F64, Stereo2D3D>(configVO.ransac.randSeed, manager, generator, distanceStereo, configVO.ransac.iterations, ransacTOL);
        PnPStereoRefineRodrigues refinePnP = null;
        if (configVO.refineIterations > 0) {
            refinePnP = new PnPStereoRefineRodrigues(1.0E-12, configVO.refineIterations);
        }
        Triangulate2ViewsMetric triangulate2 = FactoryMultiView.triangulate2ViewMetric(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
        switch (configVO.keyframes.type) {
            case MAX_GEO: {
                visOdomKeyFrameManager = new MaxGeoKeyFrameManager(configVO.keyframes.geoMinCoverage);
                break;
            }
            case TICK_TOCK: {
                visOdomKeyFrameManager = new TickTockKeyFrameManager(configVO.keyframes.tickPeriod);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        VisOdomKeyFrameManager keyframe = visOdomKeyFrameManager;
        DescribeRegionPoint descriptor = FactoryDescribeRegionPoint.generic(hack.stereoDescribe, ImageType.single(imageType));
        Class descType = descriptor.getDescriptionType();
        ScoreAssociation scorer = FactoryAssociation.defaultScore(descType);
        AssociateStereo2D associateL2R = new AssociateStereo2D(scorer, hack.epipolarTol, descType);
        AssociateDescription2D associateUnique = FactoryAssociation.ensureUnique(associateL2R);
        if (!associateL2R.uniqueDestination() || !associateL2R.uniqueSource()) {
            associateUnique = new EnforceUniqueByScore.Describe2D(associateL2R, true, true);
        }
        VisOdomDualTrackPnP alg = new VisOdomDualTrackPnP(hack.epipolarTol, trackerLeft, trackerRight, descriptor, associateUnique, triangulate2, motion, refinePnP);
        alg.getBundleViso().bundle.setSba(FactoryMultiView.bundleSparseMetric(configVO.bundle));
        alg.getBundleViso().bundle.configConverge.setTo(configVO.bundleConverge);
        alg.setDescribeRadius(hack.stereoRadius);
        alg.setFrameManager(keyframe);
        alg.setThresholdRetireTracks(configVO.dropOutlierTracks);
        alg.getBundleViso().getSelectTracks().maxFeaturesPerFrame = configVO.bundleMaxFeaturesPerFrame;
        alg.getBundleViso().getSelectTracks().minTrackObservations = configVO.bundleMinObservations;
        return new WrapVisOdomDualTrackPnP<T>(alg, pnpStereo, distanceMono, distanceStereo, associateL2R, refinePnP, imageType);
    }

    public static <T extends ImageGray<T>, Desc extends TupleDesc> StereoVisualOdometry<T> stereoQuadPnP(ConfigStereoQuadPnP config, Class<T> imageType) {
        EstimateNofPnP pnp = FactoryMultiView.pnp_N(config.pnp, -1);
        PnPDistanceReprojectionSq distanceMono = new PnPDistanceReprojectionSq();
        PnPStereoDistanceReprojectionSq distanceStereo = new PnPStereoDistanceReprojectionSq();
        PnPStereoEstimator pnpStereo = new PnPStereoEstimator(pnp, distanceMono, 0);
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Stereo2D3D> generator = new EstimatorToGenerator<Se3_F64, Stereo2D3D>(pnpStereo);
        double ransacTOL = 2.0 * config.ransac.inlierThreshold * config.ransac.inlierThreshold;
        Ransac<Se3_F64, Stereo2D3D> motion = new Ransac<Se3_F64, Stereo2D3D>(config.ransac.randSeed, manager, generator, distanceStereo, config.ransac.iterations, ransacTOL);
        PnPStereoRefineRodrigues refinePnP = null;
        if (config.refineIterations > 0) {
            refinePnP = new PnPStereoRefineRodrigues(1.0E-12, config.refineIterations);
        }
        DetectDescribePoint<T, TupleDesc_F64> detector = FactoryDetectDescribe.generic(config.detectDescribe, imageType);
        Class descType = detector.getDescriptionType();
        ScoreAssociation scorer = FactoryAssociation.defaultScore(descType);
        AssociateStereo2D associateL2R = new AssociateStereo2D(scorer, config.epipolarTol, descType);
        associateL2R.setMaxScoreThreshold(config.associateL2R.maxErrorThreshold);
        AssociateDescription2D associateF2F = FactoryAssociation.generic2(config.associateF2F, detector);
        Triangulate2ViewsMetric triangulate = FactoryMultiView.triangulate2ViewMetric(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
        VisOdomStereoQuadPnP<T, TupleDesc_F64> alg = new VisOdomStereoQuadPnP<T, TupleDesc_F64>(detector, associateF2F, associateL2R, triangulate, motion, refinePnP);
        alg.getBundle().sba = FactoryMultiView.bundleSparseMetric(config.bundle);
        alg.getBundle().configConverge.setTo(config.bundleConverge);
        return new WrapVisOdomQuadPnP<T, TupleDesc_F64>(alg, refinePnP, associateL2R, distanceStereo, distanceMono, imageType);
    }

    public static <T extends ImageBase<T>> StereoVisualOdometry<T> scaleInput(StereoVisualOdometry<T> vo, double scaleFactor) {
        return new StereoVisualOdometryScaleInput<T>(vo, scaleFactor);
    }

    public static <T extends ImageBase<T>> MonocularPlaneVisualOdometry<T> scaleInput(MonocularPlaneVisualOdometry<T> vo, double scaleFactor) {
        return new MonocularPlaneVisualOdometryScaleInput<T>(vo, scaleFactor);
    }

    public static <Vis extends ImageGray<Vis>, Depth extends ImageGray<Depth>> DepthVisualOdometry<Planar<Vis>, Depth> depthDirect(DepthSparse3D<Depth> sparse3D, ImageType<Planar<Vis>> visualType, Class<Depth> depthType) {
        PyramidDiscrete pyramid = FactoryPyramid.discreteGaussian(ConfigDiscreteLevels.levels(3), -1.0, 2, false, visualType);
        PyramidDirectColorDepth alg = new PyramidDirectColorDepth(pyramid);
        return new PyramidDirectColorDepth_to_DepthVisualOdometry(sparse3D, alg, depthType);
    }
}

