/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.mvs;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.mvs.video.RelativeBetter;
import boofcv.alg.mvs.video.SelectFramesForReconstruction3D;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.geo.ConfigLMedS;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.factory.mvs.ConfigSelectFrames3D;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.jetbrains.annotations.Nullable;

public class FactoryMultiViewStereo {
    public static <T extends ImageGray<T>> SelectFramesForReconstruction3D<T> frameSelector3D(@Nullable ConfigSelectFrames3D config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigSelectFrames3D();
        }
        Class grayType = imageType.getImageClass();
        DescribeRegionPoint describe = FactoryDescribeRegionPoint.generic(config.describe, imageType);
        SelectFramesForReconstruction3D alg = new SelectFramesForReconstruction3D(describe);
        alg.config.setTo(config);
        alg.setTracker(FactoryPointTracker.tracker(config.tracker, grayType, null));
        alg.setAssociate(FactoryAssociation.generic2(config.associate, describe));
        ConfigLMedS configRobust = new ConfigLMedS();
        configRobust.totalCycles = config.robustIterations;
        configRobust.errorFraction = 0.75;
        alg.setRobust3D(FactoryMultiViewRobust.fundamentalLMedS(null, configRobust));
        alg.setRobustH(FactoryMultiViewRobust.homographyLMedS(null, configRobust));
        alg.setCompareFit(new RelativeBetter.ErrorHardRatioSq(config.motionInlierPx));
        return alg;
    }

    public static boolean isErrorSignificant3D(double error3D, double errorH, double significant, double tol) {
        if (errorH < significant) {
            return false;
        }
        return errorH - error3D >= errorH * tol;
    }
}

