/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.filter.convolve.ConvolveImageSparse;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageGray;

public class FactoryConvolveSparse {
    public static <T extends ImageGray<T>, K extends Kernel2D> ImageConvolveSparse<T, K> convolve2D(Class<T> imageType, K kernel) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Convolve2D_F32((Kernel2D_F32)kernel);
        }
        return new Convolve2D_I32((Kernel2D_S32)kernel);
    }

    public static <T extends ImageGray<T>, K extends Kernel1D> ImageConvolveSparse<T, K> vertical1D(Class<T> imageType, K kernel) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Vertical1D_F32((Kernel1D_F32)kernel);
        }
        return new Vertical1D_I32((Kernel1D_S32)kernel);
    }

    public static <T extends ImageGray<T>, K extends Kernel1D> ImageConvolveSparse<T, K> horizontal1D(Class<T> imageType, K kernel) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Horizontal1D_F32((Kernel1D_F32)kernel);
        }
        return new Horizontal1D_I32((Kernel1D_S32)kernel);
    }

    public static class Convolve2D_F32
    extends ImageConvolveSparse<GrayF32, Kernel2D_F32> {
        public Convolve2D_F32(Kernel2D_F32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveImageSparse.convolve((Kernel2D_F32)this.kernel, (ImageBorder_F32)this.image, x, y);
        }
    }

    public static class Convolve2D_I32<T extends GrayI<T>>
    extends ImageConvolveSparse<T, Kernel2D_S32> {
        public Convolve2D_I32(Kernel2D_S32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveImageSparse.convolve((Kernel2D_S32)this.kernel, (ImageBorder_S32)this.image, x, y);
        }
    }

    public static class Vertical1D_F32
    extends ImageConvolveSparse<GrayF32, Kernel1D_F32> {
        public Vertical1D_F32(Kernel1D_F32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveImageSparse.vertical((Kernel1D_F32)this.kernel, (ImageBorder_F32)this.image, x, y);
        }
    }

    public static class Vertical1D_I32
    extends ImageConvolveSparse<GrayF32, Kernel1D_S32> {
        public Vertical1D_I32(Kernel1D_S32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveImageSparse.vertical((Kernel1D_S32)this.kernel, (ImageBorder_S32)this.image, x, y);
        }
    }

    public static class Horizontal1D_F32
    extends ImageConvolveSparse<GrayF32, Kernel1D_F32> {
        public Horizontal1D_F32(Kernel1D_F32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveImageSparse.horizontal((Kernel1D_F32)this.kernel, (ImageBorder_F32)this.image, x, y);
        }
    }

    public static class Horizontal1D_I32
    extends ImageConvolveSparse<GrayF32, Kernel1D_S32> {
        public Horizontal1D_I32(Kernel1D_S32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveImageSparse.horizontal((Kernel1D_S32)this.kernel, (ImageBorder_S32)this.image, x, y);
        }
    }
}

