/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.line;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.line.DetectLineHoughFootSubimage;
import boofcv.abst.feature.detect.line.DetectLineSegmentsGridRansac;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.line.ConnectLinesGrid;
import boofcv.alg.feature.detect.line.GridRansacLineDetector;
import boofcv.alg.feature.detect.line.HoughParametersFootOfNorm;
import boofcv.alg.feature.detect.line.HoughParametersPolar;
import boofcv.alg.feature.detect.line.HoughTransformBinary;
import boofcv.alg.feature.detect.line.HoughTransformBinary_MT;
import boofcv.alg.feature.detect.line.HoughTransformGradient;
import boofcv.alg.feature.detect.line.HoughTransformGradient_MT;
import boofcv.alg.feature.detect.line.gridline.Edgel;
import boofcv.alg.feature.detect.line.gridline.GridLineModelDistance;
import boofcv.alg.feature.detect.line.gridline.GridLineModelFitter;
import boofcv.alg.feature.detect.line.gridline.ImplGridRansacLineDetector_F32;
import boofcv.alg.feature.detect.line.gridline.ImplGridRansacLineDetector_S16;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.line.ConfigHoughBinary;
import boofcv.factory.feature.detect.line.ConfigHoughFootSubimage;
import boofcv.factory.feature.detect.line.ConfigHoughGradient;
import boofcv.factory.feature.detect.line.ConfigLineRansac;
import boofcv.factory.feature.detect.line.ConfigParamFoot;
import boofcv.factory.feature.detect.line.ConfigParamPolar;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageGray;
import georegression.fitting.line.ModelManagerLinePolar2D_F32;
import georegression.struct.line.LinePolar2D_F32;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.jetbrains.annotations.Nullable;

public class FactoryDetectLineAlgs {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> DetectLineSegmentsGridRansac<I, D> lineRansac(@Nullable ConfigLineRansac config, Class<I> imageType, Class<D> derivType) {
        GridRansacLineDetector alg;
        if (config == null) {
            config = new ConfigLineRansac();
        }
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        ModelManagerLinePolar2D_F32 manager = new ModelManagerLinePolar2D_F32();
        GridLineModelDistance distance = new GridLineModelDistance((float)config.thresholdAngle);
        GridLineModelFitter fitter = new GridLineModelFitter((float)config.thresholdAngle);
        Ransac<LinePolar2D_F32, Edgel> matcher = new Ransac<LinePolar2D_F32, Edgel>(123123L, manager, fitter, distance, 25, 1.0);
        if (derivType == GrayF32.class) {
            alg = new ImplGridRansacLineDetector_F32(config.regionSize, 10, matcher);
        } else if (derivType == GrayS16.class) {
            alg = new ImplGridRansacLineDetector_S16(config.regionSize, 10, matcher);
        } else {
            throw new IllegalArgumentException("Unsupported derivative type");
        }
        ConnectLinesGrid connect = null;
        if (config.connectLines) {
            connect = new ConnectLinesGrid(0.031415926535897934, 1.0, 8.0);
        }
        return new DetectLineSegmentsGridRansac<I, GrayF32>(alg, connect, gradient, config.thresholdEdge, imageType, derivType);
    }

    public static <D extends ImageGray<D>> DetectLineHoughFootSubimage<D> houghFootSub(@Nullable ConfigHoughFootSubimage config, Class<D> derivType) {
        if (config == null) {
            config = new ConfigHoughFootSubimage();
        }
        return new DetectLineHoughFootSubimage<D>(config.localMaxRadius, config.minCounts, config.minDistanceFromOrigin, config.thresholdEdge, config.totalHorizontalDivisions, config.totalVerticalDivisions, config.maxLines, derivType);
    }

    public static <D extends ImageGray<D>> HoughTransformGradient<D> houghLineFoot(ConfigHoughGradient configHough, ConfigParamFoot configParam, Class<D> derivType) {
        HoughParametersFootOfNorm param = new HoughParametersFootOfNorm(configParam.minDistanceFromOrigin);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(configHough.localMaxRadius, configHough.minCounts, 0, true));
        HoughTransformGradient hough = BoofConcurrency.USE_CONCURRENT ? new HoughTransformGradient_MT<D>(extractor, param, derivType) : new HoughTransformGradient<D>(extractor, param, derivType);
        hough.setMaxLines(configHough.maxLines);
        hough.setMergeAngle(configHough.mergeAngle);
        hough.setMergeDistance(configHough.mergeDistance);
        hough.setRefineRadius(configHough.refineRadius);
        return hough;
    }

    public static <D extends ImageGray<D>> HoughTransformGradient<D> houghLinePolar(ConfigHoughGradient configHough, ConfigParamPolar configParam, Class<D> derivType) {
        HoughParametersPolar param = new HoughParametersPolar(configParam.resolutionRange, configParam.numBinsAngle);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(configHough.localMaxRadius, configHough.minCounts, 0, true));
        HoughTransformGradient hough = BoofConcurrency.USE_CONCURRENT ? new HoughTransformGradient_MT<D>(extractor, param, derivType) : new HoughTransformGradient<D>(extractor, param, derivType);
        hough.setMaxLines(configHough.maxLines);
        hough.setMergeAngle(configHough.mergeAngle);
        hough.setMergeDistance(configHough.mergeDistance);
        hough.setRefineRadius(configHough.refineRadius);
        return hough;
    }

    public static HoughTransformBinary houghLinePolar(ConfigHoughBinary configHough, ConfigParamPolar configParam) {
        HoughParametersPolar param = new HoughParametersPolar(configParam.resolutionRange, configParam.numBinsAngle);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(configHough.localMaxRadius, 0.0f, 0, false));
        HoughTransformBinary hough = BoofConcurrency.USE_CONCURRENT ? new HoughTransformBinary_MT(extractor, param) : new HoughTransformBinary(extractor, param);
        hough.setMaxLines(configHough.maxLines);
        hough.setMergeAngle(configHough.mergeAngle);
        hough.setMergeDistance(configHough.mergeDistance);
        hough.setNumberOfCounts(configHough.minCounts.copy());
        return hough;
    }
}

