/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.interest;

import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperHessianDerivBlobIntensity;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.filter.ImageFunctionSparse;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.FeatureLaplacePyramid;
import boofcv.alg.feature.detect.interest.FeaturePyramid;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.FeatureSelectNBest;
import boofcv.alg.feature.detect.selector.SampleIntensityImage;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.feature.detect.selector.FactorySelectLimit;
import boofcv.factory.filter.derivative.FactoryDerivativeSparse;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import org.jetbrains.annotations.Nullable;

public class FactoryInterestPointAlgs {
    public static <T extends ImageGray<T>, D extends ImageGray<D>> FeaturePyramid<T, D> hessianPyramid(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        WrapperHessianDerivBlobIntensity intensity = new WrapperHessianDerivBlobIntensity(HessianBlobIntensity.Type.DETERMINANT, derivType);
        NonMaxSuppression extractorMin = intensity.localMinimums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.min(extractRadius, detectThreshold, extractRadius, true)) : null;
        NonMaxSuppression extractorMax = intensity.localMaximums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.max(extractRadius, detectThreshold, extractRadius, true)) : null;
        FeatureSelectNBest<Point2D_I16> selector = new FeatureSelectNBest<Point2D_I16>(new SampleIntensityImage.I16());
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractorMin, extractorMax, selector);
        detector.setFeatureLimit(maxFeatures);
        AnyImageDerivative<T, D> deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        return new FeaturePyramid(detector, deriv, 2.0);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> FeaturePyramid<T, D> harrisPyramid(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        GradientCornerIntensity<D> harris = FactoryIntensityPointAlg.harris(extractRadius, 0.04f, false, derivType);
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(harris);
        NonMaxSuppression extractorMin = intensity.localMinimums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.min(extractRadius, detectThreshold, extractRadius, true)) : null;
        NonMaxSuppression extractorMax = intensity.localMaximums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.max(extractRadius, detectThreshold, extractRadius, true)) : null;
        FeatureSelectNBest<Point2D_I16> selector = new FeatureSelectNBest<Point2D_I16>(new SampleIntensityImage.I16());
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractorMin, extractorMax, selector);
        detector.setFeatureLimit(maxFeatures);
        AnyImageDerivative<T, D> deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        return new FeaturePyramid(detector, deriv, 2.0);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> FeatureLaplacePyramid<T, D> hessianLaplace(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        WrapperHessianDerivBlobIntensity intensity = new WrapperHessianDerivBlobIntensity(HessianBlobIntensity.Type.DETERMINANT, derivType);
        NonMaxSuppression extractorMin = intensity.localMinimums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.min(extractRadius, detectThreshold, extractRadius, true)) : null;
        NonMaxSuppression extractorMax = intensity.localMaximums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.max(extractRadius, detectThreshold, extractRadius, true)) : null;
        FeatureSelectNBest<Point2D_I16> selector = new FeatureSelectNBest<Point2D_I16>(new SampleIntensityImage.I16());
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractorMin, extractorMax, selector);
        detector.setFeatureLimit(maxFeatures);
        AnyImageDerivative<T, D> deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        ImageFunctionSparse<T> sparseLaplace = FactoryDerivativeSparse.createLaplacian(imageType, null);
        return new FeatureLaplacePyramid(detector, sparseLaplace, deriv, 2.0);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> FeatureLaplacePyramid<T, D> harrisLaplace(int extractRadius, float detectThreshold, int maxFeatures, Class<T> imageType, Class<D> derivType) {
        GradientCornerIntensity<D> harris = FactoryIntensityPointAlg.harris(extractRadius, 0.04f, false, derivType);
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(harris);
        NonMaxSuppression extractorMin = intensity.localMinimums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.min(extractRadius, detectThreshold, extractRadius, true)) : null;
        NonMaxSuppression extractorMax = intensity.localMaximums() ? FactoryFeatureExtractor.nonmax(ConfigExtract.max(extractRadius, detectThreshold, extractRadius, true)) : null;
        FeatureSelectNBest<Point2D_I16> selector = new FeatureSelectNBest<Point2D_I16>(new SampleIntensityImage.I16());
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractorMin, extractorMax, selector);
        detector.setFeatureLimit(maxFeatures);
        AnyImageDerivative<T, D> deriv = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
        ImageFunctionSparse<T> sparseLaplace = FactoryDerivativeSparse.createLaplacian(imageType, null);
        return new FeatureLaplacePyramid(detector, sparseLaplace, deriv, 2.0);
    }

    public static <II extends ImageGray<II>> FastHessianFeatureDetector<II> fastHessian(@Nullable ConfigFastHessian config) {
        if (config == null) {
            config = new ConfigFastHessian();
        }
        config.checkValidity();
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(config.extract);
        FeatureSelectLimitIntensity<Point2D_I16> limitLevels = FactorySelectLimit.intensity(config.selector);
        FeatureSelectLimitIntensity<ScalePoint> limitAll = FactorySelectLimit.intensity(config.selector);
        FastHessianFeatureDetector alg = new FastHessianFeatureDetector(extractor, limitLevels, limitAll, config.initialSampleStep, config.initialSize, config.numberScalesPerOctave, config.numberOfOctaves, config.scaleStepSize);
        alg.maxFeaturesPerScale = config.maxFeaturesPerScale;
        alg.maxFeaturesAll = config.maxFeaturesAll;
        return alg;
    }

    public static SiftDetector sift(@Nullable ConfigSiftScaleSpace configSS, @Nullable ConfigSiftDetector configDetector) {
        if (configSS == null) {
            configSS = new ConfigSiftScaleSpace();
        }
        if (configDetector == null) {
            configDetector = new ConfigSiftDetector();
        }
        NonMaxLimiter nonmax = FactoryFeatureExtractor.nonmaxLimiter(configDetector.extract, configDetector.selector, configDetector.maxFeaturesPerScale);
        SiftScaleSpace ss = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        FeatureSelectLimitIntensity<ScalePoint> selectorAll = FactorySelectLimit.intensity(configDetector.selector);
        SiftDetector alg = new SiftDetector(ss, selectorAll, configDetector.edgeR, nonmax);
        alg.maxFeaturesAll = configDetector.maxFeaturesAll;
        return alg;
    }
}

