/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.disparity;

import boofcv.factory.disparity.ConfigDisparityError;
import boofcv.factory.disparity.DisparityError;
import boofcv.struct.Configuration;
import boofcv.struct.border.BorderType;

public class ConfigDisparityBM
implements Configuration {
    public int disparityMin = 0;
    public int disparityRange = 100;
    public int regionRadiusX = 3;
    public int regionRadiusY = 3;
    public double maxPerPixelError = 0.0;
    public int validateRtoL = 1;
    public double texture = 0.15;
    public boolean subpixel = true;
    public DisparityError errorType = DisparityError.CENSUS;
    public ConfigDisparityError.Census configCensus = new ConfigDisparityError.Census();
    public ConfigDisparityError.NCC configNCC = new ConfigDisparityError.NCC();
    public BorderType border = BorderType.REFLECT;

    public void setTo(ConfigDisparityBM src) {
        this.disparityMin = src.disparityMin;
        this.disparityRange = src.disparityRange;
        this.regionRadiusX = src.regionRadiusX;
        this.regionRadiusY = src.regionRadiusY;
        this.maxPerPixelError = src.maxPerPixelError;
        this.validateRtoL = src.validateRtoL;
        this.texture = src.texture;
        this.subpixel = src.subpixel;
        this.errorType = src.errorType;
        this.configCensus.setTo(src.configCensus);
        this.configNCC.setTo(src.configNCC);
        this.border = src.border;
    }

    @Override
    public void checkValidity() {
        if (this.disparityMin < 0) {
            throw new IllegalArgumentException("miDisparity < 0");
        }
        if (this.disparityRange < 1) {
            throw new IllegalArgumentException("rangeDisparity < 1");
        }
        if (this.border == BorderType.NORMALIZED || this.border == BorderType.SKIP) {
            throw new IllegalArgumentException("Normalized and Skip are not supported");
        }
    }
}

