/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.background;

import boofcv.factory.background.BaseConfigBackground;

public class ConfigBackgroundGmm
extends BaseConfigBackground {
    public float learningPeriod = 1000.0f;
    public float initialVariance = 400.0f;
    public float decayCoefient = 0.005f;
    public float maxDistance = 3.0f;
    public int numberOfGaussian = 5;
    public float significantWeight = 0.01f;

    public void setTo(ConfigBackgroundGmm src) {
        super.setTo(src);
        this.learningPeriod = src.learningPeriod;
        this.initialVariance = src.initialVariance;
        this.decayCoefient = src.decayCoefient;
        this.maxDistance = src.maxDistance;
        this.numberOfGaussian = src.numberOfGaussian;
        this.significantWeight = src.significantWeight;
    }

    @Override
    public void checkValidity() {
        if (this.learningPeriod <= 0.0f) {
            throw new IllegalArgumentException("Learning period must be more than zero");
        }
        if (this.decayCoefient < 0.0f) {
            throw new IllegalArgumentException("Decay coeffient must be more than or equal to zero");
        }
        if (this.initialVariance == 0.0f) {
            throw new IllegalArgumentException("Don't set initialVariance to zero, set it to Float.MIN_VALUE instead");
        }
        if (this.initialVariance <= 0.0f) {
            throw new IllegalArgumentException("Variance must be set to a value larger than zero");
        }
    }

    public String toString() {
        return "ConfigBackgroundGmm{learningPeriod=" + this.learningPeriod + ", initialVariance=" + this.initialVariance + ", decayCoefient=" + this.decayCoefient + ", maxDistance=" + this.maxDistance + ", numberOfGaussian=" + this.numberOfGaussian + ", significantWeight=" + this.significantWeight + ", unknownValue=" + this.unknownValue + '}';
    }
}

