/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.border;

import boofcv.alg.border.GrowBorder;
import boofcv.alg.border.GrowBorderSB;
import boofcv.core.image.border.BorderIndex1D_Extend;
import boofcv.core.image.border.BorderIndex1D_Reflect;
import boofcv.core.image.border.BorderIndex1D_Wrap;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder1D_F32;
import boofcv.struct.border.ImageBorder1D_F64;
import boofcv.struct.border.ImageBorder1D_IL_F32;
import boofcv.struct.border.ImageBorder1D_IL_F64;
import boofcv.struct.border.ImageBorder1D_IL_S32;
import boofcv.struct.border.ImageBorder1D_IL_S64;
import boofcv.struct.border.ImageBorder1D_S32;
import boofcv.struct.border.ImageBorder1D_S64;
import boofcv.struct.border.ImageBorderValue;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedInteger;
import boofcv.struct.image.InterleavedS64;

public class FactoryImageBorder {
    public static <T extends ImageBase<T>> GrowBorder<T, ?> createGrowBorder(ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case GRAY: {
                if (imageType.getDataType().isInteger()) {
                    switch (imageType.getDataType().getNumBits()) {
                        case 8: {
                            return new GrowBorderSB.SB_I8<T>(imageType);
                        }
                        case 16: {
                            return new GrowBorderSB.SB_I16<T>(imageType);
                        }
                        case 32: {
                            return new GrowBorderSB.SB_S32();
                        }
                        case 64: {
                            return new GrowBorderSB.SB_S64();
                        }
                    }
                    break;
                }
                switch (imageType.getDataType().getNumBits()) {
                    case 32: {
                        return new GrowBorderSB.SB_F32();
                    }
                    case 64: {
                        return new GrowBorderSB.SB_F64();
                    }
                }
                break;
            }
        }
        throw new IllegalArgumentException("image type not yet supported. " + (Object)((Object)imageType.getFamily()));
    }

    public static Class<ImageBorder> lookupBorderClassType(Class<ImageGray> imageType) {
        if (imageType == GrayF32.class) {
            return ImageBorder1D_F32.class;
        }
        if (imageType == GrayF64.class) {
            return ImageBorder1D_F64.class;
        }
        if (GrayI.class.isAssignableFrom(imageType)) {
            return ImageBorder1D_S32.class;
        }
        if (imageType == GrayS64.class) {
            return ImageBorder1D_S64.class;
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageBase<T>> ImageBorder<T> wrap(BorderType borderType, T image) {
        ImageBorder<T> ret = FactoryImageBorder.generic(borderType, image.getImageType());
        ret.setImage(image);
        return ret;
    }

    public static <T extends ImageBase<T>> ImageBorder<T> generic(BorderType borderType, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case GRAY: {
                return FactoryImageBorder.single(borderType, imageType.getImageClass());
            }
            case PLANAR: {
                return FactoryImageBorder.single(borderType, imageType.getImageClass());
            }
            case INTERLEAVED: {
                return FactoryImageBorder.interleaved(borderType, imageType.getImageClass());
            }
        }
        throw new IllegalArgumentException("Unknown family");
    }

    public static <T extends ImageBase<T>> ImageBorder<T> genericValue(double value, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case GRAY: {
                return FactoryImageBorder.singleValue(value, imageType.getImageClass());
            }
            case PLANAR: {
                return FactoryImageBorder.singleValue(value, imageType.getImageClass());
            }
            case INTERLEAVED: {
                return FactoryImageBorder.interleavedValue(value, imageType.getImageClass());
            }
        }
        throw new IllegalArgumentException("Unknown family");
    }

    public static <T extends ImageGray<T>, Border extends ImageBorder<T>> Border single(BorderType borderType, Class<T> imageType) {
        Class borderClass;
        switch (borderType) {
            case SKIP: {
                throw new IllegalArgumentException("Skip border can't be implemented here and has to be done externally. Instead pass in EXTENDED and manually skip over the in a pixel by pixel basis.");
            }
            case NORMALIZED: {
                throw new IllegalArgumentException("Normalized can't be supported by this border interface");
            }
            case REFLECT: {
                borderClass = BorderIndex1D_Reflect.class;
                break;
            }
            case EXTENDED: {
                borderClass = BorderIndex1D_Extend.class;
                break;
            }
            case WRAP: {
                borderClass = BorderIndex1D_Wrap.class;
                break;
            }
            case ZERO: {
                return (Border)FactoryImageBorder.singleValue(0.0, imageType);
            }
            default: {
                throw new IllegalArgumentException("Border type not supported: " + (Object)((Object)borderType));
            }
        }
        if (imageType == GrayF32.class) {
            return (Border)new ImageBorder1D_F32(borderClass);
        }
        if (imageType == GrayF64.class) {
            return (Border)new ImageBorder1D_F64(borderClass);
        }
        if (GrayI.class.isAssignableFrom(imageType)) {
            return (Border)new ImageBorder1D_S32(borderClass);
        }
        if (imageType == GrayS64.class) {
            return (Border)new ImageBorder1D_S64(borderClass);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageInterleaved<T>> ImageBorder<T> interleaved(BorderType borderType, Class<T> imageType) {
        Class borderClass;
        switch (borderType) {
            case SKIP: {
                throw new IllegalArgumentException("Skip border can't be implemented here and has to be done externally.  Call this might be a bug. Instead pass in EXTENDED and manually skip over the pixel in a loop some place.");
            }
            case NORMALIZED: {
                throw new IllegalArgumentException("Normalized can't be supported by this border interface");
            }
            case REFLECT: {
                borderClass = BorderIndex1D_Reflect.class;
                break;
            }
            case EXTENDED: {
                borderClass = BorderIndex1D_Extend.class;
                break;
            }
            case WRAP: {
                borderClass = BorderIndex1D_Wrap.class;
                break;
            }
            case ZERO: {
                return FactoryImageBorder.interleavedValue(0.0, imageType);
            }
            default: {
                throw new IllegalArgumentException("Border type not supported: " + (Object)((Object)borderType));
            }
        }
        if (imageType == InterleavedF32.class) {
            return new ImageBorder1D_IL_F32(borderClass);
        }
        if (imageType == InterleavedF64.class) {
            return new ImageBorder1D_IL_F64(borderClass);
        }
        if (InterleavedInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorder1D_IL_S32(borderClass);
        }
        if (imageType == InterleavedS64.class) {
            return new ImageBorder1D_IL_S64(borderClass);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageGray<T>> ImageBorder<T> singleValue(double value, T image) {
        ImageBorder<?> border = FactoryImageBorder.singleValue(value, image.getClass());
        border.setImage(image);
        return border;
    }

    public static <T extends ImageGray<T>> ImageBorder<T> singleValue(double value, Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new ImageBorderValue.Value_F32((float)value);
        }
        if (imageType == GrayF64.class) {
            return new ImageBorderValue.Value_F64(value);
        }
        if (GrayI.class.isAssignableFrom(imageType)) {
            return new ImageBorderValue.Value_I((int)value);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageInterleaved<T>> ImageBorder<T> interleavedValue(double value, T image) {
        ImageBorder<?> border = FactoryImageBorder.interleavedValue(value, image.getClass());
        border.setImage(image);
        return border;
    }

    public static <T extends ImageInterleaved<T>> ImageBorder<T> interleavedValue(double value, Class<T> imageType) {
        if (imageType == InterleavedF32.class) {
            return new ImageBorderValue.Value_IL_F32((float)value);
        }
        if (imageType == InterleavedF64.class) {
            return new ImageBorderValue.Value_IL_F64(value);
        }
        if (InterleavedInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorderValue.Value_IL_S32((int)value);
        }
        if (imageType == InterleavedS64.class) {
            return new ImageBorderValue.Value_IL_S64((long)value);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }
}

