/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.GImageGray;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;

public class GImageGrayDistorted<T extends ImageGray<T>>
implements GImageGray {
    PixelTransform<Point2D_F32> transform;
    InterpolatePixelS<T> interpolate;
    Point2D_F32 distorted = new Point2D_F32();
    int inputWidth;
    int inputHeight;

    public GImageGrayDistorted(PixelTransform<Point2D_F32> transform, InterpolatePixelS<T> interpolate) {
        this.transform = transform;
        this.interpolate = interpolate;
    }

    @Override
    public void wrap(ImageGray image) {
        this.interpolate.setImage(image);
        this.inputWidth = image.getWidth();
        this.inputHeight = image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.inputWidth;
    }

    @Override
    public int getHeight() {
        return this.inputHeight;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public Number get(int x, int y) {
        this.transform.compute(x, y, this.distorted);
        return Float.valueOf(this.interpolate.get(this.distorted.x, this.distorted.y));
    }

    @Override
    public void set(int x, int y, Number num) {
        throw new IllegalArgumentException("set is not supported");
    }

    @Override
    public double unsafe_getD(int x, int y) {
        this.transform.compute(x, y, this.distorted);
        return this.interpolate.get(this.distorted.x, this.distorted.y);
    }

    @Override
    public float unsafe_getF(int x, int y) {
        this.transform.compute(x, y, this.distorted);
        return this.interpolate.get(this.distorted.x, this.distorted.y);
    }

    @Override
    public void set(int index, float value) {
        throw new IllegalArgumentException("set is not supported");
    }

    @Override
    public float getF(int index) {
        throw new IllegalArgumentException("getF is not supported");
    }

    @Override
    public ImageGray getImage() {
        throw new IllegalArgumentException("getImage() is not supported");
    }

    @Override
    public Class getImageType() {
        throw new IllegalArgumentException("getImageType() is not supported");
    }
}

