/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.census;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.transform.census.impl.ImplCensusTransformBorder;
import boofcv.alg.transform.census.impl.ImplCensusTransformInner;
import boofcv.alg.transform.census.impl.ImplCensusTransformInner_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.InterleavedU16;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.jetbrains.annotations.Nullable;

public class CensusTransform {
    public static DogArray<Point2D_I32> createBlockSamples(int radius) {
        DogArray<Point2D_I32> samples = new DogArray<Point2D_I32>(Point2D_I32::new);
        int w = radius * 2 + 1;
        samples.reserve(w * w - 1);
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                if (x == 0 && y == 0) continue;
                samples.grow().setTo(x, y);
            }
        }
        return samples;
    }

    public static DogArray<Point2D_I32> createBlockSamples(int radiusX, int radiusY) {
        DogArray<Point2D_I32> samples = new DogArray<Point2D_I32>(Point2D_I32::new);
        int wx = radiusX * 2 + 1;
        int wy = radiusY * 2 + 1;
        samples.reserve(wx * wy - 1);
        for (int y = -radiusY; y <= radiusY; ++y) {
            for (int x = -radiusX; x <= radiusX; ++x) {
                if (x == 0 && y == 0) continue;
                samples.grow().setTo(x, y);
            }
        }
        return samples;
    }

    public static DogArray<Point2D_I32> createCircleSamples() {
        DogArray<Point2D_I32> samples = new DogArray<Point2D_I32>(Point2D_I32::new);
        for (int row = 0; row < 9; ++row) {
            int col0 = row <= 4 ? Math.max(0, 3 - row) : row - 5;
            int col1 = 9 - col0;
            for (int col = col0; col < col1; ++col) {
                if (row == 4 && col == 4) continue;
                samples.grow().setTo(row - 4, col - 4);
            }
        }
        return samples;
    }

    public static void dense3x3(GrayU8 input, GrayU8 output, @Nullable ImageBorder_S32<GrayU8> border) {
        InputSanityCheck.checkReshape(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.dense3x3(input, output);
        } else {
            ImplCensusTransformInner.dense3x3(input, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.dense3x3_U8(border, output);
        }
    }

    public static void dense3x3(GrayU16 input, GrayU8 output, @Nullable ImageBorder_S32<GrayU16> border) {
        InputSanityCheck.checkReshape(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.dense3x3(input, output);
        } else {
            ImplCensusTransformInner.dense3x3(input, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.dense3x3_U8(border, output);
        }
    }

    public static void dense3x3(GrayF32 input, GrayU8 output, @Nullable ImageBorder_F32 border) {
        InputSanityCheck.checkReshape(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.dense3x3(input, output);
        } else {
            ImplCensusTransformInner.dense3x3(input, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.dense3x3_F32(border, output);
        }
    }

    public static void dense5x5(GrayU8 input, GrayS32 output, @Nullable ImageBorder_S32<GrayU8> border) {
        InputSanityCheck.checkReshape(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.dense5x5(input, output);
        } else {
            ImplCensusTransformInner.dense5x5(input, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.dense5x5_U8(border, output);
        }
    }

    public static void dense5x5(GrayU16 input, GrayS32 output, @Nullable ImageBorder_S32<GrayU16> border) {
        InputSanityCheck.checkReshape(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.dense5x5(input, output);
        } else {
            ImplCensusTransformInner.dense5x5(input, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.dense5x5_U8(border, output);
        }
    }

    public static void dense5x5(GrayF32 input, GrayS32 output, @Nullable ImageBorder_F32 border) {
        InputSanityCheck.checkReshape(input, output);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.dense5x5(input, output);
        } else {
            ImplCensusTransformInner.dense5x5(input, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.dense5x5_F32(border, output);
        }
    }

    public static void sample_S64(GrayU8 input, FastAccess<Point2D_I32> sample, GrayS64 output, @Nullable ImageBorder_S32<GrayU8> border, @Nullable DogArray_I32 workSpace) {
        output.reshape(input.width, input.height);
        if (workSpace == null) {
            workSpace = new DogArray_I32();
        }
        int borderRadius = CensusTransform.computeRadiusWorkspace(input, sample, workSpace);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.sample_S64(input, borderRadius, workSpace, output);
        } else {
            ImplCensusTransformInner.sample_S64(input, borderRadius, workSpace, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.sample_S64(border, borderRadius, sample, output);
        }
    }

    public static void sample_S64(GrayU16 input, FastAccess<Point2D_I32> sample, GrayS64 output, @Nullable ImageBorder_S32<GrayU16> border, @Nullable DogArray_I32 workSpace) {
        output.reshape(input.width, input.height);
        if (workSpace == null) {
            workSpace = new DogArray_I32();
        }
        int borderRadius = CensusTransform.computeRadiusWorkspace(input, sample, workSpace);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.sample_S64(input, borderRadius, workSpace, output);
        } else {
            ImplCensusTransformInner.sample_S64(input, borderRadius, workSpace, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.sample_S64(border, borderRadius, sample, output);
        }
    }

    public static void sample_S64(GrayF32 input, FastAccess<Point2D_I32> sample, GrayS64 output, @Nullable ImageBorder_F32 border, @Nullable DogArray_I32 workSpace) {
        output.reshape(input.width, input.height);
        if (workSpace == null) {
            workSpace = new DogArray_I32();
        }
        int borderRadius = CensusTransform.computeRadiusWorkspace(input, sample, workSpace);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.sample_S64(input, borderRadius, workSpace, output);
        } else {
            ImplCensusTransformInner.sample_S64(input, borderRadius, workSpace, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.sample_S64(border, borderRadius, sample, output);
        }
    }

    public static void sample_IU16(GrayU8 input, FastAccess<Point2D_I32> sample, InterleavedU16 output, @Nullable ImageBorder_S32<GrayU8> border, @Nullable DogArray_I32 workSpace) {
        int numBlocks = BoofMiscOps.bitsToWords(sample.size, 16);
        output.reshape(input.width, input.height, numBlocks);
        if (workSpace == null) {
            workSpace = new DogArray_I32();
        }
        int borderRadius = CensusTransform.computeRadiusWorkspace(input, sample, workSpace);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.sample_IU16(input, borderRadius, workSpace, output);
        } else {
            ImplCensusTransformInner.sample_IU16(input, borderRadius, workSpace, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.sample_IU16(border, borderRadius, sample, output);
        }
    }

    public static void sample_IU16(GrayU16 input, FastAccess<Point2D_I32> sample, InterleavedU16 output, @Nullable ImageBorder_S32<GrayU16> border, @Nullable DogArray_I32 workSpace) {
        int numBlocks = BoofMiscOps.bitsToWords(sample.size, 16);
        output.reshape(input.width, input.height, numBlocks);
        if (workSpace == null) {
            workSpace = new DogArray_I32();
        }
        int borderRadius = CensusTransform.computeRadiusWorkspace(input, sample, workSpace);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.sample_IU16(input, borderRadius, workSpace, output);
        } else {
            ImplCensusTransformInner.sample_IU16(input, borderRadius, workSpace, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.sample_IU16(border, borderRadius, sample, output);
        }
    }

    public static void sample_IU16(GrayF32 input, FastAccess<Point2D_I32> sample, InterleavedU16 output, @Nullable ImageBorder_F32 border, @Nullable DogArray_I32 workSpace) {
        int numBlocks = BoofMiscOps.bitsToWords(sample.size, 16);
        output.reshape(input.width, input.height, numBlocks);
        if (workSpace == null) {
            workSpace = new DogArray_I32();
        }
        int borderRadius = CensusTransform.computeRadiusWorkspace(input, sample, workSpace);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplCensusTransformInner_MT.sample_IU16(input, borderRadius, workSpace, output);
        } else {
            ImplCensusTransformInner.sample_IU16(input, borderRadius, workSpace, output);
        }
        if (border != null) {
            border.setImage(input);
            ImplCensusTransformBorder.sample_IU16(border, borderRadius, sample, output);
        }
    }

    private static int computeRadiusWorkspace(ImageBase input, FastAccess<Point2D_I32> sample, DogArray_I32 workSpace) {
        int radius = 0;
        workSpace.resize(sample.size);
        for (int i = 0; i < sample.size; ++i) {
            Point2D_I32 p = sample.get(i);
            workSpace.data[i] = p.y * input.stride + p.x;
            radius = Math.max(radius, Math.abs(p.x));
            radius = Math.max(radius, Math.abs(p.y));
        }
        return radius;
    }
}

