/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.tracker.tld.TldFernFeature;
import java.util.ArrayDeque;

public class TldFernManager {
    TldFernFeature[] table;
    ArrayDeque<TldFernFeature> unusedFern = new ArrayDeque();

    public TldFernManager(int descriptorSize) {
        int N = 1 << descriptorSize;
        this.table = new TldFernFeature[N];
    }

    public TldFernFeature lookupFern(int value) {
        TldFernFeature found = this.table[value];
        if (found == null) {
            found = this.createFern();
            found.init(value);
            this.table[value] = found;
        }
        return found;
    }

    public double lookupPosterior(int value) {
        TldFernFeature found = this.table[value];
        if (found == null) {
            return 0.0;
        }
        return found.posterior;
    }

    public void reset() {
        for (int i = 0; i < this.table.length; ++i) {
            TldFernFeature f = this.table[i];
            if (f == null) continue;
            this.unusedFern.add(f);
            this.table[i] = null;
        }
    }

    protected TldFernFeature createFern() {
        if (this.unusedFern.size() > 0) {
            return this.unusedFern.pop();
        }
        return new TldFernFeature();
    }
}

