/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.alg.sfm.structure.PairwiseGraphUtils;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.sorting.QuickSort_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class SelectNeighborsAroundView
implements VerbosePrint {
    public int maxViews = 10;
    public int worstOfTop = 3;
    public int minNeighbors = 2;
    public PairwiseGraphUtils.ScoreMotion scoreMotion = new PairwiseGraphUtils.DefaultScoreMotion();
    protected final SceneWorkingGraph localWorking = new SceneWorkingGraph();
    @Nullable
    private PrintStream verbose;
    int remainingNeighbors;
    List<SceneWorkingGraph.View> candidates = new ArrayList<SceneWorkingGraph.View>();
    Map<String, SceneWorkingGraph.View> lookup = new HashMap<String, SceneWorkingGraph.View>();
    DogArray<EdgeScore> edges = new DogArray<EdgeScore>(EdgeScore::new);
    Set<String> hasFeatures = new HashSet<String>();
    DogArray_F64 connScores = new DogArray_F64();
    QuickSort_F64 sorter = new QuickSort_F64();

    public void process(SceneWorkingGraph.View target, SceneWorkingGraph working) {
        this.initialize();
        this.addNeighbors2(target, working);
        this.pruneViews(target);
        this.createLocalGraph(target, working);
    }

    void initialize() {
        this.edges.reset();
        this.candidates.clear();
        this.lookup.clear();
        this.localWorking.reset();
    }

    void addNeighbors2(SceneWorkingGraph.View seed, SceneWorkingGraph working) {
        SceneWorkingGraph.View c;
        int candIdx;
        this.lookup.put(seed.pview.id, seed);
        for (int connIdx = 0; connIdx < seed.pview.connections.size; ++connIdx) {
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)seed.pview.connections.get(connIdx);
            SceneWorkingGraph.View o = working.lookupView(m.other((PairwiseImageGraph.View)seed.pview).id);
            if (o == null) continue;
            this.addCandidateView(o);
        }
        this.remainingNeighbors = this.candidates.size();
        for (candIdx = this.candidates.size() - 1; candIdx >= 0; --candIdx) {
            c = this.candidates.get(candIdx);
            for (int connIdx = 0; connIdx < c.pview.connections.size; ++connIdx) {
                PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)c.pview.connections.get(connIdx);
                SceneWorkingGraph.View o = working.lookupView(m.other((PairwiseImageGraph.View)c.pview).id);
                if (o == null || this.lookup.containsKey(o.pview.id)) continue;
                this.addCandidateView(o);
            }
        }
        this.addEdgesOf(working, seed);
        for (candIdx = 0; candIdx < this.candidates.size(); ++candIdx) {
            c = this.candidates.get(candIdx);
            this.addEdgesOf(working, c);
        }
    }

    void addCandidateView(SceneWorkingGraph.View o) {
        this.candidates.add(o);
        this.lookup.put(o.pview.id, o);
    }

    private void addEdgesOf(SceneWorkingGraph working, SceneWorkingGraph.View c) {
        for (int connIdx = 0; connIdx < c.pview.connections.size; ++connIdx) {
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)c.pview.connections.get(connIdx);
            SceneWorkingGraph.View o = working.lookupView(m.other((PairwiseImageGraph.View)c.pview).id);
            if (o == null || !this.lookup.containsKey(o.pview.id) || c.pview.id.compareTo(o.pview.id) >= 0) continue;
            this.addEdge(m);
        }
    }

    void pruneViews(SceneWorkingGraph.View seed) {
        if (this.verbose != null) {
            this.verbose.println("ENTER pruneViews target=" + seed.pview.id);
        }
        while (this.candidates.size() > this.maxViews - 1) {
            double scoreDst;
            PairwiseImageGraph.Motion m;
            int lowestIndex = -1;
            double lowestScore = Double.MAX_VALUE;
            for (int i = 0; i < this.edges.size; ++i) {
                EdgeScore s = (EdgeScore)this.edges.get(i);
                if (s.score >= lowestScore || this.remainingNeighbors <= this.minNeighbors && s.m.isConnected(seed.pview)) continue;
                lowestScore = s.score;
                lowestIndex = i;
            }
            if (lowestIndex < 0) {
                throw new RuntimeException("Highly likely that this is miss configured. No valid candidate has been found for removal. Is 'minNeighbors' >= maxViews-1?");
            }
            if (this.verbose != null) {
                this.verbose.println("Pruning score=" + lowestScore + " " + ((EdgeScore)this.edges.get((int)lowestIndex)).m);
            }
            if ((m = ((EdgeScore)this.edges.get((int)lowestIndex)).m).isConnected(seed.pview)) {
                this.removeCandidateNode(m.other((PairwiseImageGraph.View)seed.pview).id, seed);
                if (this.verbose == null) continue;
                this.verbose.println("Connects to target. No need to score. neighbors=" + this.remainingNeighbors);
                continue;
            }
            double scoreSrc = this.remainingNeighbors <= this.minNeighbors && m.src.findMotion(seed.pview) != null ? Double.MAX_VALUE : this.scoreForRemoval(m.src, m);
            double d = scoreDst = this.remainingNeighbors <= this.minNeighbors && m.dst.findMotion(seed.pview) != null ? Double.MAX_VALUE : this.scoreForRemoval(m.dst, m);
            if (this.verbose != null) {
                this.verbose.println("Scores: src=" + scoreSrc + " dst=" + scoreDst);
            }
            this.removeCandidateNode((scoreSrc < scoreDst ? m.src : m.dst).id, seed);
        }
    }

    double scoreForRemoval(PairwiseImageGraph.View v, PairwiseImageGraph.Motion ignore) {
        this.connScores.reset();
        for (int connIdx = 0; connIdx < v.connections.size; ++connIdx) {
            String o;
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)v.connections.get(connIdx);
            if (m == ignore || !this.lookup.containsKey(o = m.other((PairwiseImageGraph.View)v).id)) continue;
            this.connScores.add(this.scoreMotion.score(m));
        }
        if (this.connScores.size == 0) {
            return 0.0;
        }
        this.connScores.sort(this.sorter);
        int idx = Math.max(0, this.connScores.size - this.worstOfTop);
        return this.connScores.get(idx);
    }

    void removeCandidateNode(String id, SceneWorkingGraph.View seed) {
        if (this.verbose != null) {
            this.verbose.println("Removing candidate view='" + id + "'");
        }
        SceneWorkingGraph.View v = this.lookup.remove(id);
        BoofMiscOps.checkTrue(this.candidates.remove(v));
        if (null != v.pview.findMotion(seed.pview)) {
            --this.remainingNeighbors;
            if (this.verbose != null) {
                this.verbose.println("Neighbor of seed has been removed. view='" + id + "'  remaining=" + this.remainingNeighbors);
            }
        }
        for (int connIdx = 0; connIdx < v.pview.connections.size; ++connIdx) {
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)v.pview.connections.get(connIdx);
            SceneWorkingGraph.View o = this.lookup.get(m.other((PairwiseImageGraph.View)v.pview).id);
            if (o == null) continue;
            if (this.isOrphan(o)) {
                if (this.verbose != null) {
                    this.verbose.println("Removing orphaned view='" + o.pview.id + "'");
                }
                BoofMiscOps.checkTrue(null != this.lookup.remove(o.pview.id), "Not in lookup list");
                BoofMiscOps.checkTrue(this.candidates.remove(o), "Can't remove. Not in candidate list");
            }
            boolean found = false;
            for (int i = 0; i < this.edges.size; ++i) {
                if (((EdgeScore)this.edges.get((int)i)).m != m) continue;
                this.edges.removeSwap(i);
                found = true;
                break;
            }
            BoofMiscOps.checkTrue(found, "No matching edge found. BUG. id='" + id + "' m.other='" + o.pview.id + "'");
        }
    }

    boolean isOrphan(SceneWorkingGraph.View v) {
        for (int connIdx = 0; connIdx < v.pview.connections.size; ++connIdx) {
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)v.pview.connections.get(connIdx);
            String o = m.other((PairwiseImageGraph.View)v.pview).id;
            if (!this.lookup.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    void createLocalGraph(SceneWorkingGraph.View seed, SceneWorkingGraph working) {
        int i;
        this.hasFeatures.clear();
        this.addViewToLocal(seed);
        for (i = 0; i < this.candidates.size(); ++i) {
            this.addViewToLocal(this.candidates.get(i));
        }
        for (i = 0; i < this.candidates.size(); ++i) {
            SceneWorkingGraph.View origView = this.localWorking.lookupView(this.candidates.get((int)i).pview.id);
            Objects.requireNonNull(origView);
            if (this.hasFeatures.contains(origView.pview.id)) continue;
            for (int connIdx = 0; connIdx < origView.pview.connections.size; ++connIdx) {
                PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)origView.pview.connections.get(connIdx);
                SceneWorkingGraph.View v = working.lookupView(m.other((PairwiseImageGraph.View)origView.pview).id);
                if (v == null || v.inliers.isEmpty()) continue;
                for (int j = 0; j < v.inliers.views.size; ++j) {
                    if (!((PairwiseImageGraph.View)v.inliers.views.get((int)j)).id.equals(origView.pview.id)) continue;
                    origView.inliers.views.add(origView.pview);
                    origView.inliers.observations.grow().setTo((DogArray_I32)v.inliers.observations.get(j));
                    break;
                }
                if (!origView.inliers.isEmpty()) break;
            }
            BoofMiscOps.checkTrue(!origView.inliers.isEmpty(), "BUG! there can be no estimated state if it was never in an inlier list of a neighbor. view.id=" + origView.pview.id);
        }
    }

    void addViewToLocal(SceneWorkingGraph.View origView) {
        SceneWorkingGraph.View localView = this.localWorking.addView(origView.pview);
        localView.intrinsic.setTo(origView.intrinsic);
        localView.world_to_view.setTo(origView.world_to_view);
        localView.imageDimension.setTo(origView.imageDimension);
        if (origView.inliers.isEmpty()) {
            return;
        }
        for (int i = 0; i < origView.inliers.views.size; ++i) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)origView.inliers.views.get(i);
            if (!this.lookup.containsKey(pview.id)) continue;
            this.hasFeatures.add(pview.id);
            localView.inliers.views.add(pview);
            localView.inliers.observations.grow().setTo((DogArray_I32)origView.inliers.observations.get(i));
        }
    }

    private void addEdge(PairwiseImageGraph.Motion m) {
        EdgeScore edgeScore = this.edges.grow();
        edgeScore.m = m;
        edgeScore.score = this.scoreMotion.score(m);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public SceneWorkingGraph getLocalWorking() {
        return this.localWorking;
    }

    static class EdgeScore {
        PairwiseImageGraph.Motion m;
        double score;

        EdgeScore() {
        }
    }
}

