/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.alg.sfm.structure.PairwiseGraphUtils;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.struct.ScoreIndex;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public abstract class ReconstructionFromPairwiseGraph
implements VerbosePrint {
    public final SceneWorkingGraph workGraph = new SceneWorkingGraph();
    protected PairwiseGraphUtils utils;
    @Nullable
    protected PrintStream verbose;
    DogArray<ScoreIndex> scoresMotions = new DogArray<ScoreIndex>(ScoreIndex::new);
    HashSet<String> exploredViews = new HashSet();
    DogArray<SeedInfo> seedScores = new DogArray<SeedInfo>(SeedInfo::new, SeedInfo::reset);

    protected ReconstructionFromPairwiseGraph(PairwiseGraphUtils utils) {
        this.utils = utils;
    }

    protected FastArray<PairwiseImageGraph.View> findAllOpenViews() {
        FastArray<PairwiseImageGraph.View> found = new FastArray<PairwiseImageGraph.View>(PairwiseImageGraph.View.class);
        for (SceneWorkingGraph.View wview : this.workGraph.getAllViews()) {
            this.addOpenForView(wview.pview, found);
        }
        return found;
    }

    protected void addOpenForView(PairwiseImageGraph.View view, FastArray<PairwiseImageGraph.View> found) {
        for (PairwiseImageGraph.Motion c : view.connections.toList()) {
            if (!c.is3D) continue;
            PairwiseImageGraph.View o = c.other(view);
            if (this.exploredViews.contains(o.id) || found.contains(o)) continue;
            if (this.verbose != null) {
                this.verbose.println("  Adding to open list view.id='" + o.id + "'");
            }
            found.add(o);
            this.exploredViews.add(o.id);
        }
    }

    protected PairwiseImageGraph.View selectNextToProcess(FastArray<PairwiseImageGraph.View> open) {
        int bestIdx = -1;
        double bestScore = 0.0;
        int bestValidCount = 0;
        ArrayList<PairwiseImageGraph.View> valid = new ArrayList<PairwiseImageGraph.View>();
        for (int openIdx = 0; openIdx < open.size; ++openIdx) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)open.get(openIdx);
            valid.clear();
            for (int connIdx = 0; connIdx < pview.connections.size; ++connIdx) {
                PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)pview.connections.get(connIdx);
                PairwiseImageGraph.View dst = m.other(pview);
                if (!m.is3D || !this.workGraph.isKnown(dst)) continue;
                valid.add(dst);
            }
            double bestLocalScore = 0.0;
            for (int idx0 = 0; idx0 < valid.size(); ++idx0) {
                PairwiseImageGraph.View dst = (PairwiseImageGraph.View)valid.get(idx0);
                for (int idx1 = idx0 + 1; idx1 < valid.size(); ++idx1) {
                    if (null == dst.findMotion((PairwiseImageGraph.View)valid.get(idx1))) continue;
                    PairwiseImageGraph.Motion m0 = pview.findMotion(dst);
                    PairwiseImageGraph.Motion m1 = pview.findMotion((PairwiseImageGraph.View)valid.get(idx1));
                    PairwiseImageGraph.Motion m2 = dst.findMotion((PairwiseImageGraph.View)valid.get(idx1));
                    double s = Math.min(this.utils.scoreMotion.score(m0), this.utils.scoreMotion.score(m1));
                    s = Math.min(s, this.utils.scoreMotion.score(m2));
                    bestLocalScore = Math.max(s, bestLocalScore);
                }
            }
            if (Math.min(3, valid.size()) < bestValidCount || !(bestLocalScore > bestScore)) continue;
            bestValidCount = Math.min(3, valid.size());
            bestScore = bestLocalScore;
            bestIdx = openIdx;
        }
        if (bestIdx < 0) {
            if (this.verbose != null) {
                this.verbose.println("  Failed to find a valid view to connect. open.size=" + open.size);
                for (int i = 0; i < open.size; ++i) {
                    PairwiseImageGraph.View v = (PairwiseImageGraph.View)open.get(i);
                    this.verbose.print("    id='" + v.id + "' conn={ ");
                    for (int j = 0; j < v.connections.size; ++j) {
                        this.verbose.print("'" + ((PairwiseImageGraph.Motion)v.connections.get((int)j)).other((PairwiseImageGraph.View)v).id + "' ");
                    }
                    this.verbose.println("}");
                }
            }
            return null;
        }
        PairwiseImageGraph.View selected = open.removeSwap(bestIdx);
        if (this.verbose != null) {
            this.verbose.println("  open.size=" + open.size + " selected.id='" + selected.id + "' score=" + bestScore + " conn=" + bestValidCount);
        }
        return selected;
    }

    protected Map<String, SeedInfo> scoreNodesAsSeeds(PairwiseImageGraph graph) {
        this.seedScores.reset();
        HashMap<String, SeedInfo> mapScores = new HashMap<String, SeedInfo>();
        for (int idxView = 0; idxView < graph.nodes.size; ++idxView) {
            PairwiseImageGraph.View v = (PairwiseImageGraph.View)graph.nodes.get(idxView);
            SeedInfo info = this.seedScores.grow();
            this.scoreAsSeed(v, info);
            mapScores.put(v.id, info);
        }
        return mapScores;
    }

    protected List<SeedInfo> selectSeeds(DogArray<SeedInfo> candidates, Map<String, SeedInfo> lookupInfo) {
        ArrayList<SeedInfo> seeds = new ArrayList<SeedInfo>();
        Collections.sort(candidates.toList());
        double minScore = ((SeedInfo)candidates.get((int)(candidates.size() - 1))).score * 0.2;
        int rejectedNeighbor = 0;
        int rejectedScore = 0;
        int rejectedClose = 0;
        for (int i = candidates.size() - 1; i >= 0; --i) {
            int j;
            SeedInfo s = (SeedInfo)candidates.get(i);
            if (s.neighbor) {
                ++rejectedNeighbor;
                continue;
            }
            if (s.score <= minScore) {
                ++rejectedScore;
                break;
            }
            boolean skip = false;
            for (j = 0; j < s.seed.connections.size; ++j) {
                if (!lookupInfo.get((Object)((PairwiseImageGraph.Motion)s.seed.connections.get((int)j)).other((PairwiseImageGraph.View)s.seed).id).neighbor) continue;
                ++rejectedClose;
                skip = true;
                break;
            }
            if (skip) continue;
            seeds.add(s);
            for (j = 0; j < s.seed.connections.size; ++j) {
                lookupInfo.get((Object)((PairwiseImageGraph.Motion)s.seed.connections.get((int)j)).other((PairwiseImageGraph.View)s.seed).id).neighbor = true;
            }
        }
        if (this.verbose != null) {
            this.verbose.printf("Seed Rejections: neighbor=%3d score=%3d close=%d\n", rejectedNeighbor, rejectedScore, rejectedClose);
        }
        return seeds;
    }

    protected SeedInfo scoreAsSeed(PairwiseImageGraph.View target, SeedInfo output) {
        int i;
        output.seed = target;
        this.scoresMotions.reset();
        for (i = 0; i < target.connections.size; ++i) {
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)target.connections.get(i);
            if (!m.is3D) continue;
            this.scoresMotions.grow().set(this.utils.scoreMotion.score(m), i);
        }
        Collections.sort(this.scoresMotions.toList());
        for (i = Math.min(3, this.scoresMotions.size) - 1; i >= 0; --i) {
            output.motions.add(((ScoreIndex)this.scoresMotions.get((int)i)).index);
            output.score += ((ScoreIndex)this.scoresMotions.get((int)i)).score;
        }
        return output;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public SceneWorkingGraph getWorkGraph() {
        return this.workGraph;
    }

    protected static class SeedInfo
    implements Comparable<SeedInfo> {
        PairwiseImageGraph.View seed;
        double score;
        DogArray_I32 motions = new DogArray_I32();
        boolean neighbor = false;

        protected SeedInfo() {
        }

        public void reset() {
            this.seed = null;
            this.score = 0.0;
            this.motions.reset();
            this.neighbor = false;
        }

        @Override
        public int compareTo(SeedInfo o) {
            return Double.compare(this.score, o.score);
        }
    }
}

