/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.sfm.structure.ConfigProjectiveReconstruction;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.PairwiseGraphUtils;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.ProjectiveExpandByOneView;
import boofcv.alg.sfm.structure.ProjectiveInitializeAllCommon;
import boofcv.alg.sfm.structure.ReconstructionFromPairwiseGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrixRMaj;

public class ProjectiveReconstructionFromPairwiseGraph
extends ReconstructionFromPairwiseGraph {
    private final ProjectiveInitializeAllCommon initProjective = new ProjectiveInitializeAllCommon();
    private final ProjectiveExpandByOneView expandProjective;

    public ProjectiveReconstructionFromPairwiseGraph(PairwiseGraphUtils utils) {
        super(utils);
        this.initProjective.utils = utils;
        this.expandProjective = new ProjectiveExpandByOneView();
        this.expandProjective.utils = utils;
    }

    public ProjectiveReconstructionFromPairwiseGraph(ConfigProjectiveReconstruction config) {
        this(new PairwiseGraphUtils(config));
    }

    public ProjectiveReconstructionFromPairwiseGraph() {
        this(new ConfigProjectiveReconstruction());
    }

    public boolean process(LookUpSimilarImages db, PairwiseImageGraph graph) {
        this.exploredViews.clear();
        this.workGraph.reset();
        Map<String, ReconstructionFromPairwiseGraph.SeedInfo> mapScores = this.scoreNodesAsSeeds(graph);
        List<ReconstructionFromPairwiseGraph.SeedInfo> seeds = this.selectSeeds(this.seedScores, mapScores);
        if (seeds.size() == 0) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Selected " + seeds.size() + " seeds out of " + graph.nodes.size + " nodes");
        }
        ReconstructionFromPairwiseGraph.SeedInfo info = seeds.get(0);
        DogArray_I32 common = this.utils.findCommonFeatures(info.seed, info.motions);
        if (common.size < 6) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Selected seed.id=" + info.seed.id + " common=" + common.size);
        }
        if (!this.estimateInitialSceneFromSeed(db, info, common)) {
            return false;
        }
        this.expandScene(db);
        if (this.verbose != null) {
            this.verbose.println("Done");
        }
        return true;
    }

    private boolean estimateInitialSceneFromSeed(LookUpSimilarImages db, ReconstructionFromPairwiseGraph.SeedInfo info, DogArray_I32 common) {
        if (!this.initProjective.projectiveSceneN(db, info.seed, common, info.motions)) {
            if (this.verbose != null) {
                this.verbose.println("Failed initialize seed");
            }
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Saving initial seed camera matrices");
        }
        for (int structViewIdx = 0; structViewIdx < this.initProjective.utils.structure.views.size; ++structViewIdx) {
            PairwiseImageGraph.View view = this.initProjective.getPairwiseGraphViewByStructureIndex(structViewIdx);
            if (this.verbose != null) {
                this.verbose.println("  view.id=`" + view.id + "`");
            }
            DMatrixRMaj cameraMatrix = ((SceneStructureProjective.View)this.initProjective.utils.structure.views.get((int)structViewIdx)).worldToView;
            this.workGraph.addView((PairwiseImageGraph.View)view).projective.set(cameraMatrix);
            this.exploredViews.add(view.id);
        }
        this.utils.saveRansacInliers(this.workGraph.lookupView(this.utils.seed.id));
        return true;
    }

    private void expandScene(LookUpSimilarImages db) {
        if (this.verbose != null) {
            this.verbose.println("ENTER Expanding Scene:");
        }
        FastArray<PairwiseImageGraph.View> open = this.findAllOpenViews();
        DMatrixRMaj cameraMatrix = new DMatrixRMaj(3, 4);
        while (open.size > 0) {
            PairwiseImageGraph.View selected = this.selectNextToProcess(open);
            if (selected == null) {
                if (this.verbose == null) break;
                this.verbose.println("  No valid views left. open.size=" + open.size);
                break;
            }
            if (!this.expandProjective.process(db, this.workGraph, selected, cameraMatrix)) {
                if (this.verbose == null) continue;
                this.verbose.println("  Failed to expand/add view=" + selected.id + ". Discarding.");
                continue;
            }
            if (this.verbose != null) {
                this.verbose.println("  Success Expanding: view=" + selected.id + "  inliers=" + this.utils.inliersThreeView.size() + " / " + this.utils.matchesTriple.size);
            }
            SceneWorkingGraph.View wview = this.workGraph.addView(selected);
            wview.projective.set(cameraMatrix);
            BoofMiscOps.checkTrue(this.utils.seed == wview.pview);
            this.utils.saveRansacInliers(wview);
            this.addOpenForView(wview.pview, open);
        }
        if (this.verbose != null) {
            this.verbose.println("EXIT Expanding Scene");
        }
    }

    public ProjectiveInitializeAllCommon getInitProjective() {
        return this.initProjective;
    }

    public ProjectiveExpandByOneView getExpandProjective() {
        return this.expandProjective;
    }
}

