/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.sfm.structure.ConfigProjectiveReconstruction;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.MetricExpandByOneView;
import boofcv.alg.sfm.structure.PairwiseGraphUtils;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.ProjectiveInitializeAllCommon;
import boofcv.alg.sfm.structure.ReconstructionFromPairwiseGraph;
import boofcv.alg.sfm.structure.RefineMetricWorkingGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.factory.geo.ConfigSelfCalibDualQuadratic;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedTupleDN;
import boofcv.struct.image.ImageDimension;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrixRMaj;

public class MetricFromUncalibratedPairwiseGraph
extends ReconstructionFromPairwiseGraph {
    private final ProjectiveInitializeAllCommon initProjective;
    private ProjectiveToMetricCameras projectiveToMetric = FactoryMultiView.projectiveToMetric((ConfigSelfCalibDualQuadratic)null);
    private final MetricExpandByOneView expandMetric = new MetricExpandByOneView();
    private final RefineMetricWorkingGraph refineWorking = new RefineMetricWorkingGraph();

    public MetricFromUncalibratedPairwiseGraph(PairwiseGraphUtils utils) {
        super(utils);
        this.refineWorking.bundleAdjustment.keepFraction = 0.95;
        this.initProjective = new ProjectiveInitializeAllCommon();
        this.initProjective.utils = utils;
        this.expandMetric.utils = utils;
    }

    public MetricFromUncalibratedPairwiseGraph(ConfigProjectiveReconstruction config) {
        this(new PairwiseGraphUtils(config));
    }

    public MetricFromUncalibratedPairwiseGraph() {
        this(new ConfigProjectiveReconstruction());
    }

    public boolean process(LookUpSimilarImages db, PairwiseImageGraph graph) {
        this.exploredViews.clear();
        this.workGraph.reset();
        Map<String, ReconstructionFromPairwiseGraph.SeedInfo> mapScores = this.scoreNodesAsSeeds(graph);
        List<ReconstructionFromPairwiseGraph.SeedInfo> seeds = this.selectSeeds(this.seedScores, mapScores);
        if (seeds.size() == 0) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Selected seeds.size=" + seeds.size() + " seeds out of " + graph.nodes.size + " nodes");
        }
        ReconstructionFromPairwiseGraph.SeedInfo info = seeds.get(0);
        DogArray_I32 common = this.utils.findCommonFeatures(info.seed, info.motions);
        if (common.size < 6) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Selected seed.id='" + info.seed.id + "' common=" + common.size);
        }
        if (!this.estimateProjectiveSceneFromSeed(db, info, common)) {
            return false;
        }
        if (!this.projectiveSeedToMetric(graph)) {
            return false;
        }
        this.refineWorking.process(db, this.workGraph);
        this.expandMetricScene(db);
        if (this.verbose != null) {
            this.verbose.println("Done");
        }
        return true;
    }

    private boolean estimateProjectiveSceneFromSeed(LookUpSimilarImages db, ReconstructionFromPairwiseGraph.SeedInfo info, DogArray_I32 common) {
        if (!this.initProjective.projectiveSceneN(db, info.seed, common, info.motions)) {
            if (this.verbose != null) {
                this.verbose.println("Failed initialize seed");
            }
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Saving initial seed camera matrices");
        }
        for (int structViewIdx = 0; structViewIdx < this.initProjective.utils.structure.views.size; ++structViewIdx) {
            PairwiseImageGraph.View view = this.initProjective.getPairwiseGraphViewByStructureIndex(structViewIdx);
            if (this.verbose == null) continue;
            this.verbose.println("  view.id=`" + view.id + "`");
        }
        return true;
    }

    private boolean projectiveSeedToMetric(PairwiseImageGraph graph) {
        ArrayList<String> viewIds = new ArrayList<String>();
        DogArray<ImageDimension> dimensions = new DogArray<ImageDimension>(ImageDimension::new);
        DogArray<DMatrixRMaj> views = new DogArray<DMatrixRMaj>(() -> new DMatrixRMaj(3, 4));
        DogArray<AssociatedTupleDN> observations = new DogArray<AssociatedTupleDN>(AssociatedTupleDN::new);
        this.initProjective.lookupInfoForMetricElevation(viewIds, dimensions, views, observations);
        MetricCameras results = new MetricCameras();
        if (!this.projectiveToMetric.process(dimensions.toList(), views.toList(), observations.toList(), results)) {
            if (this.verbose != null) {
                this.verbose.println("Failed to elevate initial seed to metric");
            }
            return false;
        }
        this.saveMetricSeed(graph, viewIds, dimensions.toList(), this.initProjective.getInlierToSeed(), this.initProjective.getInlierIndexes(), results);
        return true;
    }

    void saveMetricSeed(PairwiseImageGraph graph, List<String> viewIds, List<ImageDimension> dimensions, DogArray_I32 inlierToSeed, DogArray<DogArray_I32> inlierToOther, MetricCameras results) {
        BoofMiscOps.checkEq(viewIds.size(), results.motion_1_to_k.size + 1, "Implicit view[0] no included");
        for (int i = 0; i < viewIds.size(); ++i) {
            PairwiseImageGraph.View pview = graph.lookupNode(viewIds.get(i));
            SceneWorkingGraph.View wview = this.workGraph.addView(pview);
            if (i > 0) {
                wview.world_to_view.setTo((Se3_F64)results.motion_1_to_k.get(i - 1));
            }
            BundleAdjustmentOps.convert((CameraPinhole)results.intrinsics.get(i), wview.intrinsic);
            wview.imageDimension.setTo(dimensions.get(i));
        }
        SceneWorkingGraph.View wtarget = this.workGraph.lookupView(viewIds.get(0));
        BoofMiscOps.checkEq(wtarget.inliers.views.size, 0, "There should be at most one set of inliers per view");
        SceneWorkingGraph.InlierInfo inliers = wtarget.inliers;
        inliers.views.resize(viewIds.size());
        inliers.observations.resize(viewIds.size());
        for (int viewIdx = 0; viewIdx < viewIds.size(); ++viewIdx) {
            inliers.views.set(viewIdx, graph.lookupNode(viewIds.get(viewIdx)));
            if (viewIdx == 0) {
                ((DogArray_I32)inliers.observations.get(0)).setTo(inlierToSeed);
                BoofMiscOps.checkTrue(((DogArray_I32)inliers.observations.get((int)0)).size > 0, "There should be observations");
                continue;
            }
            ((DogArray_I32)inliers.observations.get(viewIdx)).setTo((DogArray_I32)inlierToOther.get(viewIdx - 1));
            BoofMiscOps.checkEq(((DogArray_I32)inliers.observations.get((int)viewIdx)).size, ((DogArray_I32)inliers.observations.get((int)0)).size, "Each view should have the same number of observations");
        }
    }

    private void expandMetricScene(LookUpSimilarImages db) {
        if (this.verbose != null) {
            this.verbose.println("ENTER expandMetricScene()");
        }
        this.workGraph.viewList.forEach(v -> this.exploredViews.add(v.pview.id));
        FastArray<PairwiseImageGraph.View> open = this.findAllOpenViews();
        while (open.size > 0) {
            PairwiseImageGraph.View selected = this.selectNextToProcess(open);
            if (selected == null) {
                if (this.verbose == null) break;
                this.verbose.println("  No valid views left. open.size=" + open.size);
                break;
            }
            if (!this.expandMetric.process(db, this.workGraph, selected)) {
                if (this.verbose == null) continue;
                this.verbose.println("  Failed to expand/add view='" + selected.id + "'. Discarding.");
                continue;
            }
            if (this.verbose != null) {
                this.verbose.println("    Expanded view='" + selected.id + "'  inliers=" + this.utils.inliersThreeView.size() + " / " + this.utils.matchesTriple.size);
            }
            SceneWorkingGraph.View wview = this.workGraph.lookupView(selected.id);
            this.utils.saveRansacInliers(wview);
            this.addOpenForView(wview.pview, open);
        }
        if (this.verbose != null) {
            this.verbose.println("EXIT expandMetricScene()");
        }
    }

    public ProjectiveInitializeAllCommon getInitProjective() {
        return this.initProjective;
    }

    public ProjectiveToMetricCameras getProjectiveToMetric() {
        return this.projectiveToMetric;
    }

    public void setProjectiveToMetric(ProjectiveToMetricCameras projectiveToMetric) {
        this.projectiveToMetric = projectiveToMetric;
    }

    public MetricExpandByOneView getExpandMetric() {
        return this.expandMetric;
    }

    public RefineMetricWorkingGraph getRefineWorking() {
        return this.refineWorking;
    }
}

