/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.RemoveBrownPtoN_F64;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.geo.selfcalib.TwoViewToCalibratingHomography;
import boofcv.alg.sfm.structure.ExpandByOneView;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;

public class MetricExpandByOneView
extends ExpandByOneView {
    protected TwoViewToCalibratingHomography projectiveHomography = new TwoViewToCalibratingHomography();
    public final MetricBundleAdjustmentUtils bundleAdjustment = new MetricBundleAdjustmentUtils();
    protected final List<Point2D_F64> pixelNorms = BoofMiscOps.createListFilled(3, Point2D_F64::new);
    protected final List<Se3_F64> listMotion = new ArrayList<Se3_F64>();
    protected final RemoveBrownPtoN_F64 normalize1 = new RemoveBrownPtoN_F64();
    protected final RemoveBrownPtoN_F64 normalize2 = new RemoveBrownPtoN_F64();
    protected final RemoveBrownPtoN_F64 normalize3 = new RemoveBrownPtoN_F64();
    List<PairwiseImageGraph.Motion> connections = new ArrayList<PairwiseImageGraph.Motion>();
    DMatrixRMaj F21 = new DMatrixRMaj(3, 3);
    DMatrixRMaj K1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj K2 = new DMatrixRMaj(3, 3);
    DogArray<AssociatedPair> pairs = new DogArray<AssociatedPair>(AssociatedPair::new);
    Se3_F64 view1_to_view1 = new Se3_F64();
    Se3_F64 view1_to_view2 = new Se3_F64();
    Se3_F64 view1_to_target = new Se3_F64();
    Se3_F64 view1_to_view2H = new Se3_F64();
    DMatrixRMaj K_target = new DMatrixRMaj(3, 3);

    public MetricExpandByOneView() {
        this.listMotion.add(this.view1_to_view1);
        this.listMotion.add(this.view1_to_view2);
        this.listMotion.add(this.view1_to_target);
    }

    public boolean process(LookUpSimilarImages db, SceneWorkingGraph workGraph, PairwiseImageGraph.View target) {
        BoofMiscOps.checkTrue(!workGraph.isKnown(target), "Target shouldn't already be in the workGraph");
        this.workGraph = workGraph;
        this.utils.db = db;
        if (!this.selectTwoConnections(target, this.connections)) {
            if (this.verbose != null) {
                this.verbose.println("Failed to expand because two connections couldn't be found. valid.size=" + this.validCandidates.size());
                for (int i = 0; i < this.validCandidates.size(); ++i) {
                    this.verbose.println("   valid view.id='" + ((PairwiseImageGraph.Motion)this.validCandidates.get((int)i)).other((PairwiseImageGraph.View)target).id + "'");
                }
            }
            return false;
        }
        this.utils.seed = this.connections.get(0).other(target);
        this.utils.viewB = this.connections.get(1).other(target);
        this.utils.viewC = target;
        this.utils.createThreeViewLookUpTables();
        this.utils.findCommonFeatures();
        if (this.verbose != null) {
            this.verbose.println("Expanding to view='" + target.id + "' using views ( '" + this.utils.seed.id + "' , '" + this.utils.viewB.id + "') common=" + this.utils.commonIdx.size + " valid.size=" + this.validCandidates.size());
        }
        this.utils.createTripleFromCommon();
        if (!this.utils.estimateProjectiveCamerasRobustly()) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Trifocal RANSAC inliers.size=" + this.utils.inliersThreeView.size());
        }
        if (!this.computeCalibratingHomography()) {
            return false;
        }
        SceneWorkingGraph.View wtarget = workGraph.addView(this.utils.viewC);
        db.lookupShape(wtarget.pview.id, wtarget.imageDimension);
        this.upgradeToMetric(wtarget, this.projectiveHomography.getCalibrationHomography());
        if (this.utils.configConvergeSBA.maxIterations > 0) {
            this.refineWithBundleAdjustment(workGraph);
        }
        int which = UtilPoint3D_F64.axisLargestAbs(this.view1_to_view2.T);
        double scale = this.view1_to_view2.T.getIdx(which) / this.view1_to_view2H.T.getIdx(which);
        this.view1_to_target.T.scale(scale);
        Se3_F64 world_to_view1 = workGraph.views.get((Object)this.utils.seed.id).world_to_view;
        world_to_view1.concat(this.view1_to_target, wtarget.world_to_view);
        if (this.verbose != null) {
            this.verbose.printf("Rescaled Local T={%.1f %.1f %.1f) scale=%f\n", this.view1_to_target.T.x, this.view1_to_target.T.y, this.view1_to_target.T.z, scale);
            this.verbose.printf("Final Global   T={%.1f %.1f %.1f)\n", wtarget.world_to_view.T.x, wtarget.world_to_view.T.y, wtarget.world_to_view.T.z);
        }
        return true;
    }

    private void upgradeToMetric(SceneWorkingGraph.View wview, DMatrixRMaj H_cal) {
        MultiViewOps.projectiveToMetric(this.utils.P2, H_cal, this.view1_to_view2H, this.K_target);
        MultiViewOps.projectiveToMetric(this.utils.P3, H_cal, this.view1_to_target, this.K_target);
        BundleAdjustmentOps.convert(this.K_target, wview.intrinsic);
        double normTarget = this.view1_to_target.T.norm();
        this.view1_to_target.T.divide(normTarget);
        this.view1_to_view2H.T.divide(normTarget);
        SceneWorkingGraph.View wview1 = this.workGraph.lookupView(this.utils.seed.id);
        SceneWorkingGraph.View wview2 = this.workGraph.lookupView(this.utils.viewB.id);
        wview1.world_to_view.invert((Se3_F64)null).concat(wview2.world_to_view, this.view1_to_view2);
        if (this.verbose != null) {
            this.verbose.printf("L View 1 to 2     T={%.1f %.1f %.1f)\n", this.view1_to_view2H.T.x, this.view1_to_view2H.T.y, this.view1_to_view2H.T.z);
        }
        double scale = MultiViewOps.findScale(this.view1_to_view2.T, this.view1_to_view2H.T);
        this.view1_to_view2H.setTo(this.view1_to_view2);
        this.view1_to_view2H.T.scale(scale);
        if (this.verbose != null) {
            this.verbose.printf("G View 1 to 2     T={%.1f %.1f %.1f)\n", this.view1_to_view2H.T.x, this.view1_to_view2H.T.y, this.view1_to_view2H.T.z);
            this.verbose.printf("Initial fx=%6.1f k1=%6.3f k2=%6.3f T={%.1f %.1f %.1f)\n", wview.intrinsic.f, wview.intrinsic.k1, wview.intrinsic.k2, this.view1_to_target.T.x, this.view1_to_target.T.y, this.view1_to_target.T.z);
        }
    }

    private void refineWithBundleAdjustment(SceneWorkingGraph workGraph) {
        SceneStructureMetric structure = this.bundleAdjustment.structure;
        SceneObservations observations = this.bundleAdjustment.observations;
        SceneWorkingGraph.View wview1 = workGraph.lookupView(this.utils.seed.id);
        SceneWorkingGraph.View wview2 = workGraph.lookupView(this.utils.viewB.id);
        SceneWorkingGraph.View wview3 = workGraph.lookupView(this.utils.viewC.id);
        List<AssociatedTriple> triples = this.utils.inliersThreeView;
        int numFeatures = triples.size();
        structure.initialize(3, 3, numFeatures);
        observations.initialize(3);
        observations.getView(0).resize(numFeatures);
        observations.getView(1).resize(numFeatures);
        observations.getView(2).resize(numFeatures);
        structure.setCamera(0, true, wview1.intrinsic);
        structure.setCamera(1, true, wview2.intrinsic);
        structure.setCamera(2, false, wview3.intrinsic);
        structure.setView(0, 0, true, this.view1_to_view1);
        structure.setView(1, 1, false, this.view1_to_view2H);
        structure.setView(2, 2, false, this.view1_to_target);
        this.normalize1.setK(wview1.intrinsic.f, wview1.intrinsic.f, 0.0, 0.0, 0.0).setDistortion(wview1.intrinsic.k1, wview1.intrinsic.k2);
        this.normalize2.setK(wview2.intrinsic.f, wview2.intrinsic.f, 0.0, 0.0, 0.0).setDistortion(wview2.intrinsic.k1, wview2.intrinsic.k2);
        this.normalize3.setK(wview3.intrinsic.f, wview3.intrinsic.f, 0.0, 0.0, 0.0).setDistortion(wview3.intrinsic.k1, wview3.intrinsic.k2);
        SceneObservations.View viewObs1 = observations.getView(0);
        SceneObservations.View viewObs2 = observations.getView(1);
        SceneObservations.View viewObs3 = observations.getView(2);
        TriangulateNViewsMetricH triangulator = this.bundleAdjustment.triangulator;
        Point4D_F64 foundX = new Point4D_F64();
        for (int featIdx = 0; featIdx < numFeatures; ++featIdx) {
            AssociatedTriple a = triples.get(featIdx);
            viewObs1.set(featIdx, featIdx, (float)a.p1.x, (float)a.p1.y);
            viewObs2.set(featIdx, featIdx, (float)a.p2.x, (float)a.p2.y);
            viewObs3.set(featIdx, featIdx, (float)a.p3.x, (float)a.p3.y);
            this.normalize1.compute(a.p1.x, a.p1.y, this.pixelNorms.get(0));
            this.normalize2.compute(a.p2.x, a.p2.y, this.pixelNorms.get(1));
            this.normalize3.compute(a.p3.x, a.p3.y, this.pixelNorms.get(2));
            if (!triangulator.triangulate(this.pixelNorms, this.listMotion, foundX)) {
                throw new RuntimeException("Triangulation failed. Possibly bad input. Handle this problem");
            }
            if (structure.isHomogenous()) {
                structure.setPoint(featIdx, foundX.x, foundX.y, foundX.z, foundX.w);
            } else {
                structure.setPoint(featIdx, foundX.x / foundX.w, foundX.y / foundX.w, foundX.z / foundX.w);
            }
            structure.connectPointToView(featIdx, 0);
            structure.connectPointToView(featIdx, 1);
            structure.connectPointToView(featIdx, 2);
        }
        if (!this.bundleAdjustment.process(null)) {
            throw new RuntimeException("Bundle adjustment failed. Handle this");
        }
        wview3.intrinsic.setTo((BundlePinholeSimplified)((SceneStructureCommon.Camera)structure.cameras.get((int)2)).model);
        this.view1_to_view2H.setTo(structure.getParentToView(1));
        this.view1_to_target.setTo(structure.getParentToView(2));
        if (this.verbose != null) {
            this.verbose.printf("G View 1 to 2     T={%.1f %.1f %.1f)\n", this.view1_to_view2H.T.x, this.view1_to_view2H.T.y, this.view1_to_view2H.T.z);
            this.verbose.printf("Refined fx=%6.1f k1=%6.3f k2=%6.3f T={%.1f %.1f %.1f)\n", wview3.intrinsic.f, wview3.intrinsic.k1, wview3.intrinsic.k2, this.view1_to_target.T.x, this.view1_to_target.T.y, this.view1_to_target.T.z);
        }
    }

    boolean computeCalibratingHomography() {
        MultiViewOps.projectiveToFundamental(this.utils.P2, this.F21);
        this.projectiveHomography.initialize(this.F21, this.utils.P2);
        BundleAdjustmentOps.convert(this.workGraph.lookupView((String)this.utils.seed.id).intrinsic, this.K1);
        BundleAdjustmentOps.convert(this.workGraph.lookupView((String)this.utils.viewB.id).intrinsic, this.K2);
        DogArray<AssociatedTriple> triples = this.utils.matchesTriple;
        this.pairs.resize(triples.size());
        for (int idx = 0; idx < triples.size(); ++idx) {
            AssociatedTriple a = (AssociatedTriple)triples.get(idx);
            ((AssociatedPair)this.pairs.get(idx)).setTo(a.p1, a.p2);
        }
        return this.projectiveHomography.process(this.K1, this.K2, this.pairs.toList());
    }
}

