/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I64;

public class LookUpSimilarGivenTracks<Track>
implements LookUpSimilarImages {
    TrackToID<Track> lookupID;
    TrackToPixel<Track> lookupPixel;
    DogArray<Frame> frames = new DogArray<Frame>(Frame::new, Frame::reset);
    List<String> frameIds = new ArrayList<String>();
    DogArray_I64 keys = new DogArray_I64();

    public LookUpSimilarGivenTracks(TrackToID<Track> lookupID, TrackToPixel<Track> lookupPixel) {
        this.lookupID = lookupID;
        this.lookupPixel = lookupPixel;
    }

    public void reset() {
        this.frames.reset();
        this.frameIds.clear();
    }

    public void addFrame(int width, int height, List<Track> tracks) {
        Frame f = this.frames.grow();
        f.shape.setTo(width, height);
        f.pixels.reserve(tracks.size());
        f.id = "" + (this.frames.size - 1);
        this.frameIds.add(f.id);
        for (int pixelIdx = 0; pixelIdx < tracks.size(); ++pixelIdx) {
            Track t = tracks.get(pixelIdx);
            long id = this.lookupID.getId(t);
            f.trackToIndex.put(id, pixelIdx);
            this.lookupPixel.getPixel(t, f.pixels.grow());
        }
    }

    public void computeSimilarRelationships(boolean sequence, int minFeatures, int maxSimilar) {
        Frame frameB;
        Frame frameA;
        int idxA;
        for (int idx = 0; idx < this.frames.size; ++idx) {
            ((Frame)this.frames.get((int)idx)).similar.reset();
        }
        block1: for (idxA = 0; idxA < this.frames.size; ++idxA) {
            frameA = (Frame)this.frames.get(idxA);
            for (int idxB = idxA + 1; idxB < this.frames.size; ++idxB) {
                frameB = (Frame)this.frames.get(idxB);
                int common = this.countCommon(frameA, frameB);
                if (common < minFeatures) {
                    if (!sequence) continue;
                    continue block1;
                }
                frameA.similar.grow().setTo(frameB, common);
                frameB.similar.grow().setTo(frameA, common);
            }
        }
        if (maxSimilar <= 0) {
            return;
        }
        for (idxA = 0; idxA < this.frames.size; ++idxA) {
            frameA = (Frame)this.frames.get(idxA);
            if (frameA.similar.size() <= maxSimilar) continue;
            Collections.sort(frameA.similar.toList(), (a, b) -> Integer.compare(b.common, a.common));
            while (frameA.similar.size > maxSimilar) {
                Connected a_to_b = frameA.similar.removeTail();
                frameB = a_to_b.dst;
                int indexOfAinB = frameB.similar.findIdx(a -> a.dst == frameA);
                BoofMiscOps.checkTrue(indexOfAinB >= 0, "BUG! connectivity isn't symmetric");
                frameB.similar.removeSwap(indexOfAinB);
            }
            BoofMiscOps.checkTrue(frameA.similar.size() <= maxSimilar);
        }
    }

    int countCommon(Frame frameA, Frame frameB) {
        this.keys.resize(frameA.trackToIndex.size());
        frameA.trackToIndex.keys(this.keys.data);
        int total = 0;
        for (int i = 0; i < this.keys.size; ++i) {
            long key = this.keys.get(i);
            if (!frameB.trackToIndex.containsKey(key)) continue;
            ++total;
        }
        return total;
    }

    Frame getFrame(String target) {
        int index = Integer.parseInt(target);
        if (index < 0 || index >= this.frames.size) {
            throw new IllegalArgumentException("Invalid or out of range target. " + target);
        }
        Frame f = (Frame)this.frames.get(index);
        return f;
    }

    @Override
    public List<String> getImageIDs() {
        return this.frameIds;
    }

    @Override
    public void findSimilar(String target, List<String> similar) {
        Frame f = this.getFrame(target);
        similar.clear();
        for (int i = 0; i < f.similar.size(); ++i) {
            similar.add(((Connected)f.similar.get((int)i)).dst.id);
        }
    }

    @Override
    public void lookupPixelFeats(String target, DogArray<Point2D_F64> features) {
        Frame f = this.getFrame(target);
        features.reset();
        features.resize(f.pixels.size);
        for (int i = 0; i < f.pixels.size; ++i) {
            ((Point2D_F64)features.get(i)).setTo((Point2D_F64)f.pixels.get(i));
        }
    }

    @Override
    public boolean lookupMatches(String viewA, String viewB, DogArray<AssociatedIndex> pairs) {
        pairs.reset();
        Frame frameA = this.getFrame(viewA);
        Frame frameB = this.getFrame(viewB);
        if (null == frameA.findConnected(frameB)) {
            return false;
        }
        this.keys.resize(frameA.trackToIndex.size());
        frameA.trackToIndex.keys(this.keys.data);
        for (int i = 0; i < this.keys.size; ++i) {
            long key = this.keys.get(i);
            int idxB = frameB.trackToIndex.get(key);
            if (idxB < 0) continue;
            int idxA = frameA.trackToIndex.get(key);
            pairs.grow().setTo(idxA, idxB);
        }
        return true;
    }

    @Override
    public void lookupShape(String target, ImageDimension shape) {
        shape.setTo(this.getFrame((String)target).shape);
    }

    public static interface TrackToID<Track> {
        public long getId(Track var1);
    }

    public static interface TrackToPixel<Track> {
        public void getPixel(Track var1, Point2D_F64 var2);
    }

    static class Frame {
        final ImageDimension shape = new ImageDimension();
        final DogArray<Point2D_F64> pixels = new DogArray<Point2D_F64>(Point2D_F64::new);
        final TLongIntMap trackToIndex = new TLongIntHashMap(10, 0.5f, -1L, -1);
        final DogArray<Connected> similar = new DogArray<Connected>(Connected::new, Connected::reset);
        String id = "";

        Frame() {
        }

        void reset() {
            this.shape.setTo(-1, -1);
            this.pixels.reset();
            this.trackToIndex.clear();
            this.similar.reset();
            this.id = "";
        }

        Connected findConnected(Frame dst) {
            for (int i = 0; i < this.similar.size; ++i) {
                if (((Connected)this.similar.get((int)i)).dst != dst) continue;
                return (Connected)this.similar.get(i);
            }
            return null;
        }
    }

    static class Connected {
        Frame dst;
        int common;

        Connected() {
        }

        void setTo(Frame dst, int common) {
            this.dst = dst;
            this.common = common;
        }

        void reset() {
            this.dst = null;
            this.common = -1;
        }
    }
}

