/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.factory.geo.ConfigFundamental;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.ejml.ops.DConvertMatrixStruct;
import org.jetbrains.annotations.Nullable;

public class GeneratePairwiseImageGraph
implements VerbosePrint {
    public final PairwiseImageGraph graph = new PairwiseImageGraph();
    private List<String> imageIds;
    ModelMatcher<DMatrixRMaj, AssociatedPair> ransac3D;
    ModelMatcher<Homography2D_F64, AssociatedPair> ransacH;
    public int minimumInliers = 30;
    public double ratio3D = 1.5;
    private PrintStream verbose;

    public GeneratePairwiseImageGraph() {
        ConfigRansac configRansacF = new ConfigRansac();
        configRansacF.iterations = 500;
        configRansacF.inlierThreshold = 1.0;
        ConfigRansac configRansacH = new ConfigRansac();
        configRansacH.iterations = 500;
        configRansacH.inlierThreshold = 2.0;
        ConfigFundamental configF = new ConfigFundamental();
        configF.errorModel = ConfigFundamental.ErrorModel.GEOMETRIC;
        configF.numResolve = 1;
        this.ransac3D = FactoryMultiViewRobust.fundamentalRansac(configF, configRansacF);
        this.ransacH = FactoryMultiViewRobust.homographyRansac(null, configRansacH);
    }

    public void process(LookUpSimilarImages db) {
        int idxTgt;
        this.imageIds = db.getImageIDs();
        this.graph.reset();
        ArrayList<String> similar = new ArrayList<String>();
        DogArray<Point2D_F64> srcFeats = new DogArray<Point2D_F64>(Point2D_F64::new);
        DogArray<Point2D_F64> dstFeats = new DogArray<Point2D_F64>(Point2D_F64::new);
        DogArray<AssociatedIndex> matches = new DogArray<AssociatedIndex>(AssociatedIndex::new);
        DogArray<AssociatedPair> pairs = new DogArray<AssociatedPair>(AssociatedPair::new);
        HashMap<String, Integer> imageToIndex = new HashMap<String, Integer>();
        for (idxTgt = 0; idxTgt < this.imageIds.size(); ++idxTgt) {
            imageToIndex.put(this.imageIds.get(idxTgt), idxTgt);
            this.graph.createNode(this.imageIds.get(idxTgt));
        }
        if (this.verbose != null) {
            this.verbose.println("total images = " + this.imageIds.size());
        }
        for (idxTgt = 0; idxTgt < this.imageIds.size(); ++idxTgt) {
            String src = this.imageIds.get(idxTgt);
            db.findSimilar(src, similar);
            db.lookupPixelFeats(src, srcFeats);
            if (this.verbose != null) {
                this.verbose.println("ID=" + src + " similar=" + similar.size() + "  obs=" + srcFeats.size);
            }
            ((PairwiseImageGraph.View)this.graph.nodes.get((int)idxTgt)).totalObservations = srcFeats.size;
            for (int idxSimilar = 0; idxSimilar < similar.size(); ++idxSimilar) {
                String dst = (String)similar.get(idxSimilar);
                int dstIdx = (Integer)imageToIndex.get(dst);
                if (dstIdx <= idxTgt) continue;
                db.lookupPixelFeats(dst, dstFeats);
                db.lookupMatches(src, dst, matches);
                pairs.reset();
                for (int i = 0; i < matches.size; ++i) {
                    AssociatedIndex m = (AssociatedIndex)matches.get(i);
                    pairs.grow().setTo((Point2D_F64)srcFeats.get(m.src), (Point2D_F64)dstFeats.get(m.dst));
                }
                this.createEdge(src, dst, pairs, matches);
            }
        }
    }

    protected void createEdge(String src, String dst, DogArray<AssociatedPair> pairs, DogArray<AssociatedIndex> matches) {
        int countF = 0;
        if (this.ransac3D.process(pairs.toList())) {
            countF = this.ransac3D.getMatchSet().size();
        }
        int countH = 0;
        if (this.ransacH.process(pairs.toList())) {
            countH = this.ransacH.getMatchSet().size();
        }
        if (this.verbose != null) {
            this.verbose.println("   dst='" + dst + "' ransac F=" + countF + " H=" + countH + " pairs.size=" + pairs.size());
        }
        if (Math.max(countF, countH) < this.minimumInliers) {
            return;
        }
        boolean is3D = (double)countF > (double)countH * this.ratio3D;
        PairwiseImageGraph.Motion edge = this.graph.edges.grow();
        edge.is3D = is3D;
        edge.countF = countF;
        edge.countH = countH;
        edge.index = this.graph.edges.size - 1;
        edge.src = this.graph.lookupNode(src);
        edge.dst = this.graph.lookupNode(dst);
        edge.src.connections.add(edge);
        edge.dst.connections.add(edge);
        if (is3D) {
            this.saveInlierMatches(this.ransac3D, matches, edge);
            edge.F.set(this.ransac3D.getModelParameters());
        } else {
            this.saveInlierMatches(this.ransacH, matches, edge);
            Homography2D_F64 H = this.ransacH.getModelParameters();
            DConvertMatrixStruct.convert(H, edge.F);
        }
    }

    private void saveInlierMatches(ModelMatcher<?, ?> ransac, DogArray<AssociatedIndex> matches, PairwiseImageGraph.Motion edge) {
        int N = ransac.getMatchSet().size();
        edge.inliers.reset();
        edge.inliers.resize(N);
        for (int i = 0; i < N; ++i) {
            int idx = ransac.getInputIndex(i);
            ((AssociatedIndex)edge.inliers.get(i)).setTo((AssociatedIndex)matches.get(idx));
        }
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public PairwiseImageGraph getGraph() {
        return this.graph;
    }

    public int getMinimumInliers() {
        return this.minimumInliers;
    }

    public void setMinimumInliers(int minimumInliers) {
        this.minimumInliers = minimumInliers;
    }

    public double getRatio3D() {
        return this.ratio3D;
    }

    public void setRatio3D(double ratio3D) {
        this.ratio3D = ratio3D;
    }
}

