/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.alg.sfm.structure.ConfigProjectiveReconstruction;
import boofcv.alg.sfm.structure.PairwiseGraphUtils;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public abstract class ExpandByOneView
implements VerbosePrint {
    protected PrintStream verbose;
    protected SceneWorkingGraph workGraph;
    protected PairwiseGraphUtils utils = new PairwiseGraphUtils(new ConfigProjectiveReconstruction());
    protected List<PairwiseImageGraph.Motion> validCandidates = new ArrayList<PairwiseImageGraph.Motion>();

    public boolean selectTwoConnections(PairwiseImageGraph.View target, List<PairwiseImageGraph.Motion> connections) {
        connections.clear();
        this.createListOfValid(target, this.validCandidates);
        double bestScore = 0.0;
        for (int connectionCnt = 0; connectionCnt < this.validCandidates.size(); ++connectionCnt) {
            PairwiseImageGraph.View viewC;
            PairwiseImageGraph.Motion connectB = this.validCandidates.get(connectionCnt);
            PairwiseImageGraph.Motion connectC = this.findBestCommon(target, connectB, this.validCandidates);
            if (connectC == null) continue;
            PairwiseImageGraph.View viewB = connectB.other(target);
            PairwiseImageGraph.Motion connectBtoC = viewB.findMotion(viewC = connectC.other(target));
            BoofMiscOps.checkTrue(connectBtoC != null, "BUG");
            double score = Math.min(this.utils.scoreMotion.score(connectB), this.utils.scoreMotion.score(connectC));
            score = Math.min(score, this.utils.scoreMotion.score(connectBtoC));
            if (!(score > bestScore)) continue;
            bestScore = score;
            connections.clear();
            connections.add(connectB);
            connections.add(connectC);
        }
        if (this.verbose != null) {
            this.verbose.printf("best selected pair score=%f\n", bestScore);
        }
        return !connections.isEmpty();
    }

    void createListOfValid(PairwiseImageGraph.View target, List<PairwiseImageGraph.Motion> validConnections) {
        validConnections.clear();
        for (int connectionIdx = 0; connectionIdx < target.connections.size; ++connectionIdx) {
            PairwiseImageGraph.Motion connectB = (PairwiseImageGraph.Motion)target.connections.get(connectionIdx);
            if (!connectB.is3D || !this.workGraph.isKnown(connectB.other(target))) continue;
            validConnections.add(connectB);
        }
    }

    public PairwiseImageGraph.Motion findBestCommon(PairwiseImageGraph.View viewA, PairwiseImageGraph.Motion connAB, List<PairwiseImageGraph.Motion> validConnections) {
        double bestScore = 0.0;
        PairwiseImageGraph.Motion bestConnection = null;
        PairwiseImageGraph.View viewB = connAB.other(viewA);
        for (int connIdx = 0; connIdx < validConnections.size(); ++connIdx) {
            double score;
            PairwiseImageGraph.View viewC;
            PairwiseImageGraph.Motion connBC;
            PairwiseImageGraph.Motion connAC = validConnections.get(connIdx);
            if (connAC == connAB || null == (connBC = viewB.findMotion(viewC = connAC.other(viewA))) || !connBC.is3D || !((score = Math.min(this.utils.scoreMotion.score(connAC), this.utils.scoreMotion.score(connBC))) > bestScore)) continue;
            bestScore = score;
            bestConnection = connAC;
        }
        return bestConnection;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public PairwiseGraphUtils getUtils() {
        return this.utils;
    }

    public void setUtils(PairwiseGraphUtils utils) {
        this.utils = utils;
    }
}

