/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.alg.sfm.overhead.CameraPlaneProjection;
import boofcv.struct.sfm.PlanePtPixel;
import georegression.fitting.MotionTransformPoint;
import georegression.fitting.se.MotionSe2PointSVD_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.struct.DogArray;

public class GenerateSe2_PlanePtPixel
implements ModelGenerator<Se2_F64, PlanePtPixel> {
    MotionTransformPoint<Se2_F64, Point2D_F64> estimator;
    private final CameraPlaneProjection planeProjection = new CameraPlaneProjection();
    List<Point2D_F64> from = new ArrayList<Point2D_F64>();
    DogArray<Point2D_F64> to = new DogArray<Point2D_F64>(Point2D_F64::new);

    public GenerateSe2_PlanePtPixel(MotionTransformPoint<Se2_F64, Point2D_F64> estimator) {
        this.estimator = estimator;
    }

    public GenerateSe2_PlanePtPixel() {
        this.estimator = new MotionSe2PointSVD_F64();
    }

    public void setExtrinsic(Se3_F64 planeToCamera) {
        this.planeProjection.setPlaneToCamera(planeToCamera, true);
    }

    @Override
    public boolean generate(List<PlanePtPixel> dataSet, Se2_F64 keyToCurr) {
        this.from.clear();
        this.to.reset();
        for (int i = 0; i < dataSet.size(); ++i) {
            PlanePtPixel p = dataSet.get(i);
            Point2D_F64 planeCurr = this.to.grow();
            if (this.planeProjection.normalToPlane(p.normalizedCurr.x, p.normalizedCurr.y, planeCurr)) {
                this.from.add(p.getPlaneKey());
                continue;
            }
            this.to.removeTail();
        }
        if (!this.estimator.process(this.from, this.to.toList())) {
            return false;
        }
        keyToCurr.setTo(this.estimator.getTransformSrcToDst());
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return this.estimator.getMinimumPoints();
    }
}

