/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d2;

import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.sfm.d2.StitchingTransform;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.ImageBase;
import georegression.metric.Area2D_F64;
import georegression.struct.InvertibleTransform;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.RectangleLength2D_I32;

public class StitchingFromMotion2D<I extends ImageBase<I>, IT extends InvertibleTransform> {
    private final ImageMotion2D<I, IT> motion;
    private final ImageDistort<I, I> distorter;
    private final StitchingTransform<IT> converter;
    private IT worldToInit;
    private int widthStitch;
    private int heightStitch;
    private final double maxJumpFraction;
    private final Corners corners = new Corners();
    private double previousArea;
    private final IT worldToCurr;
    private PixelTransform<Point2D_F32> tranWorldToCurr;
    private PixelTransform<Point2D_F32> tranCurrToWorld;
    private final Point2D_F32 work = new Point2D_F32();
    private I stitchedImage;
    private I workImage;
    private boolean first = true;

    public StitchingFromMotion2D(ImageMotion2D<I, IT> motion, ImageDistort<I, I> distorter, StitchingTransform<IT> converter, double maxJumpFraction) {
        this.motion = motion;
        this.distorter = distorter;
        this.converter = converter;
        this.maxJumpFraction = maxJumpFraction;
        this.worldToCurr = motion.getFirstToCurrent().createInstance();
    }

    public void configure(int widthStitch, int heightStitch, IT worldToInit) {
        this.worldToInit = this.worldToCurr.createInstance();
        if (worldToInit != null) {
            this.worldToInit.setTo(worldToInit);
        }
        this.widthStitch = widthStitch;
        this.heightStitch = heightStitch;
    }

    public boolean process(I image) {
        if (this.stitchedImage == null) {
            this.stitchedImage = ((ImageBase)image).createNew(this.widthStitch, this.heightStitch);
            this.workImage = ((ImageBase)image).createNew(this.widthStitch, this.heightStitch);
        }
        if (this.motion.process(image)) {
            this.update(image);
            return !this.checkLargeMotion(((ImageBase)image).width, ((ImageBase)image).height);
        }
        return false;
    }

    public void reset() {
        if (this.stitchedImage != null) {
            GImageMiscOps.fill(this.stitchedImage, 0.0);
        }
        this.motion.reset();
        this.worldToCurr.reset();
        this.first = true;
    }

    private boolean checkLargeMotion(int width, int height) {
        if (this.first) {
            this.getImageCorners(width, height, this.corners);
            this.previousArea = this.computeArea(this.corners);
            this.first = false;
        } else {
            this.getImageCorners(width, height, this.corners);
            double area = this.computeArea(this.corners);
            double change = Math.max(area / this.previousArea, this.previousArea / area) - 1.0;
            if (change > this.maxJumpFraction) {
                return true;
            }
            this.previousArea = area;
        }
        return false;
    }

    private double computeArea(Corners c) {
        return Area2D_F64.triangle(c.p0, c.p1, c.p2) + Area2D_F64.triangle(c.p0, c.p2, c.p3);
    }

    private void update(I image) {
        this.computeCurrToInit_PixelTran();
        RectangleLength2D_I32 box = DistortImageOps.boundBox(((ImageBase)image).width, ((ImageBase)image).height, ((ImageBase)this.stitchedImage).width, ((ImageBase)this.stitchedImage).height, this.work, this.tranCurrToWorld);
        int x0 = box.x0;
        int y0 = box.y0;
        int x1 = box.x0 + box.width;
        int y1 = box.y0 + box.height;
        this.distorter.setModel(this.tranWorldToCurr);
        this.distorter.apply(image, this.stitchedImage, x0, y0, x1, y1);
    }

    private void computeCurrToInit_PixelTran() {
        IT initToCurr = this.motion.getFirstToCurrent();
        this.worldToInit.concat(initToCurr, this.worldToCurr);
        this.tranWorldToCurr = this.converter.convertPixel(this.worldToCurr, this.tranWorldToCurr);
        Object currToWorld = this.worldToCurr.invert(null);
        this.tranCurrToWorld = this.converter.convertPixel(currToWorld, this.tranCurrToWorld);
    }

    public void setOriginToCurrent() {
        Object currToWorld = this.worldToCurr.invert(null);
        Object oldWorldToNewWorld = this.worldToInit.concat(currToWorld, null);
        PixelTransform<Point2D_F32> newToOld = this.converter.convertPixel(oldWorldToNewWorld, null);
        GImageMiscOps.fill(this.workImage, 0.0);
        this.distorter.setModel(newToOld);
        this.distorter.apply(this.stitchedImage, this.workImage);
        I s = this.workImage;
        this.workImage = this.stitchedImage;
        this.stitchedImage = s;
        this.motion.setToFirst();
        this.first = true;
        this.computeCurrToInit_PixelTran();
    }

    public void resizeStitchImage(int widthStitch, int heightStitch, IT newToOldStitch) {
        ((ImageBase)this.workImage).reshape(widthStitch, heightStitch);
        GImageMiscOps.fill(this.workImage, 0.0);
        if (newToOldStitch != null) {
            PixelTransform<Point2D_F32> newToOld = this.converter.convertPixel(newToOldStitch, null);
            this.distorter.setModel(newToOld);
            this.distorter.apply(this.stitchedImage, this.workImage);
            Object tmp = this.worldToCurr.createInstance();
            newToOldStitch.concat(this.worldToInit, tmp);
            this.worldToInit.setTo(tmp);
            this.computeCurrToInit_PixelTran();
        } else {
            int overlapWidth = Math.min(widthStitch, ((ImageBase)this.stitchedImage).width);
            int overlapHeight = Math.min(heightStitch, ((ImageBase)this.stitchedImage).height);
            GImageMiscOps.copy(0, 0, 0, 0, overlapWidth, overlapHeight, this.stitchedImage, this.workImage);
        }
        ((ImageBase)this.stitchedImage).reshape(widthStitch, heightStitch);
        I tmp = this.stitchedImage;
        this.stitchedImage = this.workImage;
        this.workImage = tmp;
        this.widthStitch = widthStitch;
        this.heightStitch = heightStitch;
    }

    public Corners getImageCorners(int width, int height, Corners corners) {
        if (corners == null) {
            corners = new Corners();
        }
        int w = width;
        int h = height;
        this.tranCurrToWorld.compute(0, 0, this.work);
        corners.p0.setTo(this.work.x, this.work.y);
        this.tranCurrToWorld.compute(w, 0, this.work);
        corners.p1.setTo(this.work.x, this.work.y);
        this.tranCurrToWorld.compute(w, h, this.work);
        corners.p2.setTo(this.work.x, this.work.y);
        this.tranCurrToWorld.compute(0, h, this.work);
        corners.p3.setTo(this.work.x, this.work.y);
        return corners;
    }

    public Homography2D_F64 getWorldToCurr(Homography2D_F64 storage) {
        return this.converter.convertH(this.worldToCurr, storage);
    }

    public IT getWorldToCurr() {
        return this.worldToCurr;
    }

    public I getStitchedImage() {
        return this.stitchedImage;
    }

    public ImageMotion2D<I, IT> getMotion() {
        return this.motion;
    }

    public static class Corners {
        public Point2D_F64 p0 = new Point2D_F64();
        public Point2D_F64 p1 = new Point2D_F64();
        public Point2D_F64 p2 = new Point2D_F64();
        public Point2D_F64 p3 = new Point2D_F64();
    }
}

