/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.watershed;

import boofcv.struct.image.GrayS32;
import org.ddogleg.struct.DogArray_I32;

public class RemoveWatersheds {
    private int[] connect = new int[4];
    private DogArray_I32 open = new DogArray_I32();
    private DogArray_I32 open2 = new DogArray_I32();

    public void remove(GrayS32 segmented) {
        int x;
        int index;
        int y;
        if (segmented.get(0, 0) >= 0) {
            throw new IllegalArgumentException("The segmented image must contain a border of -1 valued pixels.  See JavaDoc for important details you didn't bother to read about.");
        }
        this.open.reset();
        this.connect[0] = -1;
        this.connect[1] = 1;
        this.connect[2] = segmented.stride;
        this.connect[3] = -segmented.stride;
        for (y = 1; y < segmented.height - 1; ++y) {
            index = y * segmented.stride + 1;
            x = 1;
            while (x < segmented.width - 1) {
                if (segmented.data[index] == 0) {
                    this.open.add(index);
                }
                ++x;
                ++index;
            }
        }
        while (this.open.size != 0) {
            this.open2.reset();
            for (int i = 0; i < this.open.size; ++i) {
                index = this.open.get(i);
                for (int j = 0; j < 4; ++j) {
                    int r = segmented.data[index + this.connect[j]];
                    if (r <= 0) continue;
                    segmented.data[index] = r;
                    break;
                }
                if (segmented.data[index] != 0) continue;
                this.open2.add(index);
            }
            DogArray_I32 tmp = this.open;
            this.open = this.open2;
            this.open2 = tmp;
        }
        for (y = 1; y < segmented.height - 1; ++y) {
            index = y * segmented.stride + 1;
            for (x = 1; x < segmented.width - 1; ++x) {
                int n = index++;
                segmented.data[n] = segmented.data[n] - 1;
            }
        }
    }
}

