/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.cc;

import boofcv.alg.segmentation.cc.ConnectedTwoRowSpeckleFiller;
import boofcv.errors.BoofCheckFailure;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray;

public class ConnectedTwoRowSpeckleFiller_U8
extends ConnectedTwoRowSpeckleFiller<GrayU8> {
    final DogArray<OpenPixel> open = new DogArray<OpenPixel>(() -> new OpenPixel());
    int fillValue;
    int similarTol;

    @Override
    protected void initTypeSpecific(double similarTol, double fillValue) {
        this.similarTol = (int)similarTol;
        this.fillValue = (int)fillValue;
    }

    @Override
    protected int labelRow(int idx0, int[] labels, int[] labelCount, int[] locationX) {
        return ConnectedTwoRowSpeckleFiller_U8.labelRow(((GrayU8)this.image).data, idx0, ((GrayU8)this.image).width, labels, labelCount, locationX, this.fillValue, this.similarTol);
    }

    static int labelRow(byte[] pixels, int idx0, int width, int[] labels, int[] labelCount, int[] locationX, int fillValue, int tol) {
        int currentLabel;
        int idx1 = idx0 + width;
        if (pixels[idx0] == fillValue) {
            currentLabel = -1;
        } else {
            currentLabel = 0;
            labelCount[currentLabel] = 1;
            locationX[currentLabel] = 0;
        }
        labels[0] = currentLabel;
        int i = idx0;
        int j = idx0 + 1;
        while (j < idx1) {
            int col = j - idx0;
            int pixel_i = pixels[i] & 0xFF;
            int pixel_j = pixels[j] & 0xFF;
            if (pixel_i != fillValue && pixel_j != fillValue && Math.abs(pixel_i - pixel_j) <= tol) {
                int n = currentLabel;
                labelCount[n] = labelCount[n] + 1;
                labels[col] = currentLabel;
            } else if (pixel_j == fillValue) {
                labels[col] = -1;
            } else {
                labelCount[++currentLabel] = 1;
                locationX[currentLabel] = col;
                labels[col] = currentLabel;
            }
            i = j++;
        }
        return currentLabel + 1;
    }

    @Override
    protected void findConnectionsBetweenRows(int startRowA, int startRowB) {
        byte[] pixels = ((GrayU8)this.image).data;
        int width = ((GrayU8)this.image).width;
        int idxRowA = startRowA;
        int idxRowB = startRowB;
        this.merge.resize(this.countsB.size, -1);
        this.connectAtoB.resize(this.countsA.size, -1);
        int col = 0;
        while (col < width) {
            int valueA = pixels[idxRowA] & 0xFF;
            int valueB = pixels[idxRowB] & 0xFF;
            if (valueA != this.fillValue && valueB != this.fillValue && Math.abs(valueA - valueB) <= this.similarTol) {
                int target2;
                int target1;
                int labelA = this.labelsA.get(col);
                int labelB = this.labelsB.get(col);
                int whatAinB = this.connectAtoB.data[labelA];
                if (whatAinB == -1) {
                    this.connectAtoB.data[labelA] = this.traverseToEnd(labelB);
                } else if (whatAinB != labelB && (target1 = this.traverseToEnd(labelB)) != (target2 = this.traverseToEnd(whatAinB))) {
                    this.merge.data[target1] = target2;
                }
            }
            ++col;
            ++idxRowA;
            ++idxRowB;
        }
    }

    @Override
    protected void fillCluster(int seedX, int seedY, int clusterSize) {
        int seedValue = ((GrayU8)this.image).unsafe_get(seedX, seedY);
        BoofMiscOps.checkTrue(seedValue != this.fillValue, "BUG! Shouldn't have gotten this far");
        ++this.totalFilled;
        ((GrayU8)this.image).unsafe_set(seedX, seedY, this.fillValue);
        this.open.reset();
        this.open.grow().setTo(seedX, seedY, seedValue);
        int foundSize = 0;
        while (!this.open.isEmpty()) {
            ++foundSize;
            OpenPixel c = this.open.removeSwap(0);
            int x = c.x;
            int y = c.y;
            int value = c.value;
            this.checkAndConnect(x + 1, y, value, this.similarTol);
            this.checkAndConnect(x, y + 1, value, this.similarTol);
            this.checkAndConnect(x - 1, y, value, this.similarTol);
            this.checkAndConnect(x, y - 1, value, this.similarTol);
        }
        if (clusterSize != foundSize) {
            throw new BoofCheckFailure("BUG! Fill does not match cluster size. Expected=" + clusterSize + " Found=" + foundSize);
        }
    }

    void checkAndConnect(int x, int y, int targetValue, int tol) {
        if (!((GrayU8)this.image).isInBounds(x, y)) {
            return;
        }
        int value = ((GrayU8)this.image).unsafe_get(x, y);
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new RuntimeException("BAd value");
        }
        if (value == this.fillValue || Math.abs(value - targetValue) > tol) {
            return;
        }
        this.open.grow().setTo(x, y, value);
        ((GrayU8)this.image).unsafe_set(x, y, this.fillValue);
    }

    @Override
    public ImageType<GrayU8> getImageType() {
        return ImageType.SB_U8;
    }

    private static class OpenPixel {
        int x;
        int y;
        int value;

        private OpenPixel() {
        }

        public void setTo(int x, int y, int value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }
    }
}

