/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.cc;

import boofcv.alg.segmentation.cc.ConnectedTwoRowSpeckleFiller;
import boofcv.errors.BoofCheckFailure;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray;

public class ConnectedTwoRowSpeckleFiller_F32
extends ConnectedTwoRowSpeckleFiller<GrayF32> {
    final DogArray<OpenPixel> open = new DogArray<OpenPixel>(() -> new OpenPixel());
    float fillValue;
    float similarTol;

    @Override
    protected void initTypeSpecific(double similarTol, double fillValue) {
        this.similarTol = (float)similarTol;
        this.fillValue = (float)fillValue;
    }

    @Override
    protected int labelRow(int idx0, int[] labels, int[] labelCount, int[] locationX) {
        return ConnectedTwoRowSpeckleFiller_F32.labelRow(((GrayF32)this.image).data, idx0, ((GrayF32)this.image).width, labels, labelCount, locationX, this.fillValue, this.similarTol);
    }

    static int labelRow(float[] pixels, int idx0, int width, int[] labels, int[] labelCount, int[] locationX, float fillValue, float tol) {
        int currentLabel;
        int idx1 = idx0 + width;
        if (pixels[idx0] == fillValue) {
            currentLabel = -1;
        } else {
            currentLabel = 0;
            labelCount[currentLabel] = 1;
            locationX[currentLabel] = 0;
        }
        labels[0] = currentLabel;
        int i = idx0;
        int j = idx0 + 1;
        while (j < idx1) {
            int col = j - idx0;
            float pixel_i = pixels[i];
            float pixel_j = pixels[j];
            if (pixel_i != fillValue && pixel_j != fillValue && Math.abs(pixel_i - pixel_j) <= tol) {
                int n = currentLabel;
                labelCount[n] = labelCount[n] + 1;
                labels[col] = currentLabel;
            } else if (pixel_j == fillValue) {
                labels[col] = -1;
            } else {
                labelCount[++currentLabel] = 1;
                locationX[currentLabel] = col;
                labels[col] = currentLabel;
            }
            i = j++;
        }
        return currentLabel + 1;
    }

    @Override
    protected void findConnectionsBetweenRows(int startRowA, int startRowB) {
        float[] pixels = ((GrayF32)this.image).data;
        int width = ((GrayF32)this.image).width;
        int idxRowA = startRowA;
        int idxRowB = startRowB;
        this.merge.resize(this.countsB.size, -1);
        this.connectAtoB.resize(this.countsA.size, -1);
        int col = 0;
        while (col < width) {
            float valueA = pixels[idxRowA];
            float valueB = pixels[idxRowB];
            if (valueA != this.fillValue && valueB != this.fillValue && !(Math.abs(valueA - valueB) > this.similarTol)) {
                int target2;
                int target1;
                int labelA = this.labelsA.get(col);
                int labelB = this.labelsB.get(col);
                int whatAinB = this.connectAtoB.data[labelA];
                if (whatAinB == -1) {
                    this.connectAtoB.data[labelA] = this.traverseToEnd(labelB);
                } else if (whatAinB != labelB && (target1 = this.traverseToEnd(labelB)) != (target2 = this.traverseToEnd(whatAinB))) {
                    this.merge.data[target1] = target2;
                }
            }
            ++col;
            ++idxRowA;
            ++idxRowB;
        }
    }

    @Override
    protected void fillCluster(int seedX, int seedY, int clusterSize) {
        float seedValue = ((GrayF32)this.image).unsafe_get(seedX, seedY);
        BoofMiscOps.checkTrue(seedValue != this.fillValue, "BUG! Shouldn't have gotten this far");
        ++this.totalFilled;
        ((GrayF32)this.image).unsafe_set(seedX, seedY, this.fillValue);
        this.open.reset();
        this.open.grow().setTo(seedX, seedY, seedValue);
        int foundSize = 0;
        while (!this.open.isEmpty()) {
            ++foundSize;
            OpenPixel c = this.open.removeSwap(0);
            int x = c.x;
            int y = c.y;
            float value = c.value;
            this.checkAndConnect(x + 1, y, value, this.similarTol);
            this.checkAndConnect(x, y + 1, value, this.similarTol);
            this.checkAndConnect(x - 1, y, value, this.similarTol);
            this.checkAndConnect(x, y - 1, value, this.similarTol);
        }
        if (clusterSize != foundSize) {
            throw new BoofCheckFailure("BUG! Fill does not match cluster size. Expected=" + clusterSize + " Found=" + foundSize);
        }
    }

    void checkAndConnect(int x, int y, float targetValue, float tol) {
        if (!((GrayF32)this.image).isInBounds(x, y)) {
            return;
        }
        float value = ((GrayF32)this.image).unsafe_get(x, y);
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new RuntimeException("BAd value");
        }
        if (value == this.fillValue || Math.abs(value - targetValue) > tol) {
            return;
        }
        this.open.grow().setTo(x, y, value);
        ((GrayF32)this.image).unsafe_set(x, y, this.fillValue);
    }

    @Override
    public ImageType<GrayF32> getImageType() {
        return ImageType.SB_F32;
    }

    private static class OpenPixel {
        int x;
        int y;
        float value;

        private OpenPixel() {
        }

        public void setTo(int x, int y, float value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }
    }
}

