/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;

public class PointTrackerToSimilarImages
implements LookUpSimilarImages {
    public int searchRadius = 5;
    public final DogArray<Frame> frames = new DogArray<Frame>(Frame::new, Frame::reset);
    public final Map<String, Frame> frameMap = new HashMap<String, Frame>();
    public final DogArray<Matches> matches = new DogArray<Matches>(Matches::new, Matches::reset);
    public int imageWidth;
    public int imageHeight;
    List<PointTrack> tracks = new ArrayList<PointTrack>();
    DogArray<AssociatedIndex> pairs = new DogArray<AssociatedIndex>(AssociatedIndex::new);

    public void initialize(int width, int height) {
        this.imageWidth = width;
        this.imageHeight = height;
        this.frames.reset();
        this.frameMap.clear();
        this.matches.reset();
    }

    public void processFrame(PointTracker<?> tracker) {
        BoofMiscOps.checkTrue(this.imageWidth != 0, "Must call initialize first and specify the image size");
        Frame current = this.createFrameSaveObservations(tracker);
        this.findRelatedPastFrames(current);
    }

    Frame createFrameSaveObservations(PointTracker<?> tracker) {
        this.tracks.clear();
        tracker.getActiveTracks(this.tracks);
        Frame current = this.frames.grow();
        current.frameID = tracker.getFrameID() + "";
        current.initActive(this.tracks.size());
        int index = 0;
        for (int trackCnt = 0; trackCnt < this.tracks.size(); ++trackCnt) {
            PointTrack t = this.tracks.get(trackCnt);
            current.observations[index++] = (float)t.pixel.x;
            current.observations[index++] = (float)t.pixel.y;
            current.ids[trackCnt] = t.featureId;
            current.id_to_index.put(t.featureId, trackCnt);
        }
        this.frameMap.put(current.frameID, current);
        return current;
    }

    void findRelatedPastFrames(Frame current) {
        for (int frameCnt = Math.max(0, this.frames.size - this.searchRadius - 1); frameCnt < this.frames.size - 1; ++frameCnt) {
            Frame previous = (Frame)this.frames.get(frameCnt);
            this.pairs.reset();
            int prevNumObs = previous.size();
            for (int previousIdx = 0; previousIdx < prevNumObs; ++previousIdx) {
                int currentIdx = current.id_to_index.get(previous.getID(previousIdx));
                if (currentIdx < 0) continue;
                this.pairs.grow().setTo(currentIdx, previousIdx);
            }
            if (this.pairs.size == 0) continue;
            Matches m = this.matches.grow();
            m.init(this.pairs.size);
            m.frameSrc = current;
            m.frameDst = previous;
            for (int pairCnt = 0; pairCnt < this.pairs.size; ++pairCnt) {
                AssociatedIndex a = (AssociatedIndex)this.pairs.get(pairCnt);
                m.src[pairCnt] = a.src;
                m.dst[pairCnt] = a.dst;
            }
            m.frameSrc.matches.add(m);
            m.frameDst.matches.add(m);
            previous.related.add(current);
            current.related.add(previous);
        }
    }

    @Override
    public List<String> getImageIDs() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.frames.size; ++i) {
            list.add(((Frame)this.frames.get((int)i)).frameID);
        }
        return list;
    }

    @Override
    public void findSimilar(String target, List<String> similar) {
        similar.clear();
        Frame f = this.frameMap.get(target);
        BoofMiscOps.checkTrue(f != null, "Unknown image");
        for (int i = 0; i < f.related.size(); ++i) {
            similar.add(f.related.get((int)i).frameID);
        }
    }

    @Override
    public void lookupPixelFeats(String target, DogArray<Point2D_F64> features) {
        features.reset();
        Frame f = this.frameMap.get(target);
        BoofMiscOps.checkTrue(f != null, "Unknown image");
        int N = f.size();
        for (int i = 0; i < N; ++i) {
            f.getPixel(i, features.grow());
        }
    }

    @Override
    public boolean lookupMatches(String viewA, String viewB, DogArray<AssociatedIndex> pairs) {
        pairs.reset();
        Frame src = this.frameMap.get(viewA);
        if (src == null) {
            return false;
        }
        Frame dst = null;
        for (int i = 0; i < src.related.size(); ++i) {
            if (!src.related.get((int)i).frameID.equals(viewB)) continue;
            dst = src.related.get(i);
            break;
        }
        if (dst == null) {
            return false;
        }
        Matches m = null;
        for (int i = 0; i < src.matches.size(); ++i) {
            Matches a = src.matches.get(i);
            if (a.frameSrc != dst && a.frameDst != dst) continue;
            m = a;
            break;
        }
        if (m == null) {
            return false;
        }
        boolean swapped = m.frameSrc != src;
        int size = m.size();
        for (int i = 0; i < size; ++i) {
            if (swapped) {
                pairs.grow().setTo(m.dst[i], m.src[i]);
                continue;
            }
            pairs.grow().setTo(m.src[i], m.dst[i]);
        }
        return true;
    }

    @Override
    public void lookupShape(String target, ImageDimension shape) {
        shape.setTo(this.imageWidth, this.imageHeight);
    }

    public static class Frame {
        public String frameID;
        public float[] observations;
        public long[] ids;
        TLongIntHashMap id_to_index = new TLongIntHashMap(){
            {
                this.no_entry_value = -1;
            }
        };
        public final List<Frame> related = new ArrayList<Frame>();
        public final List<Matches> matches = new ArrayList<Matches>();

        public void initActive(int totalFeatures) {
            this.observations = new float[totalFeatures * 2];
            this.ids = new long[totalFeatures];
        }

        public int size() {
            return this.ids.length;
        }

        public void getPixel(int index, Point2D_F64 out) {
            out.x = this.observations[index *= 2];
            out.y = this.observations[index + 1];
        }

        public long getID(int index) {
            return this.ids[index];
        }

        public void reset() {
            this.observations = null;
            this.ids = null;
            this.frameID = null;
            this.id_to_index.clear();
            this.related.clear();
            this.matches.clear();
        }
    }

    public static class Matches {
        public int[] src;
        public int[] dst;
        public Frame frameSrc;
        public Frame frameDst;

        public void init(int total) {
            this.src = new int[total];
            this.dst = new int[total];
        }

        public int size() {
            return this.src.length;
        }

        public void reset() {
            this.src = null;
            this.dst = null;
            this.frameSrc = null;
            this.frameDst = null;
        }
    }
}

