/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.abst.disparity.StereoDisparity;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.mvs.BundleToRectificationStereoParameters;
import boofcv.alg.mvs.CreateCloudFromDisparityImages;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.alg.mvs.MultiBaselineStereoIndependent;
import boofcv.alg.mvs.ScoreRectifiedViewCoveragePixels;
import boofcv.alg.mvs.StereoPairGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.LookUpImages;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.PointToPixelTransform_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class MultiViewStereoFromKnownSceneStructure<T extends ImageGray<T>>
implements VerbosePrint {
    public double minimumQuality3D = 0.25;
    @Nullable
    protected Listener<T> listener;
    protected final List<ViewInfo> listCenters = new ArrayList<ViewInfo>();
    final LookUpImages imageLookUp;
    final ScoreRectifiedViewCoveragePixels scoreCoverage = new ScoreRectifiedViewCoveragePixels();
    final BundleToRectificationStereoParameters computeRectification = new BundleToRectificationStereoParameters();
    final MultiBaselineStereoIndependent<T> computeFused;
    final CreateCloudFromDisparityImages disparityCloud = new CreateCloudFromDisparityImages();
    final Map<String, ViewInfo> mapScores = new HashMap<String, ViewInfo>();
    final DogArray<ViewInfo> arrayScores = new DogArray<ViewInfo>(ViewInfo::new, ViewInfo::reset);
    TIntObjectMap<String> indexSbaToViewID = new TIntObjectHashMap<String>();
    DogArray_I32 imagePairIndexesSba = new DogArray_I32();
    GrayU8 dummyMask = new GrayU8(1, 1);
    CameraPinholeBrown brown = new CameraPinholeBrown();
    Se3_F64 world_to_view1 = new Se3_F64();
    Se3_F64 world_to_view2 = new Se3_F64();
    Se3_F64 view1_to_view2 = new Se3_F64();
    Se3_F64 tmp = new Se3_F64();
    @Nullable
    PrintStream verbose = null;

    public MultiViewStereoFromKnownSceneStructure(LookUpImages imageLookUp, ImageType<T> imageType) {
        this.computeFused = new MultiBaselineStereoIndependent<T>(imageLookUp, imageType);
        this.imageLookUp = imageLookUp;
    }

    public void process(SceneStructureMetric scene, StereoPairGraph pairs) {
        this.initializeListener();
        this.initializeScores(scene, pairs);
        this.scoreViewsSelectStereoPairs(scene);
        this.disparityCloud.reset();
        this.listCenters.clear();
        Collections.sort(this.arrayScores.toList(), Comparator.comparingDouble(a -> -a.score));
        for (int index = 0; index < this.arrayScores.size; ++index) {
            ViewInfo center = (ViewInfo)this.arrayScores.get(index);
            if (center.used) continue;
            if (this.verbose != null) {
                this.verbose.println("Center[" + index + "] View=" + center.relations.id);
            }
            this.selectAndLoadConnectedImages(pairs, center.relations);
            if (this.imagePairIndexesSba.size() < 1) {
                if (this.verbose == null) continue;
                this.verbose.println("  too few connections to use as a center");
                continue;
            }
            this.listCenters.add(center);
            this.indexSbaToViewID.put(center.relations.indexSba, center.relations.id);
            this.computeFusedDisparityAddCloud(scene, center, this.indexSbaToViewID, this.imagePairIndexesSba);
        }
    }

    void initializeListener() {
        Objects.requireNonNull(this.computeFused.getStereoDisparity(), "Must call setStereoDisparity() first");
        if (this.listener != null) {
            this.computeFused.setListener((int left, int right, Image rectLeft, Image rectRight, GrayF32 disparity, GrayU8 mask, DisparityParameters parameters, DMatrixRMaj rect) -> {
                String leftID = this.indexSbaToViewID.get(left);
                String rightID = this.indexSbaToViewID.get(right);
                this.listener.handlePairDisparity(leftID, rightID, rectLeft, rectRight, disparity, mask, parameters);
            });
        } else {
            this.computeFused.setListener(null);
        }
    }

    void initializeScores(SceneStructureMetric scene, StereoPairGraph stereoPairs) {
        this.arrayScores.resize(stereoPairs.vertexes.size());
        this.arrayScores.reset();
        this.mapScores.clear();
        for (StereoPairGraph.Vertex node : stereoPairs.vertexes.values()) {
            ViewInfo info = this.arrayScores.grow();
            info.metric = (SceneStructureMetric.View)scene.views.get(node.indexSba);
            this.imageLookUp.loadShape(node.id, info.dimension);
            info.index = this.arrayScores.size - 1;
            info.relations = node;
            this.mapScores.put(info.relations.id, info);
        }
    }

    void scoreViewsSelectStereoPairs(SceneStructureMetric scene) {
        for (int i = 0; i < this.arrayScores.size; ++i) {
            ViewInfo center = (ViewInfo)this.arrayScores.get(i);
            List<StereoPairGraph.Edge> pairs = center.relations.pairs;
            BundleAdjustmentCamera candidateCamera = ((SceneStructureCommon.Camera)scene.cameras.get((int)center.metric.camera)).model;
            this.computeRectification.setView1(candidateCamera, center.dimension.width, center.dimension.height);
            this.scoreCoverage.initialize(center.dimension.width, center.dimension.height, this.computeRectification.view1_dist_to_undist);
            scene.getWorldToView(center.metric, this.world_to_view1, this.tmp);
            int totalQualifiedConnections = 0;
            double averageQuality = 0.0;
            for (int pairIdx = 0; pairIdx < pairs.size(); ++pairIdx) {
                StereoPairGraph.Edge pair = pairs.get(pairIdx);
                BoofMiscOps.checkTrue(pair.quality3D >= 0.0 && pair.quality3D <= 1.0);
                if (pair.quality3D < this.minimumQuality3D) continue;
                ++totalQualifiedConnections;
                averageQuality += pair.quality3D;
                ViewInfo connected = this.mapScores.get(pair.other((StereoPairGraph.Vertex)center.relations).id);
                BundleAdjustmentCamera connectedCamera = ((SceneStructureCommon.Camera)scene.cameras.get((int)connected.metric.camera)).model;
                scene.getWorldToView(connected.metric, this.world_to_view2, this.tmp);
                this.world_to_view1.invert(this.tmp).concat(this.world_to_view2, this.view1_to_view2);
                this.computeRectification.processView2(connectedCamera, connected.dimension.width, connected.dimension.height, this.view1_to_view2);
                this.scoreCoverage.addView(connected.dimension.width, connected.dimension.height, this.computeRectification.undist_to_rect2, (float)pair.quality3D);
            }
            this.scoreCoverage.process();
            center.score = this.scoreCoverage.getScore();
            if (this.verbose == null) continue;
            averageQuality = totalQualifiedConnections > 0 ? averageQuality / (double)totalQualifiedConnections : -1.0;
            this.verbose.println("View[" + center.relations.id + "] center score=" + center.score + " aveQuality=" + averageQuality + "  conn=" + totalQualifiedConnections + "/" + pairs.size());
        }
    }

    void computeFusedDisparityAddCloud(SceneStructureMetric scene, ViewInfo center, TIntObjectMap<String> sbaIndexToName, DogArray_I32 pairIndexes) {
        if (!this.computeFused.process(scene, center.relations.indexSba, pairIndexes, sbaIndexToName::get)) {
            throw new RuntimeException("Disparity failed!");
        }
        GrayF32 disparity = this.computeFused.fusedDisparity;
        this.dummyMask.reshape(disparity);
        ImageMiscOps.fill(this.dummyMask, 0);
        if (this.listener != null) {
            this.listener.handleFusedDisparity(center.relations.id, disparity, this.dummyMask, this.computeFused.fusedParam);
        }
        BundleAdjustmentCamera camera = ((SceneStructureCommon.Camera)scene.cameras.get((int)center.metric.camera)).model;
        BundleAdjustmentOps.convert(camera, disparity.width, disparity.height, this.brown);
        Point2Transform2_F64 norm_to_pixel = new LensDistortionBrown(this.brown).distort_F64(false, true);
        Point2Transform2_F64 pixel_to_norm = new LensDistortionBrown(this.brown).undistort_F64(true, false);
        scene.getWorldToView(center.metric, this.world_to_view1, this.tmp);
        this.disparityCloud.addDisparity(disparity, this.dummyMask, this.world_to_view1, this.computeFused.fusedParam, norm_to_pixel, new PointToPixelTransform_F64(pixel_to_norm));
    }

    void selectAndLoadConnectedImages(StereoPairGraph pairs, StereoPairGraph.Vertex center) {
        this.indexSbaToViewID.clear();
        this.imagePairIndexesSba.reset();
        List<StereoPairGraph.Edge> connections = Objects.requireNonNull(pairs.vertexes.get((Object)center.id)).pairs;
        for (int connIdx = 0; connIdx < connections.size(); ++connIdx) {
            StereoPairGraph.Edge connected = connections.get(connIdx);
            if (connected.quality3D < this.minimumQuality3D) continue;
            StereoPairGraph.Vertex other = connected.other(center);
            if (this.verbose != null) {
                this.verbose.println("  connected.id=" + other.id);
            }
            this.indexSbaToViewID.put(other.indexSba, other.id);
            this.imagePairIndexesSba.add(other.indexSba);
            this.mapScores.get((Object)other.id).used = true;
        }
    }

    public List<Point3D_F64> getCloud() {
        return this.disparityCloud.cloud.toList();
    }

    public void setStereoDisparity(StereoDisparity<T, GrayF32> stereoDisparity) {
        this.computeFused.setStereoDisparity(stereoDisparity);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public double getMinimumQuality3D() {
        return this.minimumQuality3D;
    }

    public void setMinimumQuality3D(double minimumQuality3D) {
        this.minimumQuality3D = minimumQuality3D;
    }

    @Nullable
    public Listener<T> getListener() {
        return this.listener;
    }

    public void setListener(@Nullable Listener<T> listener) {
        this.listener = listener;
    }

    public List<ViewInfo> getListCenters() {
        return this.listCenters;
    }

    public ScoreRectifiedViewCoveragePixels getScoreCoverage() {
        return this.scoreCoverage;
    }

    public BundleToRectificationStereoParameters getComputeRectification() {
        return this.computeRectification;
    }

    public MultiBaselineStereoIndependent<T> getComputeFused() {
        return this.computeFused;
    }

    public CreateCloudFromDisparityImages getDisparityCloud() {
        return this.disparityCloud;
    }

    public static class ViewInfo {
        SceneStructureMetric.View metric;
        StereoPairGraph.Vertex relations;
        final ImageDimension dimension = new ImageDimension();
        int index;
        double score;
        boolean used;

        void reset() {
            this.metric = null;
            this.relations = null;
            this.dimension.setTo(0, 0);
            this.index = -1;
            this.score = -1.0;
            this.used = false;
        }
    }

    public static interface Listener<RectImg> {
        public void handlePairDisparity(String var1, String var2, RectImg var3, RectImg var4, GrayF32 var5, GrayU8 var6, DisparityParameters var7);

        public void handleFusedDisparity(String var1, GrayF32 var2, GrayU8 var3, DisparityParameters var4);
    }
}

