/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.mvs.PointToIndexIterator;
import boofcv.core.image.LookUpColorRgb;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.PointIndex3D_F64;
import boofcv.struct.geo.PointIndex4D_F64;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.Iterator;
import java.util.List;

public class ColorizeCloudFromImage<T extends ImageBase<T>> {
    protected final LookUpColorRgb<T> colorLookup;
    protected final Point3D_F64 viewPt = new Point3D_F64();
    protected final Point4D_F64 viewPt4 = new Point4D_F64();
    protected final Point2D_F64 pixel = new Point2D_F64();

    public ColorizeCloudFromImage(LookUpColorRgb<T> colorLookup) {
        this.colorLookup = colorLookup;
    }

    public void process3(T image, List<Point3D_F64> cloud, int idx0, int idx1, Se3_F64 world_to_view, Point2Transform2_F64 norm_to_pixel, BoofLambdas.IndexRgbConsumer colorizer) {
        PointToIndexIterator<PointIndex3D_F64, Point3D_F64> iterator = new PointToIndexIterator<PointIndex3D_F64, Point3D_F64>(cloud, idx0, idx1, new PointIndex3D_F64());
        this.process3(image, iterator, world_to_view, norm_to_pixel, colorizer);
    }

    public void process3(T image, Iterator<PointIndex3D_F64> cloud, Se3_F64 world_to_view, Point2Transform2_F64 norm_to_pixel, BoofLambdas.IndexRgbConsumer colorizer) {
        this.colorLookup.setImage(image);
        while (cloud.hasNext()) {
            PointIndex3D_F64 pidx = cloud.next();
            world_to_view.transform((Point3D_F64)pidx.p, this.viewPt);
            if (this.viewPt.z <= 0.0) continue;
            norm_to_pixel.compute(this.viewPt.x / this.viewPt.z, this.viewPt.y / this.viewPt.z, this.pixel);
            if (!BoofMiscOps.isInside(image, this.pixel.x, this.pixel.y)) continue;
            int xx = (int)(this.pixel.x + 0.5);
            int yy = (int)(this.pixel.y + 0.5);
            int rgb = this.colorLookup.lookupRgb(xx, yy);
            colorizer.setRgb(pidx.index, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
    }

    public void process4(T image, List<Point4D_F64> cloud, int idx0, int idx1, Se3_F64 world_to_view, Point2Transform2_F64 norm_to_pixel, BoofLambdas.IndexRgbConsumer colorizer) {
        PointToIndexIterator<PointIndex4D_F64, Point4D_F64> iterator = new PointToIndexIterator<PointIndex4D_F64, Point4D_F64>(cloud, idx0, idx1, new PointIndex4D_F64());
        this.process4(image, iterator, world_to_view, norm_to_pixel, colorizer);
    }

    public void process4(T image, Iterator<PointIndex4D_F64> cloud, Se3_F64 world_to_view, Point2Transform2_F64 norm_to_pixel, BoofLambdas.IndexRgbConsumer colorizer) {
        this.colorLookup.setImage(image);
        while (cloud.hasNext()) {
            PointIndex4D_F64 pidx = cloud.next();
            SePointOps_F64.transform(world_to_view, (Point4D_F64)pidx.p, this.viewPt4);
            if (Math.signum(this.viewPt4.z) * Math.signum(this.viewPt4.w) < 0.0) continue;
            norm_to_pixel.compute(this.viewPt4.x / this.viewPt4.z, this.viewPt4.y / this.viewPt4.z, this.pixel);
            if (!BoofMiscOps.isInside(image, this.pixel.x, this.pixel.y)) continue;
            int xx = (int)(this.pixel.x + 0.5);
            int yy = (int)(this.pixel.y + 0.5);
            int rgb = this.colorLookup.lookupRgb(xx, yy);
            colorizer.setRgb(pidx.index, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
    }

    public LookUpColorRgb<T> getColorLookup() {
        return this.colorLookup;
    }
}

