/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.PixelMathLambdas;
import boofcv.alg.misc.impl.ImplPixelMath;
import boofcv.alg.misc.impl.ImplPixelMath_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;

public class PixelMath {
    public static int SMALL_IMAGE = 10000;

    public static void lambda1(GrayI8 input, PixelMathLambdas.Function1_I8 function, GrayI8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(InterleavedI8 input, PixelMathLambdas.Function1_I8 function, InterleavedI8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(GrayI16 input, PixelMathLambdas.Function1_I16 function, GrayI16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(InterleavedI16 input, PixelMathLambdas.Function1_I16 function, InterleavedI16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(GrayS32 input, PixelMathLambdas.Function1_S32 function, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(InterleavedS32 input, PixelMathLambdas.Function1_S32 function, InterleavedS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(GrayS64 input, PixelMathLambdas.Function1_S64 function, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(InterleavedS64 input, PixelMathLambdas.Function1_S64 function, InterleavedS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(GrayF32 input, PixelMathLambdas.Function1_F32 function, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(InterleavedF32 input, PixelMathLambdas.Function1_F32 function, InterleavedF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(GrayF64 input, PixelMathLambdas.Function1_F64 function, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda1(InterleavedF64 input, PixelMathLambdas.Function1_F64 function, InterleavedF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        } else {
            ImplPixelMath.lambda1(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns, function);
        }
    }

    public static void lambda2(GrayI8 imgA, PixelMathLambdas.Function2_I8 function, GrayI8 imgB, GrayI8 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(InterleavedI8 imgA, PixelMathLambdas.Function2_I8 function, InterleavedI8 imgB, InterleavedI8 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width * imgA.numBands;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(GrayI16 imgA, PixelMathLambdas.Function2_I16 function, GrayI16 imgB, GrayI16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(InterleavedI16 imgA, PixelMathLambdas.Function2_I16 function, InterleavedI16 imgB, InterleavedI16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width * imgA.numBands;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(GrayS32 imgA, PixelMathLambdas.Function2_S32 function, GrayS32 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(InterleavedS32 imgA, PixelMathLambdas.Function2_S32 function, InterleavedS32 imgB, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width * imgA.numBands;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(GrayS64 imgA, PixelMathLambdas.Function2_S64 function, GrayS64 imgB, GrayS64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(InterleavedS64 imgA, PixelMathLambdas.Function2_S64 function, InterleavedS64 imgB, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width * imgA.numBands;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(GrayF32 imgA, PixelMathLambdas.Function2_F32 function, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(InterleavedF32 imgA, PixelMathLambdas.Function2_F32 function, InterleavedF32 imgB, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width * imgA.numBands;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(GrayF64 imgA, PixelMathLambdas.Function2_F64 function, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void lambda2(InterleavedF64 imgA, PixelMathLambdas.Function2_F64 function, InterleavedF64 imgB, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int columns = imgA.width * imgA.numBands;
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        } else {
            ImplPixelMath.lambda2(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, output.data, output.startIndex, output.stride, imgA.height, columns, function);
        }
    }

    public static void abs(GrayS8 input, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(InterleavedS8 input, InterleavedS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(GrayS16 input, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(InterleavedS16 input, InterleavedS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(GrayS32 input, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(InterleavedS32 input, InterleavedS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(GrayS64 input, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(InterleavedS64 input, InterleavedS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(GrayF32 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(InterleavedF32 input, InterleavedF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(GrayF64 input, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void abs(InterleavedF64 input, InterleavedF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(GrayS8 input, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(InterleavedS8 input, InterleavedS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(GrayS16 input, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(InterleavedS16 input, InterleavedS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(GrayS32 input, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(InterleavedS32 input, InterleavedS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(GrayS64 input, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(InterleavedS64 input, InterleavedS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(GrayF32 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(InterleavedF32 input, InterleavedF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(GrayF64 input, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void negative(InterleavedF64 input, InterleavedF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.negative(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayU8 input, double value, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedU8 input, double value, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS8 input, double value, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS8 input, double value, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayU16 input, double value, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedU16 input, double value, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS16 input, double value, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS16 input, double value, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS32 input, double value, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS32 input, double value, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS64 input, double value, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS64 input, double value, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayF32 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedF32 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayF64 input, double value, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedF64 input, double value, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayU8 input, double value, int lower, int upper, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedU8 input, double value, int lower, int upper, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS8 input, double value, int lower, int upper, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS8 input, double value, int lower, int upper, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayU16 input, double value, int lower, int upper, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedU16 input, double value, int lower, int upper, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS16 input, double value, int lower, int upper, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS16 input, double value, int lower, int upper, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS32 input, double value, int lower, int upper, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS32 input, double value, int lower, int upper, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS64 input, double value, long lower, long upper, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS64 input, double value, long lower, long upper, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayF32 input, float value, float lower, float upper, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedF32 input, float value, float lower, float upper, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayF64 input, double value, double lower, double upper, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedF64 input, double value, double lower, double upper, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayU8 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedU8 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS8 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS8 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayU16 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedU16 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS16 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS16 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS32 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS32 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(GrayS64 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void multiply(InterleavedS64 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayU8 input, double denominator, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedU8 input, double denominator, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS8 input, double denominator, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS8 input, double denominator, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayU16 input, double denominator, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedU16 input, double denominator, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS16 input, double denominator, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS16 input, double denominator, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS32 input, double denominator, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS32 input, double denominator, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS64 input, double denominator, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS64 input, double denominator, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayF32 input, float denominator, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedF32 input, float denominator, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayF64 input, double denominator, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedF64 input, double denominator, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayU8 input, double denominator, int lower, int upper, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedU8 input, double denominator, int lower, int upper, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS8 input, double denominator, int lower, int upper, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS8 input, double denominator, int lower, int upper, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayU16 input, double denominator, int lower, int upper, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedU16 input, double denominator, int lower, int upper, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS16 input, double denominator, int lower, int upper, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS16 input, double denominator, int lower, int upper, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS32 input, double denominator, int lower, int upper, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS32 input, double denominator, int lower, int upper, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS64 input, double denominator, long lower, long upper, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS64 input, double denominator, long lower, long upper, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayF32 input, float denominator, float lower, float upper, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedF32 input, float denominator, float lower, float upper, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayF64 input, double denominator, double lower, double upper, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedF64 input, double denominator, double lower, double upper, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayU8 input, float denominator, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedU8 input, float denominator, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS8 input, float denominator, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS8 input, float denominator, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayU16 input, float denominator, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedU16 input, float denominator, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS16 input, float denominator, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS16 input, float denominator, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS32 input, float denominator, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS32 input, float denominator, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(GrayS64 input, float denominator, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void divide(InterleavedS64 input, float denominator, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayU8 input, int value, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedU8 input, int value, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS8 input, int value, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS8 input, int value, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayU16 input, int value, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedU16 input, int value, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS16 input, int value, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS16 input, int value, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS32 input, int value, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS32 input, int value, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS64 input, long value, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS64 input, long value, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayF32 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedF32 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayF64 input, double value, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedF64 input, double value, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayU8 input, int value, int lower, int upper, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedU8 input, int value, int lower, int upper, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS8 input, int value, int lower, int upper, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS8 input, int value, int lower, int upper, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayU16 input, int value, int lower, int upper, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedU16 input, int value, int lower, int upper, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS16 input, int value, int lower, int upper, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS16 input, int value, int lower, int upper, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS32 input, int value, int lower, int upper, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS32 input, int value, int lower, int upper, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS64 input, long value, long lower, long upper, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS64 input, long value, long lower, long upper, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayF32 input, float value, float lower, float upper, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedF32 input, float value, float lower, float upper, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayF64 input, double value, double lower, double upper, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedF64 input, double value, double lower, double upper, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayU8 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedU8 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS8 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS8 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayU16 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedU16 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS16 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS16 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS32 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS32 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(GrayS64 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void plus(InterleavedS64 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayU8 input, int value, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedU8 input, int value, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS8 input, int value, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS8 input, int value, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayU16 input, int value, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedU16 input, int value, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS16 input, int value, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS16 input, int value, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS32 input, int value, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS32 input, int value, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS64 input, long value, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS64 input, long value, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayF32 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedF32 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayF64 input, double value, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedF64 input, double value, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayU8 input, int value, int lower, int upper, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedU8 input, int value, int lower, int upper, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS8 input, int value, int lower, int upper, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS8 input, int value, int lower, int upper, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayU16 input, int value, int lower, int upper, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedU16 input, int value, int lower, int upper, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS16 input, int value, int lower, int upper, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS16 input, int value, int lower, int upper, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS32 input, int value, int lower, int upper, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS32 input, int value, int lower, int upper, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS64 input, long value, long lower, long upper, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS64 input, long value, long lower, long upper, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayF32 input, float value, float lower, float upper, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedF32 input, float value, float lower, float upper, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayF64 input, double value, double lower, double upper, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedF64 input, double value, double lower, double upper, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayU8 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedU8 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS8 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS8 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayU16 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedU16 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS16 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS16 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS32 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS32 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(GrayS64 input, float value, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(InterleavedS64 input, float value, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayU8 input, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedU8 input, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayS8 input, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedS8 input, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayU16 input, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedU16 input, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayS16 input, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedS16 input, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayS32 input, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedS32 input, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(long value, GrayS64 input, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(long value, InterleavedS64 input, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayF32 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedF32 input, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(double value, GrayF64 input, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(double value, InterleavedF64 input, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayU8 input, int lower, int upper, GrayU8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedU8 input, int lower, int upper, InterleavedU8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayS8 input, int lower, int upper, GrayS8 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedS8 input, int lower, int upper, InterleavedS8 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayU16 input, int lower, int upper, GrayU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedU16 input, int lower, int upper, InterleavedU16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayS16 input, int lower, int upper, GrayS16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedS16 input, int lower, int upper, InterleavedS16 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, GrayS32 input, int lower, int upper, GrayS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(int value, InterleavedS32 input, int lower, int upper, InterleavedS32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(long value, GrayS64 input, long lower, long upper, GrayS64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(long value, InterleavedS64 input, long lower, long upper, InterleavedS64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayF32 input, float lower, float upper, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedF32 input, float lower, float upper, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(double value, GrayF64 input, double lower, double upper, GrayF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(double value, InterleavedF64 input, double lower, double upper, InterleavedF64 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayU8 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedU8 input, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayS8 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedS8 input, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayU16 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedU16 input, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayS16 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedS16 input, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayS32 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedS32 input, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, GrayS64 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void minus(float value, InterleavedS64 input, InterleavedF32 output) {
        output.reshape(input.width, input.height, input.numBands);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void boundImage(GrayU8 img, int min, int max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayU8 imgA, GrayU8 imgB, GrayU8 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void boundImage(GrayS8 img, int min, int max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayS8 imgA, GrayS8 imgB, GrayS8 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void boundImage(GrayU16 img, int min, int max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayU16 imgA, GrayU16 imgB, GrayU16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void boundImage(GrayS16 img, int min, int max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayS16 imgA, GrayS16 imgB, GrayS16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void boundImage(GrayS32 img, int min, int max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayS32 imgA, GrayS32 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void boundImage(GrayS64 img, long min, long max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayS64 imgA, GrayS64 imgB, GrayS64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void boundImage(GrayF32 img, float min, float max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void boundImage(GrayF64 img, double min, double max) {
        ImplPixelMath.boundImage(img, min, max);
    }

    public static void diffAbs(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.diffAbs(imgA, imgB, output);
        } else {
            ImplPixelMath.diffAbs(imgA, imgB, output);
        }
    }

    public static void add(GrayU8 imgA, GrayU8 imgB, GrayU16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayU8 imgA, GrayU8 imgB, GrayI16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void add(GrayS8 imgA, GrayS8 imgB, GrayS16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayS8 imgA, GrayS8 imgB, GrayS16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void add(GrayU16 imgA, GrayU16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayU16 imgA, GrayU16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void add(GrayS16 imgA, GrayS16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayS16 imgA, GrayS16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void add(GrayS32 imgA, GrayS32 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayS32 imgA, GrayS32 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void add(GrayS64 imgA, GrayS64 imgB, GrayS64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayS64 imgA, GrayS64 imgB, GrayS64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void add(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void multiply(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply(imgA, imgB, output);
        } else {
            ImplPixelMath.multiply(imgA, imgB, output);
        }
    }

    public static void divide(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide(imgA, imgB, output);
        } else {
            ImplPixelMath.divide(imgA, imgB, output);
        }
    }

    public static void log(GrayF32 input, float val2, GrayF32 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void logSign(GrayF32 input, float val2, GrayF32 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void sqrt(GrayF32 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void log(InterleavedF32 input, float val2, InterleavedF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void logSign(InterleavedF32 input, float val2, InterleavedF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void sqrt(InterleavedF32 input, InterleavedF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void add(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.add(imgA, imgB, output);
        } else {
            ImplPixelMath.add(imgA, imgB, output);
        }
    }

    public static void subtract(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.subtract(imgA, imgB, output);
        } else {
            ImplPixelMath.subtract(imgA, imgB, output);
        }
    }

    public static void multiply(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.multiply(imgA, imgB, output);
        } else {
            ImplPixelMath.multiply(imgA, imgB, output);
        }
    }

    public static void divide(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB);
        output.reshape(imgA.width, imgA.height);
        int N = imgA.width * imgA.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.divide(imgA, imgB, output);
        } else {
            ImplPixelMath.divide(imgA, imgB, output);
        }
    }

    public static void log(GrayF64 input, double val2, GrayF64 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void logSign(GrayF64 input, double val2, GrayF64 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void sqrt(GrayF64 input, GrayF64 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void log(InterleavedF64 input, double val2, InterleavedF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.log(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void logSign(InterleavedF64 input, double val2, InterleavedF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.logSign(input.data, input.startIndex, input.stride, val2, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void sqrt(InterleavedF64 input, InterleavedF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.sqrt(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void pow2(GrayU8 input, GrayU16 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void pow2(InterleavedU8 input, InterleavedU16 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void stdev(GrayU8 mean, GrayU16 pow2, GrayU8 stdev) {
        InputSanityCheck.checkSameShape(mean, pow2);
        stdev.reshape(mean.width, mean.height);
        int N = mean.width * mean.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.stdev(mean, pow2, stdev);
        } else {
            ImplPixelMath.stdev(mean, pow2, stdev);
        }
    }

    public static void pow2(GrayU16 input, GrayS32 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void pow2(InterleavedU16 input, InterleavedS32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void stdev(GrayU16 mean, GrayS32 pow2, GrayU16 stdev) {
        InputSanityCheck.checkSameShape(mean, pow2);
        stdev.reshape(mean.width, mean.height);
        int N = mean.width * mean.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.stdev(mean, pow2, stdev);
        } else {
            ImplPixelMath.stdev(mean, pow2, stdev);
        }
    }

    public static void pow2(GrayF32 input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void pow2(InterleavedF32 input, InterleavedF32 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void stdev(GrayF32 mean, GrayF32 pow2, GrayF32 stdev) {
        InputSanityCheck.checkSameShape(mean, pow2);
        stdev.reshape(mean.width, mean.height);
        int N = mean.width * mean.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.stdev(mean, pow2, stdev);
        } else {
            ImplPixelMath.stdev(mean, pow2, stdev);
        }
    }

    public static void pow2(GrayF64 input, GrayF64 output) {
        output.reshape(input.width, input.height);
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, input.width);
        }
    }

    public static void pow2(InterleavedF64 input, InterleavedF64 output) {
        output.reshape(input.width, input.height);
        int columns = input.width * input.numBands;
        int N = input.width * input.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        } else {
            ImplPixelMath.pow2(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
        }
    }

    public static void stdev(GrayF64 mean, GrayF64 pow2, GrayF64 stdev) {
        InputSanityCheck.checkSameShape(mean, pow2);
        stdev.reshape(mean.width, mean.height);
        int N = mean.width * mean.height;
        if (BoofConcurrency.USE_CONCURRENT && N > SMALL_IMAGE) {
            ImplPixelMath_MT.stdev(mean, pow2, stdev);
        } else {
            ImplPixelMath.stdev(mean, pow2, stdev);
        }
    }
}

