/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.GImageStatistics;
import boofcv.alg.misc.GPixelMath;
import boofcv.alg.misc.NormalizeParameters;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public class ImageNormalization {
    public static void apply(ImageGray input, NormalizeParameters parameter, ImageGray output) {
        GPixelMath.plus(input, parameter.offset, output);
        GPixelMath.multiply(output, 1.0 / parameter.divisor, output);
    }

    public static void maxAbsOfOne(ImageGray input, ImageGray output, @Nullable NormalizeParameters parameters) {
        output.reshape(input);
        if (output.getDataType().isInteger()) {
            throw new IllegalArgumentException("Output must be a floating point image");
        }
        double scale = GImageStatistics.maxAbs(input);
        if (scale == 0.0) {
            scale = 1.0;
        } else {
            GPixelMath.multiply(input, 1.0 / scale, output);
        }
        if (parameters != null) {
            parameters.offset = 0.0;
            parameters.divisor = scale;
        }
    }

    public static void zeroMeanMaxOne(ImageGray input, ImageGray output, @Nullable NormalizeParameters parameters) {
        output.reshape(input);
        if (output.getDataType().isInteger()) {
            throw new IllegalArgumentException("Output must be a floating point image");
        }
        double scale = GImageStatistics.maxAbs(input);
        if (scale != 0.0) {
            double scale2;
            GPixelMath.multiply(input, 1.0 / scale, output);
            double mean = GImageStatistics.mean(output);
            GPixelMath.minus(output, mean, output);
            if (input.getDataType().isSigned()) {
                scale2 = GImageStatistics.maxAbs(output);
            } else {
                double d = scale2 = mean < 0.5 ? 1.0 - mean : mean;
            }
            if (scale2 != 0.0) {
                GPixelMath.multiply(output, 1.0 / scale2, output);
            } else {
                scale2 = 1.0;
            }
            if (parameters != null) {
                parameters.offset = -mean * scale;
                parameters.divisor = scale * scale2;
            }
        } else if (parameters != null) {
            parameters.offset = 0.0;
            parameters.divisor = 1.0;
        }
    }

    public static void zeroMeanStdOne(ImageGray input, ImageGray output, @Nullable NormalizeParameters parameters) {
        output.reshape(input);
        if (output.getDataType().isInteger()) {
            throw new IllegalArgumentException("Output must be a floating point image");
        }
        double scale = GImageStatistics.maxAbs(input);
        if (scale != 0.0) {
            GPixelMath.multiply(input, 1.0 / scale, output);
            double mean = GImageStatistics.mean(output);
            double stdev = Math.sqrt(GImageStatistics.variance(output, mean));
            GPixelMath.minus(output, mean, output);
            if (stdev != 0.0) {
                GPixelMath.multiply(output, 1.0 / stdev, output);
            } else {
                stdev = 1.0;
            }
            if (parameters != null) {
                parameters.offset = -mean * scale;
                parameters.divisor = stdev * scale;
            }
        } else if (parameters != null) {
            parameters.offset = 0.0;
            parameters.divisor = 1.0;
        }
    }
}

