/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.NearestNeighborPixelS;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;

public class NearestNeighborPixel_U8
extends NearestNeighborPixelS<GrayU8> {
    private byte[] data;

    public NearestNeighborPixel_U8() {
    }

    public NearestNeighborPixel_U8(GrayU8 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(GrayU8 image) {
        super.setImage(image);
        this.data = ((GrayU8)this.orig).data;
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((GrayU8)this.orig).startIndex + (int)y * this.stride + (int)x] & 0xFF;
    }

    public float get_border(float x, float y) {
        return ((ImageBorder_S32)this.border).get((int)Math.floor(x), (int)Math.floor(y));
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            return this.get_border(x, y);
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((GrayU8)this.orig).startIndex + yy * this.stride + xx] & 0xFF;
    }

    @Override
    public InterpolatePixelS<GrayU8> copy() {
        NearestNeighborPixel_U8 out = new NearestNeighborPixel_U8();
        out.setBorder(this.border);
        return out;
    }

    @Override
    public ImageType<GrayU8> getImageType() {
        return ImageType.single(GrayU8.class);
    }
}

