/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixelS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.ImageType;

public class ImplBilinearPixel_F64
extends BilinearPixelS<GrayF64> {
    public ImplBilinearPixel_F64() {
    }

    public ImplBilinearPixel_F64(GrayF64 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        double ax = x - (float)xt;
        double ay = y - (float)yt;
        int index = ((GrayF64)this.orig).startIndex + yt * this.stride + xt;
        double[] data = ((GrayF64)this.orig).data;
        double val2 = (1.0 - ax) * (1.0 - ay) * data[index];
        val2 += ax * (1.0 - ay) * data[index + 1];
        val2 += ax * ay * data[index + 1 + this.stride];
        return (float)(val2 += (1.0 - ax) * ay * data[index + this.stride]);
    }

    public float get_border(float x, float y) {
        double xf = Math.floor(x);
        double yf = Math.floor(y);
        int xt = (int)xf;
        int yt = (int)yf;
        double ax = (double)x - xf;
        double ay = (double)y - yf;
        ImageBorder_F64 border = (ImageBorder_F64)this.border;
        double val2 = (1.0 - ax) * (1.0 - ay) * border.get(xt, yt);
        val2 += ax * (1.0 - ay) * border.get(xt + 1, yt);
        val2 += ax * ay * border.get(xt + 1, yt + 1);
        return (float)(val2 += (1.0 - ax) * ay * border.get(xt, yt + 1));
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 2) || y > (float)(this.height - 2)) {
            return this.get_border(x, y);
        }
        return this.get_fast(x, y);
    }

    @Override
    public InterpolatePixelS<GrayF64> copy() {
        ImplBilinearPixel_F64 out = new ImplBilinearPixel_F64();
        out.setBorder(this.border);
        return out;
    }

    @Override
    public ImageType<GrayF64> getImageType() {
        return ImageType.single(GrayF64.class);
    }
}

