/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.struct.calib.CameraPinhole;
import georegression.struct.homography.Homography2D_F64;
import java.util.Arrays;
import java.util.List;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class SelfCalibrationLinearRotationSingle {
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(10, 10, false, true, true);
    double singularThreshold = 1.0E-5;
    boolean singular;
    double singularRatio;
    DMatrixRMaj A = new DMatrixRMaj(6, 6);

    public boolean estimate(List<Homography2D_F64> viewsI_to_view0, CameraPinhole calibration) {
        this.singular = false;
        int N = viewsI_to_view0.size();
        SelfCalibrationLinearRotationSingle.ensureDeterminantOfOne(viewsI_to_view0);
        this.A.reshape(N * 6, 6);
        for (int i = 0; i < N; ++i) {
            this.add(i, viewsI_to_view0.get(i), this.A);
        }
        if (!this.svd.decompose(this.A)) {
            return false;
        }
        DMatrixRMaj nv = new DMatrixRMaj(6, 1);
        SingularOps_DDRM.nullVector(this.svd, true, nv);
        if (!this.extractCalibration(nv, calibration)) {
            return false;
        }
        double[] sv = this.svd.getSingularValues();
        Arrays.sort(sv);
        return !(this.singularThreshold * sv[1] <= sv[0]);
    }

    public static void ensureDeterminantOfOne(List<Homography2D_F64> homography0toI) {
        int N = homography0toI.size();
        for (int i = 0; i < N; ++i) {
            Homography2D_F64 H = homography0toI.get(i);
            double d = CommonOps_DDF3.det(H);
            if (d < 0.0) {
                CommonOps_DDF3.divide(H, -Math.pow(-d, 0.3333333333333333));
                continue;
            }
            CommonOps_DDF3.divide(H, Math.pow(d, 0.3333333333333333));
        }
    }

    private boolean extractCalibration(DMatrixRMaj x, CameraPinhole calibration) {
        double s = x.data[5];
        double cx = calibration.cx = x.data[2] / s;
        double cy = calibration.cy = x.data[4] / s;
        double fy = calibration.fy = Math.sqrt(x.data[3] / s - cy * cy);
        double sk = calibration.skew = (x.data[1] / s - cx * cy) / fy;
        calibration.fx = Math.sqrt(x.data[0] / s - sk * sk - cx * cx);
        if (calibration.fx < 0.0 || calibration.fy < 0.0) {
            return false;
        }
        if (UtilEjml.isUncountable(fy) || UtilEjml.isUncountable(calibration.fx)) {
            return false;
        }
        return !UtilEjml.isUncountable(sk);
    }

    protected void add(int which, Homography2D_F64 H, DMatrixRMaj A2) {
        int idx = which * 6 * 6;
        A2.data[idx++] = H.a11 * H.a11 - 1.0;
        A2.data[idx++] = 2.0 * H.a11 * H.a12;
        A2.data[idx++] = 2.0 * H.a11 * H.a13;
        A2.data[idx++] = H.a12 * H.a12;
        A2.data[idx++] = 2.0 * H.a12 * H.a13;
        A2.data[idx++] = H.a13 * H.a13;
        A2.data[idx++] = H.a11 * H.a21;
        A2.data[idx++] = H.a12 * H.a21 + H.a11 * H.a22 - 1.0;
        A2.data[idx++] = H.a13 * H.a21 + H.a11 * H.a23;
        A2.data[idx++] = H.a12 * H.a22;
        A2.data[idx++] = H.a13 * H.a22 + H.a12 * H.a23;
        A2.data[idx++] = H.a13 * H.a23;
        A2.data[idx++] = H.a11 * H.a31;
        A2.data[idx++] = H.a12 * H.a31 + H.a11 * H.a32;
        A2.data[idx++] = H.a13 * H.a31 + H.a11 * H.a33 - 1.0;
        A2.data[idx++] = H.a12 * H.a32;
        A2.data[idx++] = H.a13 * H.a32 + H.a12 * H.a33;
        A2.data[idx++] = H.a13 * H.a33;
        A2.data[idx++] = H.a21 * H.a21;
        A2.data[idx++] = 2.0 * H.a21 * H.a22;
        A2.data[idx++] = 2.0 * H.a21 * H.a23;
        A2.data[idx++] = H.a22 * H.a22 - 1.0;
        A2.data[idx++] = 2.0 * H.a22 * H.a23;
        A2.data[idx++] = H.a23 * H.a23;
        A2.data[idx++] = H.a21 * H.a31;
        A2.data[idx++] = H.a22 * H.a31 + H.a21 * H.a32;
        A2.data[idx++] = H.a23 * H.a31 + H.a21 * H.a33;
        A2.data[idx++] = H.a22 * H.a32;
        A2.data[idx++] = H.a23 * H.a32 + H.a22 * H.a33 - 1.0;
        A2.data[idx++] = H.a23 * H.a33;
        A2.data[idx++] = H.a31 * H.a31;
        A2.data[idx++] = 2.0 * H.a31 * H.a32;
        A2.data[idx++] = 2.0 * H.a31 * H.a33;
        A2.data[idx++] = H.a32 * H.a32;
        A2.data[idx++] = 2.0 * H.a32 * H.a33;
        A2.data[idx] = H.a33 * H.a33 - 1.0;
    }
}

