/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.GeometricResult;
import boofcv.struct.calib.CameraPinhole;
import georegression.struct.Matrix3x3_F64;
import georegression.struct.homography.Homography2D_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class SelfCalibrationLinearRotationMulti {
    private SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(10, 6, false, true, true);
    boolean zeroSkew;
    boolean principlePointOrigin;
    boolean knownAspectRatio;
    double aspectRatio;
    DMatrixRMaj A = new DMatrixRMaj(1, 1);
    Homography2D_F64 W0 = new Homography2D_F64();
    Homography2D_F64 Wi = new Homography2D_F64();
    Matrix3x3_F64 K = new Matrix3x3_F64();
    Matrix3x3_F64 tmp = new Matrix3x3_F64();
    DogArray_I32 notZeros = new DogArray_I32();
    DMatrixRMaj nv = new DMatrixRMaj(1, 1);
    DogArray<Homography2D_F64> listHInv = new DogArray<Homography2D_F64>(Homography2D_F64::new);
    DogArray<CameraPinhole> calibration = new DogArray<CameraPinhole>(CameraPinhole::new);

    public void setConstraints(boolean zeroSkew, boolean principlePointOrigin, boolean knownAspect, double aspect) {
        if (knownAspect && !zeroSkew) {
            throw new IllegalArgumentException("If aspect is known then skew must be zero");
        }
        this.zeroSkew = zeroSkew;
        this.principlePointOrigin = principlePointOrigin;
        this.knownAspectRatio = knownAspect;
        this.aspectRatio = aspect;
        this.notZeros.resize(6);
        for (int i = 0; i < 6; ++i) {
            this.notZeros.data[i] = i;
        }
        if (principlePointOrigin) {
            this.notZeros.remove(4);
            this.notZeros.remove(2);
        }
        if (zeroSkew) {
            this.notZeros.remove(1);
        }
    }

    public GeometricResult estimate(List<Homography2D_F64> viewsI_to_view0) {
        this.calibration.reset();
        int N = viewsI_to_view0.size();
        if (!this.computeInverseH(viewsI_to_view0)) {
            return GeometricResult.SOLVE_FAILED;
        }
        this.fillInConstraintMatrix();
        if (!this.svd.decompose(this.A)) {
            return GeometricResult.SOLVE_FAILED;
        }
        SingularOps_DDRM.nullVector(this.svd, true, this.nv);
        this.extractReferenceW(this.nv);
        this.convertW(this.W0, this.calibration.grow());
        for (int i = 0; i < N; ++i) {
            this.extractCalibration((Homography2D_F64)this.listHInv.get(i), this.calibration.grow());
        }
        return GeometricResult.SUCCESS;
    }

    public int numberOfConstraints() {
        int total = 0;
        if (this.zeroSkew) {
            ++total;
        }
        if (this.principlePointOrigin) {
            total += 2;
        }
        if (this.knownAspectRatio) {
            ++total;
        }
        return total;
    }

    void fillInConstraintMatrix() {
        int N = this.listHInv.size();
        this.A.reshape(N * this.numberOfConstraints(), 6);
        if (this.A.numRows < this.notZeros.size) {
            throw new IllegalArgumentException("More unknowns than equations");
        }
        double b = this.knownAspectRatio ? this.aspectRatio * this.aspectRatio : 1.0;
        int idx = 0;
        for (int i = 0; i < N; ++i) {
            Homography2D_F64 H = (Homography2D_F64)this.listHInv.get(i);
            if (this.zeroSkew) {
                this.A.data[idx++] = H.a11 * H.a12;
                this.A.data[idx++] = H.a12 * H.a21 + H.a11 * H.a22;
                this.A.data[idx++] = H.a12 * H.a31 + H.a11 * H.a32;
                this.A.data[idx++] = H.a21 * H.a22;
                this.A.data[idx++] = H.a22 * H.a31 + H.a21 * H.a32;
                this.A.data[idx++] = H.a31 * H.a32;
            }
            if (this.principlePointOrigin) {
                this.A.data[idx++] = H.a11 * H.a13;
                this.A.data[idx++] = H.a13 * H.a21 + H.a11 * H.a23;
                this.A.data[idx++] = H.a13 * H.a31 + H.a11 * H.a33;
                this.A.data[idx++] = H.a21 * H.a23;
                this.A.data[idx++] = H.a23 * H.a31 + H.a21 * H.a33;
                this.A.data[idx++] = H.a31 * H.a33;
                this.A.data[idx++] = H.a12 * H.a13;
                this.A.data[idx++] = H.a13 * H.a22 + H.a12 * H.a23;
                this.A.data[idx++] = H.a13 * H.a32 + H.a12 * H.a33;
                this.A.data[idx++] = H.a22 * H.a23;
                this.A.data[idx++] = H.a23 * H.a32 + H.a22 * H.a33;
                this.A.data[idx++] = H.a32 * H.a33;
            }
            if (!this.knownAspectRatio) continue;
            this.A.data[idx++] = H.a11 * H.a11 - H.a12 * H.a12 * b;
            this.A.data[idx++] = 2.0 * H.a11 * H.a21 - 2.0 * H.a12 * H.a22 * b;
            this.A.data[idx++] = 2.0 * H.a11 * H.a31 - 2.0 * H.a12 * H.a32 * b;
            this.A.data[idx++] = H.a21 * H.a21 - H.a22 * H.a22 * b;
            this.A.data[idx++] = 2.0 * H.a21 * H.a31 - 2.0 * H.a22 * H.a32 * b;
            this.A.data[idx++] = H.a31 * H.a31 - H.a32 * H.a32 * b;
        }
    }

    void extractReferenceW(DMatrixRMaj nv) {
        this.W0.a11 = nv.data[0];
        this.W0.a12 = this.W0.a21 = nv.data[1];
        this.W0.a13 = this.W0.a31 = nv.data[2];
        this.W0.a22 = nv.data[3];
        this.W0.a23 = this.W0.a32 = nv.data[4];
        this.W0.a33 = nv.data[5];
    }

    void convertW(Homography2D_F64 w, CameraPinhole c) {
        this.tmp.set(w);
        CommonOps_DDF3.divide(this.tmp, this.tmp.a33);
        CommonOps_DDF3.cholU(this.tmp);
        CommonOps_DDF3.invert(this.tmp, this.K);
        CommonOps_DDF3.divide(this.K, this.K.a33);
        c.fx = this.K.a11;
        c.fy = this.knownAspectRatio ? (this.K.a22 + c.fx * this.aspectRatio) / 2.0 : this.K.a22;
        c.skew = this.zeroSkew ? 0.0 : this.K.a12;
        c.cx = this.principlePointOrigin ? 0.0 : this.K.a13;
        c.cy = this.principlePointOrigin ? 0.0 : this.K.a23;
    }

    void extractCalibration(Homography2D_F64 Hinv, CameraPinhole c) {
        CommonOps_DDF3.multTransA(Hinv, this.W0, this.tmp);
        CommonOps_DDF3.mult((DMatrix3x3)this.tmp, (DMatrix3x3)Hinv, this.Wi);
        this.convertW(this.Wi, c);
    }

    public boolean computeInverseH(List<Homography2D_F64> homography0toI) {
        this.listHInv.reset();
        int N = homography0toI.size();
        for (int i = 0; i < N; ++i) {
            Homography2D_F64 H = homography0toI.get(i);
            Homography2D_F64 Hinv = this.listHInv.grow();
            double d = CommonOps_DDF3.det(H);
            if (d < 0.0) {
                CommonOps_DDF3.divide(H, -Math.pow(-d, 0.3333333333333333), Hinv);
            } else {
                CommonOps_DDF3.divide(H, Math.pow(d, 0.3333333333333333), Hinv);
            }
            if (CommonOps_DDF3.invert(Hinv, Hinv)) continue;
            return false;
        }
        return true;
    }

    public DogArray<CameraPinhole> getFound() {
        return this.calibration;
    }
}

