/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.robust.DistanceFromModelViews;
import boofcv.alg.geo.robust.ModelGeneratorViews;
import boofcv.alg.geo.robust.ModelMatcherViews;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageDimension;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class RansacProjective<Model, Point>
extends Ransac<Model, Point>
implements ModelMatcherViews<Model, Point, ImageDimension> {
    private final DistanceFromModelViews<Model, Point, ImageDimension> modelDistance;
    private final ModelGeneratorViews<Model, Point, ImageDimension> modelGenerator;

    public RansacProjective(long randSeed, ModelManager<Model> modelManager, ModelGeneratorViews<Model, Point, ImageDimension> modelGenerator, DistanceFromModelViews<Model, Point, ImageDimension> modelDistance, int maxIterations, double thresholdFit) {
        super(randSeed, modelManager, modelGenerator, modelDistance, maxIterations, thresholdFit);
        this.modelDistance = modelDistance;
        this.modelGenerator = modelGenerator;
        BoofMiscOps.checkTrue(modelDistance.getNumberOfViews() == modelGenerator.getNumberOfViews());
    }

    @Override
    public void setView(int view, ImageDimension intrinsic) {
        this.modelDistance.setView(view, intrinsic);
        this.modelGenerator.setView(view, intrinsic);
    }

    @Override
    public int getNumberOfViews() {
        return this.modelDistance.getNumberOfViews();
    }
}

