/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.trifocal.TrifocalTransfer;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceTrifocalTransferSq
implements DistanceFromModel<TrifocalTensor, AssociatedTriple> {
    TrifocalTransfer transfer = new TrifocalTransfer();
    Point3D_F64 c = new Point3D_F64();

    @Override
    public void setModel(TrifocalTensor trifocalTensor) {
        this.transfer.setTrifocal(trifocalTensor);
    }

    @Override
    public double distance(AssociatedTriple pt) {
        this.transfer.transfer_1_to_3(pt.p1.x, pt.p1.y, pt.p2.x, pt.p2.y, this.c);
        double error = UtilPoint2D_F64.distanceSq(this.c.x / this.c.z, this.c.y / this.c.z, pt.p3.x, pt.p3.y);
        this.transfer.transfer_1_to_2(pt.p1.x, pt.p1.y, pt.p3.x, pt.p3.y, this.c);
        return error += UtilPoint2D_F64.distanceSq(this.c.x / this.c.z, this.c.y / this.c.z, pt.p2.x, pt.p2.y);
    }

    @Override
    public void distances(List<AssociatedTriple> list, double[] distance) {
        for (int i = 0; i < list.size(); ++i) {
            distance[i] = this.distance(list.get(i));
        }
    }

    @Override
    public Class<AssociatedTriple> getPointType() {
        return AssociatedTriple.class;
    }

    @Override
    public Class<TrifocalTensor> getModelType() {
        return TrifocalTensor.class;
    }
}

