/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.struct.geo.AssociatedPair;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.affine.AffinePointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceAffine2DSq
implements DistanceFromModel<Affine2D_F64, AssociatedPair> {
    Affine2D_F64 model;
    Point2D_F64 expected = new Point2D_F64();

    @Override
    public void setModel(Affine2D_F64 model) {
        this.model = model;
    }

    @Override
    public double distance(AssociatedPair pt) {
        AffinePointOps_F64.transform(this.model, pt.p1, this.expected);
        return this.expected.distance2(pt.p2);
    }

    @Override
    public void distances(List<AssociatedPair> points, double[] distance) {
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            AffinePointOps_F64.transform(this.model, p.p1, this.expected);
            distance[i] = this.expected.distance2(p.p2);
        }
    }

    @Override
    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    @Override
    public Class<Affine2D_F64> getModelType() {
        return Affine2D_F64.class;
    }
}

