/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PairLineNorm;
import georegression.geometry.GeometryMath_F64;
import java.util.Arrays;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class AdjustHomographyMatrix {
    protected SingularValueDecomposition_F64<DMatrixRMaj> svd = new SafeSvd_DDRM(DecompositionFactory_DDRM.svd(0, 0, true, true, false));
    DMatrixRMaj H_t = new DMatrixRMaj(3, 3);

    public boolean adjust(DMatrixRMaj H, AssociatedPair p) {
        if (!this.findScaleH(H)) {
            return false;
        }
        this.adjustHomographSign(p, H);
        return true;
    }

    public boolean adjust(DMatrixRMaj H, PairLineNorm p) {
        if (!this.findScaleH(H)) {
            return false;
        }
        this.adjustHomographSign(p, H);
        return true;
    }

    protected boolean findScaleH(DMatrixRMaj H) {
        if (!this.svd.decompose(H)) {
            return false;
        }
        Arrays.sort(this.svd.getSingularValues(), 0, 3);
        double scale = this.svd.getSingularValues()[1];
        CommonOps_DDRM.divide(H, scale);
        return true;
    }

    protected void adjustHomographSign(AssociatedPair p, DMatrixRMaj H) {
        double val2 = GeometryMath_F64.innerProd(p.p2, H, p.p1);
        if (val2 < 0.0) {
            CommonOps_DDRM.scale(-1.0, H);
        }
    }

    protected void adjustHomographSign(PairLineNorm p, DMatrixRMaj H) {
        CommonOps_DDRM.transpose(H, this.H_t);
        double val2 = GeometryMath_F64.innerProd(p.l1, this.H_t, p.l2);
        if (val2 < 0.0) {
            CommonOps_DDRM.scale(-1.0, H);
        }
    }
}

