/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3Rodrigues;

public class CodecSceneStructureMetric
implements BundleAdjustmentSchur.Codec<SceneStructureMetric> {
    public JacobianSo3 rotation = new JacobianSo3Rodrigues();

    public CodecSceneStructureMetric() {
    }

    public CodecSceneStructureMetric(JacobianSo3 rotation) {
        this.rotation = rotation;
    }

    @Override
    public void decode(double[] input, SceneStructureMetric structure) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            p.coordinate[0] = input[index++];
            p.coordinate[1] = input[index++];
            p.coordinate[2] = input[index++];
            if (!structure.isHomogenous()) continue;
            p.coordinate[3] = input[index++];
        }
        for (int rigidIndex = 0; rigidIndex < structure.rigids.size; ++rigidIndex) {
            SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])structure.rigids.data)[rigidIndex];
            if (rigid.known) continue;
            this.rotation.setParameters(input, index);
            rigid.object_to_world.R.set(this.rotation.getRotationMatrix());
            index += this.rotation.getParameterLength();
            rigid.object_to_world.T.x = input[index++];
            rigid.object_to_world.T.y = input[index++];
            rigid.object_to_world.T.z = input[index++];
        }
        for (int motionIndex = 0; motionIndex < structure.motions.size; ++motionIndex) {
            SceneStructureMetric.Motion motion = ((SceneStructureMetric.Motion[])structure.motions.data)[motionIndex];
            if (motion.known) continue;
            this.rotation.setParameters(input, index);
            motion.motion.R.set(this.rotation.getRotationMatrix());
            index += this.rotation.getParameterLength();
            motion.motion.T.x = input[index++];
            motion.motion.T.y = input[index++];
            motion.motion.T.z = input[index++];
        }
        for (i = 0; i < structure.cameras.size; ++i) {
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])structure.cameras.data)[i];
            if (camera.known) continue;
            camera.model.setIntrinsic(input, index);
            index += camera.model.getIntrinsicCount();
        }
    }

    @Override
    public void encode(SceneStructureMetric structure, double[] output) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.size; ++i) {
            SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])structure.points.data)[i];
            output[index++] = p.coordinate[0];
            output[index++] = p.coordinate[1];
            output[index++] = p.coordinate[2];
            if (!structure.isHomogenous()) continue;
            output[index++] = p.coordinate[3];
        }
        for (int rigidIndex = 0; rigidIndex < structure.rigids.size; ++rigidIndex) {
            SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])structure.rigids.data)[rigidIndex];
            if (rigid.known) continue;
            this.rotation.getParameters(rigid.object_to_world.R, output, index);
            index += this.rotation.getParameterLength();
            output[index++] = rigid.object_to_world.T.x;
            output[index++] = rigid.object_to_world.T.y;
            output[index++] = rigid.object_to_world.T.z;
        }
        for (int motionIndex = 0; motionIndex < structure.motions.size; ++motionIndex) {
            SceneStructureMetric.Motion motion = ((SceneStructureMetric.Motion[])structure.motions.data)[motionIndex];
            if (motion.known) continue;
            this.rotation.getParameters(motion.motion.R, output, index);
            index += this.rotation.getParameterLength();
            output[index++] = motion.motion.T.x;
            output[index++] = motion.motion.T.y;
            output[index++] = motion.motion.T.z;
        }
        for (i = 0; i < structure.cameras.size; ++i) {
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])structure.cameras.data)[i];
            if (camera.known) continue;
            camera.model.getIntrinsic(output, index);
            index += camera.model.getIntrinsicCount();
        }
    }
}

