/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3Rodrigues;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.ReshapeMatrix;
import org.ejml.dense.row.CommonOps_DDRM;

public abstract class BundleAdjustmentMetricSchurJacobian<M extends DMatrix>
implements BundleAdjustmentSchur.Jacobian<SceneStructureMetric, M> {
    private SceneStructureMetric structure;
    private SceneObservations observations;
    private int numMotionsUnknown;
    private int numRigidUnknown;
    private int numParameters;
    private int lengthPoint;
    public JacobianSo3 jacSO3 = new JacobianSo3Rodrigues();
    private final DogArray<Se3_F64> storageSe3 = new DogArray<Se3_F64>(Se3_F64::new);
    private final DogArray<DMatrixRMaj[]> storageSO3Jac = new DogArray<DMatrixRMaj[]>(this::declareRotJacStorage);
    private final Map<SceneStructureMetric.View, Se3_F64> mapWorldToView = new HashMap<SceneStructureMetric.View, Se3_F64>();
    private final TIntObjectMap<DMatrixRMaj[]> mapSO3Jac = new TIntObjectHashMap<DMatrixRMaj[]>();
    private final Se3_F64 world_to_view = new Se3_F64();
    private JacobianSo3[] jacRigidS03;
    private final Point3D_F64 worldPt3 = new Point3D_F64();
    private final Point4D_F64 worldPt4 = new Point4D_F64();
    private final Point3D_F64 rigidPt3 = new Point3D_F64();
    private final Point4D_F64 rigidPt4 = new Point4D_F64();
    private final Point3D_F64 cameraPt = new Point3D_F64();
    private int lengthSE3;
    private int indexFirstRigid;
    private int indexFirstMotion;
    private int indexLastMotion;
    private int[] rigidParameterIndexes;
    private int[] motionParameterIndexes;
    private int[] cameraParameterIndexes;
    private int jacRowX;
    private int jacRowY;
    private final double[] pointGradX = new double[3];
    private final double[] pointGradY = new double[3];
    private double[] calibGradX = null;
    private double[] calibGradY = null;
    DMatrixRMaj RR = new DMatrixRMaj(3, 3);
    private DMatrixRMaj[] arraySO3 = new DMatrixRMaj[0];
    private final DMatrixRMaj accumulatedR = new DMatrixRMaj(3, 3);
    private final Point4D_F64 worldX = new Point4D_F64();
    private final Point3D_F64 pt3 = new Point3D_F64();
    private final DMatrixRMaj tmp3x3 = new DMatrixRMaj(3, 3);

    @Override
    public void configure(SceneStructureMetric structure, SceneObservations observations) {
        int i;
        this.structure = structure;
        this.observations = observations;
        this.lengthPoint = !structure.isHomogenous() ? 3 : 4;
        this.lengthSE3 = 3 + this.jacSO3.getParameterLength();
        this.numRigidUnknown = structure.getUnknownRigidCount();
        this.numMotionsUnknown = structure.getUnknownMotionCount();
        int numCameraParameters = structure.getUnknownCameraParameterCount();
        this.indexFirstRigid = structure.points.size * this.lengthPoint;
        this.indexFirstMotion = this.indexFirstRigid + this.numRigidUnknown * this.lengthSE3;
        this.indexLastMotion = this.indexFirstMotion + this.numMotionsUnknown * this.lengthSE3;
        this.numParameters = this.indexLastMotion + numCameraParameters;
        this.jacRigidS03 = new JacobianSo3[structure.rigids.size];
        this.rigidParameterIndexes = new int[this.jacRigidS03.length];
        int index = 0;
        for (i = 0; i < this.jacRigidS03.length; ++i) {
            this.rigidParameterIndexes[i] = index;
            this.jacRigidS03[i] = new JacobianSo3Rodrigues();
            if (((SceneStructureMetric.Rigid)structure.rigids.get((int)i)).known) continue;
            index += this.lengthSE3;
        }
        this.motionParameterIndexes = new int[structure.motions.size];
        index = 0;
        for (i = 0; i < structure.motions.size; ++i) {
            this.motionParameterIndexes[i] = index;
            if (((SceneStructureMetric.Motion[])structure.motions.data)[i].known) continue;
            index += this.lengthSE3;
        }
        this.cameraParameterIndexes = new int[structure.cameras.size];
        int largestCameraSize = 0;
        int index2 = 0;
        for (int i2 = 0; i2 < structure.cameras.size; ++i2) {
            if (((SceneStructureCommon.Camera)structure.cameras.get((int)i2)).known) continue;
            this.cameraParameterIndexes[i2] = index2;
            int count = ((SceneStructureCommon.Camera[])structure.cameras.data)[i2].model.getIntrinsicCount();
            largestCameraSize = Math.max(largestCameraSize, count);
            index2 += count;
        }
        this.calibGradX = new double[largestCameraSize];
        this.calibGradY = new double[largestCameraSize];
        this.declareStorageWorldToView(structure);
        this.declareStoragePartialsSE3(structure);
    }

    private void declareStorageWorldToView(SceneStructureMetric structure) {
        this.mapWorldToView.clear();
        this.storageSe3.reset();
        for (int viewIdx = 0; viewIdx < structure.views.size; ++viewIdx) {
            SceneStructureMetric.View v = (SceneStructureMetric.View)structure.views.get(viewIdx);
            if (v.parent == null) continue;
            Se3_F64 world_to_view = this.storageSe3.grow();
            this.mapWorldToView.put(v, world_to_view);
        }
    }

    private void declareStoragePartialsSE3(SceneStructureMetric structure) {
        int lengthParam = this.storageSO3Jac.grow().length;
        this.mapSO3Jac.clear();
        if (this.jacSO3.getParameterLength() != lengthParam) {
            this.storageSO3Jac.data = new DMatrixRMaj[0][];
            this.storageSO3Jac.size = 0;
        } else {
            this.storageSO3Jac.reset();
        }
        this.arraySO3 = this.arraySO3.length != lengthParam ? new DMatrixRMaj[lengthParam] : this.arraySO3;
        for (int viewIdx = 0; viewIdx < structure.views.size; ++viewIdx) {
            SceneStructureMetric.View v = (SceneStructureMetric.View)structure.views.get(viewIdx);
            if (v.parent == null) continue;
            SceneStructureMetric.View vp = v.parent;
            SceneStructureMetric.Motion mp = (SceneStructureMetric.Motion)structure.motions.get(vp.parent_to_view);
            if (mp.known || this.mapSO3Jac.containsKey(vp.parent_to_view)) continue;
            this.mapSO3Jac.put(vp.parent_to_view, this.storageSO3Jac.grow());
        }
    }

    @Override
    public int getNumOfInputsN() {
        return this.numParameters;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.observations.getObservationCount() * 2;
    }

    private int computeGeneralPoints(DMatrix leftPoint, DMatrix rightView, double[] input, int observationIndex, int viewIndex, SceneStructureCommon.Camera camera, int cameraParamStartIndex) {
        SceneObservations.View obsView = (SceneObservations.View)this.observations.views.get(viewIndex);
        SceneStructureMetric.View strView = (SceneStructureMetric.View)this.structure.views.get(viewIndex);
        for (int i = 0; i < obsView.size(); ++i) {
            int featureIndex = obsView.point.get(i);
            int columnOfPointInJac = featureIndex * this.lengthPoint;
            if (this.structure.isHomogenous()) {
                this.worldPt4.x = input[columnOfPointInJac];
                this.worldPt4.y = input[columnOfPointInJac + 1];
                this.worldPt4.z = input[columnOfPointInJac + 2];
                this.worldPt4.w = input[columnOfPointInJac + 3];
                SePointOps_F64.transformV(this.world_to_view, this.worldPt4, this.cameraPt);
            } else {
                this.worldPt3.x = input[columnOfPointInJac];
                this.worldPt3.y = input[columnOfPointInJac + 1];
                this.worldPt3.z = input[columnOfPointInJac + 2];
                SePointOps_F64.transform(this.world_to_view, this.worldPt3, this.cameraPt);
            }
            this.jacRowX = observationIndex * 2;
            this.jacRowY = this.jacRowX + 1;
            if (!camera.known) {
                int N = camera.model.getIntrinsicCount();
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, true, this.calibGradX, this.calibGradY);
                int location = this.indexLastMotion - this.indexFirstMotion + cameraParamStartIndex;
                for (int j = 0; j < N; ++j) {
                    this.set(rightView, this.jacRowX, location + j, this.calibGradX[j]);
                    this.set(rightView, this.jacRowY, location + j, this.calibGradY[j]);
                }
            } else {
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, false, null, null);
            }
            if (this.structure.isHomogenous()) {
                this.partialPointH(leftPoint, rightView, strView, columnOfPointInJac);
            } else {
                this.partialPoint3(leftPoint, rightView, strView, columnOfPointInJac);
            }
            ++observationIndex;
        }
        return observationIndex;
    }

    public void internalProcess(double[] input, DMatrix leftPoint, DMatrix rightView) {
        int numRows = this.getNumOfOutputsM();
        int numPointParam = this.structure.points.size * this.lengthPoint + this.numRigidUnknown * this.lengthSE3;
        int numViewParam = this.numParameters - numPointParam;
        ((ReshapeMatrix)((Object)leftPoint)).reshape(numRows, numPointParam);
        ((ReshapeMatrix)((Object)rightView)).reshape(numRows, numViewParam);
        leftPoint.zero();
        rightView.zero();
        for (int rigidIndex = 0; rigidIndex < this.structure.rigids.size; ++rigidIndex) {
            if (((SceneStructureMetric.Rigid)this.structure.rigids.get((int)rigidIndex)).known) continue;
            this.jacRigidS03[rigidIndex].setParameters(input, this.indexFirstRigid + this.rigidParameterIndexes[rigidIndex]);
        }
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            SceneStructureMetric.View view = ((SceneStructureMetric.View[])this.structure.views.data)[viewIndex];
            SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])this.structure.cameras.data)[view.camera];
            SceneStructureMetric.Motion motion = ((SceneStructureMetric.Motion[])this.structure.motions.data)[view.parent_to_view];
            if (!motion.known) {
                int paramIndex = this.motionParameterIndexes[view.parent_to_view] + this.indexFirstMotion;
                this.jacSO3.setParameters(input, paramIndex);
                motion.motion.T.x = input[paramIndex += this.jacSO3.getParameterLength()];
                motion.motion.T.y = input[paramIndex + 1];
                motion.motion.T.z = input[paramIndex + 2];
                motion.motion.getR().set(this.jacSO3.getRotationMatrix());
                DMatrixRMaj[] savedJac = this.mapSO3Jac.get(view.parent_to_view);
                if (savedJac != null) {
                    for (int i = 0; i < savedJac.length; ++i) {
                        savedJac[i].set(this.jacSO3.getPartial(i));
                    }
                }
            }
            this.lookupWorldToView(view, this.world_to_view);
            int cameraParamStartIndex = this.cameraParameterIndexes[view.camera];
            if (!camera.known) {
                camera.model.setIntrinsic(input, this.indexLastMotion + cameraParamStartIndex);
            }
            observationIndex = this.computeGeneralPoints(leftPoint, rightView, input, observationIndex, viewIndex, camera, cameraParamStartIndex);
            if (!this.observations.hasRigid()) continue;
            observationIndex = this.computeRigidPoints(leftPoint, rightView, observationIndex, viewIndex, camera, cameraParamStartIndex);
        }
    }

    private int computeRigidPoints(DMatrix leftPoint, DMatrix rightView, int observationIndex, int viewIndex, SceneStructureCommon.Camera camera, int cameraParamStartIndex) {
        SceneObservations.View obsView = (SceneObservations.View)this.observations.viewsRigid.get(viewIndex);
        SceneStructureMetric.View view = ((SceneStructureMetric.View[])this.structure.views.data)[viewIndex];
        for (int i = 0; i < obsView.size(); ++i) {
            int featureIndex = obsView.point.get(i);
            int rigidIndex = this.structure.lookupRigid[featureIndex];
            SceneStructureMetric.Rigid rigid = (SceneStructureMetric.Rigid)this.structure.rigids.get(rigidIndex);
            int pointIndex = featureIndex - rigid.indexFirst;
            if (this.structure.isHomogenous()) {
                rigid.getPoint(pointIndex, this.rigidPt4);
                SePointOps_F64.transformV(rigid.object_to_world, this.rigidPt4, this.worldPt3);
            } else {
                rigid.getPoint(pointIndex, this.rigidPt3);
                SePointOps_F64.transform(rigid.object_to_world, this.rigidPt3, this.worldPt3);
            }
            SePointOps_F64.transform(this.world_to_view, this.worldPt3, this.cameraPt);
            this.jacRowX = observationIndex * 2;
            this.jacRowY = this.jacRowX + 1;
            if (!camera.known) {
                int N = camera.model.getIntrinsicCount();
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, true, this.calibGradX, this.calibGradY);
                int location = this.indexLastMotion - this.indexFirstMotion + cameraParamStartIndex;
                for (int j = 0; j < N; ++j) {
                    this.set(rightView, this.jacRowX, location + j, this.calibGradX[j]);
                    this.set(rightView, this.jacRowY, location + j, this.calibGradY[j]);
                }
            } else {
                camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, false, null, null);
            }
            this.partialViewSE3(rightView, view, this.worldPt3.x, this.worldPt3.y, this.worldPt3.z, 1.0);
            if (!rigid.known) {
                if (this.structure.isHomogenous()) {
                    this.partialRigidSE3(leftPoint, rigidIndex, this.rigidPt4.x, this.rigidPt4.y, this.rigidPt4.z, this.rigidPt4.w);
                } else {
                    this.partialRigidSE3(leftPoint, rigidIndex, this.rigidPt3.x, this.rigidPt3.y, this.rigidPt3.z, 1.0);
                }
            }
            ++observationIndex;
        }
        return observationIndex;
    }

    private void partialPoint3(DMatrix leftPoint, DMatrix rightView, SceneStructureMetric.View view, int columnOfPointInJac) {
        this.addToJacobian(leftPoint, columnOfPointInJac, this.pointGradX, this.pointGradY, this.world_to_view.R);
        this.partialViewSE3(rightView, view, this.worldPt3.x, this.worldPt3.y, this.worldPt3.z, 1.0);
    }

    private void partialPointH(DMatrix leftPoint, DMatrix rightView, SceneStructureMetric.View view, int columnOfPointInJac) {
        this.addToJacobian(leftPoint, columnOfPointInJac, this.pointGradX, this.pointGradY, this.world_to_view.R);
        this.addToJacobian(leftPoint, columnOfPointInJac + 3, this.pointGradX, this.pointGradY, this.world_to_view.T);
        this.partialViewSE3(rightView, view, this.worldPt4.x, this.worldPt4.y, this.worldPt4.z, this.worldPt4.w);
    }

    private void partialViewSE3(DMatrix rightView, SceneStructureMetric.View view, double X2, double Y2, double Z2, double W) {
        SceneStructureMetric.Motion motion = (SceneStructureMetric.Motion)this.structure.motions.get(view.parent_to_view);
        if (motion.known && view.parent == null) {
            return;
        }
        boolean firstView = true;
        this.worldX.setTo(X2, Y2, Z2, W);
        CommonOps_DDRM.setIdentity(this.accumulatedR);
        while (true) {
            int i;
            DMatrixRMaj[] jacobianSO3;
            SceneStructureMetric.Motion motion2 = (SceneStructureMetric.Motion)this.structure.motions.get(view.parent_to_view);
            int col = this.motionParameterIndexes[view.parent_to_view];
            if (motion2.known) {
                view = view.parent;
                if (view == null) break;
                CommonOps_DDRM.mult(this.accumulatedR, motion2.motion.R, this.tmp3x3);
                this.accumulatedR.set(this.tmp3x3);
                continue;
            }
            if (firstView) {
                firstView = false;
                for (int i2 = 0; i2 < this.arraySO3.length; ++i2) {
                    this.arraySO3[i2] = this.jacSO3.getPartial(i2);
                }
                jacobianSO3 = this.arraySO3;
            } else {
                jacobianSO3 = this.mapSO3Jac.get(view.parent_to_view);
            }
            int paramLength = this.jacSO3.getParameterLength();
            if (view.parent == null) {
                for (i = 0; i < paramLength; ++i) {
                    CommonOps_DDRM.mult(this.accumulatedR, jacobianSO3[i], this.tmp3x3);
                    this.addToJacobian(rightView, col + i, this.pointGradX, this.pointGradY, this.tmp3x3, X2, Y2, Z2);
                }
            } else {
                Se3_F64 world_to_parent = this.getWorldToView(view.parent);
                for (int i3 = 0; i3 < paramLength; ++i3) {
                    SePointOps_F64.transformV(world_to_parent, this.worldX, this.pt3);
                    CommonOps_DDRM.mult(this.accumulatedR, jacobianSO3[i3], this.tmp3x3);
                    this.addToJacobian(rightView, col + i3, this.pointGradX, this.pointGradY, this.tmp3x3, this.pt3.x, this.pt3.y, this.pt3.z);
                }
            }
            for (i = 0; i < 3; ++i) {
                double sumX = 0.0;
                double sumY = 0.0;
                for (int j = 0; j < 3; ++j) {
                    double r_ji = this.accumulatedR.unsafe_get(j, i);
                    sumX += r_ji * this.pointGradX[j];
                    sumY += r_ji * this.pointGradY[j];
                }
                this.add(rightView, this.jacRowX, col + paramLength + i, sumX * W);
                this.add(rightView, this.jacRowY, col + paramLength + i, sumY * W);
            }
            view = view.parent;
            if (view == null) break;
            CommonOps_DDRM.mult(this.accumulatedR, motion2.motion.R, this.tmp3x3);
            this.accumulatedR.set(this.tmp3x3);
        }
    }

    private Se3_F64 getWorldToView(SceneStructureMetric.View view) {
        Se3_F64 world_to_view = view.parent != null ? this.mapWorldToView.get(view) : ((SceneStructureMetric.Motion)this.structure.motions.get((int)view.parent_to_view)).motion;
        return world_to_view;
    }

    private void partialRigidSE3(DMatrix leftPoint, int rigidIndex, double X2, double Y2, double Z2, double W) {
        int col = this.rigidParameterIndexes[rigidIndex] + this.indexFirstRigid;
        JacobianSo3 jac = this.jacRigidS03[rigidIndex];
        int N = jac.getParameterLength();
        for (int i = 0; i < N; ++i) {
            CommonOps_DDRM.mult(this.world_to_view.R, jac.getPartial(i), this.RR);
            this.addToJacobian(leftPoint, col + i, this.pointGradX, this.pointGradY, this.RR, X2, Y2, Z2);
        }
        double RX0 = this.world_to_view.R.data[0] * this.pointGradX[0] + this.world_to_view.R.data[3] * this.pointGradX[1] + this.world_to_view.R.data[6] * this.pointGradX[2];
        double RX1 = this.world_to_view.R.data[1] * this.pointGradX[0] + this.world_to_view.R.data[4] * this.pointGradX[1] + this.world_to_view.R.data[7] * this.pointGradX[2];
        double RX2 = this.world_to_view.R.data[2] * this.pointGradX[0] + this.world_to_view.R.data[5] * this.pointGradX[1] + this.world_to_view.R.data[8] * this.pointGradX[2];
        double RY0 = this.world_to_view.R.data[0] * this.pointGradY[0] + this.world_to_view.R.data[3] * this.pointGradY[1] + this.world_to_view.R.data[6] * this.pointGradY[2];
        double RY1 = this.world_to_view.R.data[1] * this.pointGradY[0] + this.world_to_view.R.data[4] * this.pointGradY[1] + this.world_to_view.R.data[7] * this.pointGradY[2];
        double RY2 = this.world_to_view.R.data[2] * this.pointGradY[0] + this.world_to_view.R.data[5] * this.pointGradY[1] + this.world_to_view.R.data[8] * this.pointGradY[2];
        this.set(leftPoint, this.jacRowX, col + N, RX0 * W);
        this.set(leftPoint, this.jacRowY, col + N, RY0 * W);
        this.set(leftPoint, this.jacRowX, col + N + 1, RX1 * W);
        this.set(leftPoint, this.jacRowY, col + N + 1, RY1 * W);
        this.set(leftPoint, this.jacRowX, col + N + 2, RX2 * W);
        this.set(leftPoint, this.jacRowY, col + N + 2, RY2 * W);
    }

    private void addToJacobian(DMatrix matrix, int col, double[] a, double[] b, DMatrixRMaj R) {
        this.set(matrix, this.jacRowX, col + 0, a[0] * R.data[0] + a[1] * R.data[3] + a[2] * R.data[6]);
        this.set(matrix, this.jacRowX, col + 1, a[0] * R.data[1] + a[1] * R.data[4] + a[2] * R.data[7]);
        this.set(matrix, this.jacRowX, col + 2, a[0] * R.data[2] + a[1] * R.data[5] + a[2] * R.data[8]);
        this.set(matrix, this.jacRowY, col + 0, b[0] * R.data[0] + b[1] * R.data[3] + b[2] * R.data[6]);
        this.set(matrix, this.jacRowY, col + 1, b[0] * R.data[1] + b[1] * R.data[4] + b[2] * R.data[7]);
        this.set(matrix, this.jacRowY, col + 2, b[0] * R.data[2] + b[1] * R.data[5] + b[2] * R.data[8]);
    }

    private void addToJacobian(DMatrix matrix, int col, double[] a, double[] b, DMatrixRMaj R, double X2, double Y2, double Z2) {
        double x = R.data[0] * X2 + R.data[1] * Y2 + R.data[2] * Z2;
        double y = R.data[3] * X2 + R.data[4] * Y2 + R.data[5] * Z2;
        double z = R.data[6] * X2 + R.data[7] * Y2 + R.data[8] * Z2;
        this.add(matrix, this.jacRowX, col, a[0] * x + a[1] * y + a[2] * z);
        this.add(matrix, this.jacRowY, col, b[0] * x + b[1] * y + b[2] * z);
    }

    private void addToJacobian(DMatrix matrix, int col, double[] a, double[] b, Vector3D_F64 X2) {
        this.set(matrix, this.jacRowX, col, a[0] * X2.x + a[1] * X2.y + a[2] * X2.z);
        this.set(matrix, this.jacRowY, col, b[0] * X2.x + b[1] * X2.y + b[2] * X2.z);
    }

    protected abstract void set(DMatrix var1, int var2, int var3, double var4);

    protected abstract void add(DMatrix var1, int var2, int var3, double var4);

    protected void lookupWorldToView(SceneStructureMetric.View v, Se3_F64 world_to_view) {
        Se3_F64 parent_to_view = this.structure.getParentToView(v);
        if (v.parent == null) {
            world_to_view.setTo(parent_to_view);
            return;
        }
        Se3_F64 saved_world_to_view = this.mapWorldToView.get(v);
        SceneStructureMetric.View parentView = v.parent;
        if (parentView.parent == null) {
            Se3_F64 world_to_parent = this.structure.getParentToView(v.parent);
            world_to_parent.concat(parent_to_view, saved_world_to_view);
        } else {
            Se3_F64 world_to_parent = this.mapWorldToView.get(v.parent);
            world_to_parent.concat(parent_to_view, saved_world_to_view);
        }
        world_to_view.setTo(saved_world_to_view);
    }

    private DMatrixRMaj[] declareRotJacStorage() {
        DMatrixRMaj[] partials = new DMatrixRMaj[this.jacSO3.getParameterLength()];
        for (int i = 0; i < partials.length; ++i) {
            partials[i] = new DMatrixRMaj(3, 3);
        }
        return partials;
    }

    public JacobianSo3 getJacSO3() {
        return this.jacSO3;
    }

    public void setJacSO3(JacobianSo3 jacSO3) {
        this.jacSO3 = jacSO3;
    }
}

