/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.stat;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.convolve.GConvolveImageOps;
import boofcv.alg.misc.GImageStatistics;
import boofcv.alg.misc.GPixelMath;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.image.GrayF;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import pabeles.concurrency.GrowArray;

public class ImageLocalNormalization<T extends GrayF<T>> {
    protected T adjusted;
    protected T localMean;
    protected T pow2;
    protected T localPow2;
    protected Class<T> imageType;
    ImageBorder<T> border;

    public ImageLocalNormalization(Class<T> imageType, BorderType borderType) {
        this.imageType = imageType;
        if (borderType != BorderType.NORMALIZED) {
            this.border = FactoryImageBorder.generic(borderType, ImageType.single(imageType));
        }
        this.adjusted = (GrayF)GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.localMean = (GrayF)GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.pow2 = (GrayF)GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.localPow2 = (GrayF)GeneralizedImageOps.createSingleBand(imageType, 1, 1);
    }

    public void zeroMeanStdOne(Kernel1D kernel, T input, double maxPixelValue, double delta, T output) {
        this.initialize(input, output);
        T adjusted = this.ensureMaxValueOfOne(input, maxPixelValue);
        if (this.border == null) {
            GConvolveImageOps.horizontalNormalized(kernel, adjusted, output);
            GConvolveImageOps.verticalNormalized(kernel, output, this.localMean);
            GPixelMath.pow2(adjusted, this.pow2);
            GConvolveImageOps.horizontalNormalized(kernel, this.pow2, output);
            GConvolveImageOps.verticalNormalized(kernel, output, this.localPow2);
        } else {
            GConvolveImageOps.horizontal(kernel, adjusted, output, this.border);
            GConvolveImageOps.vertical(kernel, output, this.localMean, this.border);
            GPixelMath.pow2(adjusted, this.pow2);
            GConvolveImageOps.horizontal(kernel, this.pow2, output, this.border);
            GConvolveImageOps.vertical(kernel, output, this.localPow2, this.border);
        }
        if (this.imageType == GrayF32.class) {
            this.computeOutput((GrayF32)input, (float)delta, (GrayF32)output, (GrayF32)adjusted);
        } else {
            this.computeOutput((GrayF64)input, delta, (GrayF64)output, (GrayF64)adjusted);
        }
    }

    public void zeroMeanStdOne(int radius, T input, double maxPixelValue, double delta, T output) {
        this.initialize(input, output);
        T adjusted = this.ensureMaxValueOfOne(input, maxPixelValue);
        if (this.border != null) {
            throw new IllegalArgumentException("Only renormalize border supported here so far.  This can be changed...");
        }
        GrowArray work = GeneralizedImageOps.createGrowArray(((ImageBase)input).getImageType());
        GBlurImageOps.mean(adjusted, this.localMean, radius, output, work);
        GPixelMath.pow2(adjusted, this.pow2);
        GBlurImageOps.mean(this.pow2, this.localPow2, radius, output, work);
        if (this.imageType == GrayF32.class) {
            this.computeOutput((GrayF32)input, (float)delta, (GrayF32)output, (GrayF32)adjusted);
        } else {
            this.computeOutput((GrayF64)input, delta, (GrayF64)output, (GrayF64)adjusted);
        }
    }

    private void initialize(T input, T output) {
        InputSanityCheck.checkSameShape(input, output);
        ((ImageGray)this.adjusted).reshape(((GrayF)input).width, ((GrayF)input).height);
        ((ImageGray)this.localMean).reshape(((GrayF)input).width, ((GrayF)input).height);
        ((ImageGray)this.pow2).reshape(((GrayF)input).width, ((GrayF)input).height);
        ((ImageGray)this.localPow2).reshape(((GrayF)input).width, ((GrayF)input).height);
    }

    private void computeOutput(GrayF32 input, float delta, GrayF32 output, GrayF32 adjusted) {
        GrayF32 localMean = (GrayF32)this.localMean;
        GrayF32 localPow2 = (GrayF32)this.localPow2;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexEnd = indexIn + input.width;
            int indexOut = output.startIndex + y * output.stride;
            for (indexIn = y * input.width; indexIn < indexEnd; ++indexIn) {
                float ave = localMean.data[indexIn];
                float std = (float)Math.sqrt(localPow2.data[indexIn] - ave * ave + delta);
                output.data[indexOut++] = (adjusted.data[indexIn] - ave) / std;
            }
        }
    }

    private void computeOutput(GrayF64 input, double delta, GrayF64 output, GrayF64 adjusted) {
        GrayF64 localMean = (GrayF64)this.localMean;
        GrayF64 localPow2 = (GrayF64)this.localPow2;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexEnd = indexIn + input.width;
            int indexOut = output.startIndex + y * output.stride;
            for (indexIn = y * input.width; indexIn < indexEnd; ++indexIn) {
                double ave = localMean.data[indexIn];
                double std = Math.sqrt(localPow2.data[indexIn] - ave * ave + delta);
                output.data[indexOut++] = (adjusted.data[indexIn] - ave) / std;
            }
        }
    }

    private T ensureMaxValueOfOne(T input, double maxPixelValue) {
        T adjusted;
        if (maxPixelValue < 0.0) {
            maxPixelValue = GImageStatistics.max(input);
        }
        if (maxPixelValue != 1.0) {
            adjusted = this.adjusted;
            GPixelMath.divide(input, maxPixelValue, adjusted);
        } else {
            adjusted = input;
        }
        return adjusted;
    }

    public Class<T> getImageType() {
        return this.imageType;
    }
}

