/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplAverageDownSampleN_MT {
    public static void down(GrayU8 input, int sampleWidth, GrayI8 output) {
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
            int outY = y / sampleWidth;
            int indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut++] = (byte)((total + N_half) / N);
            }
        });
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
                int outY = y / sampleWidth;
                int indexOut = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut] = (byte)((total + N_half) / N);
            });
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            BoofConcurrency.loopFor(0, maxX, sampleWidth, x -> {
                int indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut] = (byte)((total + N_half) / N);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++] & 0xFF;
                }
            }
            output.data[indexOut] = (byte)((total + N_half) / N);
        }
    }

    public static void down(GrayS8 input, int sampleWidth, GrayI8 output) {
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
            int outY = y / sampleWidth;
            int indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
            }
        });
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
                int outY = y / sampleWidth;
                int indexOut = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
            });
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            BoofConcurrency.loopFor(0, maxX, sampleWidth, x -> {
                int indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
        }
    }

    public static void down(GrayU16 input, int sampleWidth, GrayI16 output) {
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
            int outY = y / sampleWidth;
            int indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut++] = (short)((total + N_half) / N);
            }
        });
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
                int outY = y / sampleWidth;
                int indexOut = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut] = (short)((total + N_half) / N);
            });
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            BoofConcurrency.loopFor(0, maxX, sampleWidth, x -> {
                int indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut] = (short)((total + N_half) / N);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++] & 0xFFFF;
                }
            }
            output.data[indexOut] = (short)((total + N_half) / N);
        }
    }

    public static void down(GrayS16 input, int sampleWidth, GrayI16 output) {
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
            int outY = y / sampleWidth;
            int indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
            }
        });
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
                int outY = y / sampleWidth;
                int indexOut = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
            });
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            BoofConcurrency.loopFor(0, maxX, sampleWidth, x -> {
                int indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
            });
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
        }
    }

    public static void down(GrayS32 input, int sampleWidth, GrayS32 output) {
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
            int outY = y / sampleWidth;
            int indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
            }
        });
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
                int outY = y / sampleWidth;
                int indexOut = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
            });
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            BoofConcurrency.loopFor(0, maxX, sampleWidth, x -> {
                int indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
            });
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
        }
    }

    public static void down(GrayF32 input, int sampleWidth, GrayF32 output) {
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        float N = sampleWidth * sampleWidth;
        BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
            int outY = y / sampleWidth;
            int indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                float total = 0.0f;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total / N;
            }
        });
        if (maxX != input.width) {
            int N2 = sampleWidth * (input.width - maxX);
            BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
                int outY = y / sampleWidth;
                int indexOut = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                float total = 0.0f;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total / (float)N2;
            });
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            BoofConcurrency.loopFor(0, maxX, sampleWidth, x -> {
                int indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                float total = 0.0f;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total / N;
            });
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            float total = 0.0f;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total / N;
        }
    }

    public static void down(GrayF64 input, int sampleWidth, GrayF64 output) {
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        double N = sampleWidth * sampleWidth;
        BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
            int outY = y / sampleWidth;
            int indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                double total = 0.0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total / N;
            }
        });
        if (maxX != input.width) {
            int N2 = sampleWidth * (input.width - maxX);
            BoofConcurrency.loopFor(0, maxY, sampleWidth, y -> {
                int outY = y / sampleWidth;
                int indexOut = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                double total = 0.0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total / (double)N2;
            });
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            BoofConcurrency.loopFor(0, maxX, sampleWidth, x -> {
                int indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                double total = 0.0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total / N;
            });
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            int indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            double total = 0.0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total / N;
        }
    }
}

