/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.util.Arrays;

public class DetectFiducialSquareBinary<T extends ImageGray<T>>
extends BaseDetectFiducialSquare<T> {
    int[] counts;
    int[] classified;
    int[] tmp;
    private GrayU8 binaryInner = new GrayU8(1, 1);
    private GrayF32 grayNoBorder = new GrayF32();
    private int gridWidth;
    protected static final int w = 10;
    protected static final int N = 36;
    private double lengthSide = 1.0;
    double ambiguityThreshold = 0.4;

    public DetectFiducialSquareBinary(int gridWidth, double borderWidthFraction, double minimumBlackBorderFraction, InputToBinary<T> inputToBinary, DetectPolygonBinaryGrayRefine<T> quadDetector, Class<T> inputType) {
        super(inputToBinary, quadDetector, false, borderWidthFraction, minimumBlackBorderFraction, (int)Math.round((double)(10 * gridWidth) / (1.0 - borderWidthFraction * 2.0)), inputType);
        if (gridWidth < 3 || gridWidth > 8) {
            throw new IllegalArgumentException("The grid must be at least 3 and at most 8 elements wide");
        }
        this.gridWidth = gridWidth;
        this.binaryInner.reshape(10 * gridWidth, 10 * gridWidth);
        this.counts = new int[this.getTotalGridElements()];
        this.classified = new int[this.getTotalGridElements()];
        this.tmp = new int[this.getTotalGridElements()];
    }

    @Override
    protected boolean processSquare(GrayF32 gray, BaseDetectFiducialSquare.Result result, double edgeInside, double edgeOutside) {
        int off = (gray.width - this.binaryInner.width) / 2;
        gray.subimage(off, off, off + this.binaryInner.width, off + this.binaryInner.width, this.grayNoBorder);
        double threshold = (edgeInside + edgeOutside) / 2.0;
        this.findBitCounts(this.grayNoBorder, threshold);
        if (this.thresholdBinaryNumber()) {
            if (this.verbose) {
                System.out.println("  can't threshold binary, ambiguous");
            }
            return false;
        }
        if (this.rotateUntilInLowerCorner(result)) {
            if (this.verbose) {
                System.out.println("  rotate to corner failed");
            }
            return false;
        }
        result.which = this.extractNumeral();
        result.lengthSide = this.lengthSide;
        return true;
    }

    protected int extractNumeral() {
        int i;
        int val2 = 0;
        int topLeft = this.getTotalGridElements() - this.gridWidth;
        int shift = 0;
        for (i = 1; i < this.gridWidth - 1; ++i) {
            int idx = topLeft + i;
            val2 |= this.classified[idx] << shift;
            ++shift;
        }
        for (int ii = 1; ii < this.gridWidth - 1; ++ii) {
            for (int i2 = 0; i2 < this.gridWidth; ++i2) {
                int idx = this.getTotalGridElements() - this.gridWidth * (ii + 1) + i2;
                val2 |= this.classified[idx] << shift;
                ++shift;
            }
        }
        for (i = 1; i < this.gridWidth - 1; ++i) {
            val2 |= this.classified[i] << shift;
            ++shift;
        }
        return val2;
    }

    private boolean rotateUntilInLowerCorner(BaseDetectFiducialSquare.Result result) {
        int topLeft = this.getTotalGridElements() - this.gridWidth;
        int topRight = this.getTotalGridElements() - 1;
        boolean bottomLeft = false;
        int bottomRight = this.gridWidth - 1;
        if (this.classified[0] + this.classified[bottomRight] + this.classified[topRight] + this.classified[topLeft] != 1) {
            return true;
        }
        result.rotation = 0;
        while (this.classified[topLeft] != 1) {
            ++result.rotation;
            this.rotateClockWise();
        }
        return false;
    }

    protected void rotateClockWise() {
        int totalElements = this.getTotalGridElements();
        for (int ii = 0; ii < this.gridWidth; ++ii) {
            for (int i = 0; i < this.gridWidth; ++i) {
                int fromIdx = ii * this.gridWidth + i;
                int toIdx = totalElements - this.gridWidth * (i + 1) + ii;
                this.tmp[fromIdx] = this.classified[toIdx];
            }
        }
        System.arraycopy(this.tmp, 0, this.classified, 0, totalElements);
    }

    protected boolean thresholdBinaryNumber() {
        int lower = (int)(36.0 * (this.ambiguityThreshold / 2.0));
        int upper = (int)(36.0 * (1.0 - this.ambiguityThreshold / 2.0));
        int totalElements = this.getTotalGridElements();
        for (int i = 0; i < totalElements; ++i) {
            if (this.counts[i] < lower) {
                this.classified[i] = 0;
                continue;
            }
            if (this.counts[i] > upper) {
                this.classified[i] = 1;
                continue;
            }
            return true;
        }
        return false;
    }

    protected void findBitCounts(GrayF32 gray, double threshold) {
        ThresholdImageOps.threshold(gray, this.binaryInner, (float)threshold, true);
        Arrays.fill(this.counts, 0);
        for (int row = 0; row < this.gridWidth; ++row) {
            int y0 = row * this.binaryInner.width / this.gridWidth + 2;
            int y1 = (row + 1) * this.binaryInner.width / this.gridWidth - 2;
            for (int col = 0; col < this.gridWidth; ++col) {
                int x0 = col * this.binaryInner.width / this.gridWidth + 2;
                int x1 = (col + 1) * this.binaryInner.width / this.gridWidth - 2;
                int total = 0;
                for (int i = y0; i < y1; ++i) {
                    int index = i * this.binaryInner.width + x0;
                    for (int j = x0; j < x1; ++j) {
                        total += this.binaryInner.data[index++];
                    }
                }
                this.counts[row * this.gridWidth + col] = total;
            }
        }
    }

    public void setLengthSide(double lengthSide) {
        this.lengthSide = lengthSide;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setAmbiguityThreshold(double ambiguityThreshold) {
        if (ambiguityThreshold < 0.0 || ambiguityThreshold > 1.0) {
            throw new IllegalArgumentException("Must be from 0 to 1, inclusive");
        }
        this.ambiguityThreshold = ambiguityThreshold;
    }

    private int getTotalGridElements() {
        return this.gridWidth * this.gridWidth;
    }

    public long getNumberOfDistinctFiducials() {
        return (long)Math.pow(2.0, this.gridWidth * this.gridWidth - 4);
    }

    public GrayF32 getGrayNoBorder() {
        return this.grayNoBorder;
    }

    public GrayU8 getBinaryInner() {
        return this.binaryInner;
    }

    public void printClassified() {
        System.out.println();
        System.out.println("      ");
        for (int row = 0; row < this.gridWidth; ++row) {
            System.out.print(" ");
            for (int col = 0; col < this.gridWidth; ++col) {
                System.out.print(this.classified[row * this.gridWidth + col] == 1 ? " " : "X");
            }
            System.out.print(" ");
            System.out.println();
        }
        System.out.println("      ");
    }
}

