/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.QrCodeCodeWordLocations;
import boofcv.alg.fiducial.qrcode.QrCodeMaskPattern;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;

public class QrCode
implements Cloneable {
    public static final int MAX_VERSION = 40;
    public static final int VERSION_ENCODED_AT = 7;
    public static final VersionInfo[] VERSION_INFO = new VersionInfo[41];
    public static final List<Point2D_I32>[] LOCATION_BITS = new ArrayList[41];
    public Polygon2D_F64 ppRight = new Polygon2D_F64(4);
    public Polygon2D_F64 ppCorner = new Polygon2D_F64(4);
    public Polygon2D_F64 ppDown = new Polygon2D_F64(4);
    public double threshRight;
    public double threshCorner;
    public double threshDown;
    public int version;
    public ErrorLevel error;
    public QrCodeMaskPattern mask = null;
    public DogArray<Alignment> alignment = new DogArray<Alignment>(Alignment::new);
    public Mode mode = Mode.UNKNOWN;
    public byte[] rawbits = null;
    public byte[] corrected = null;
    public String message = null;
    public Failure failureCause = null;
    public Polygon2D_F64 bounds = new Polygon2D_F64(4);
    public Homography2D_F64 Hinv = new Homography2D_F64();

    public QrCode() {
        this.reset();
    }

    public int getNumberOfModules() {
        return QrCode.totalModules(this.version);
    }

    public int getNumberOfDataBytes() {
        return VERSION_INFO[this.version].totalDataBytes(this.error);
    }

    public static int totalModules(int version) {
        return version * 4 + 17;
    }

    public void reset() {
        for (int i = 0; i < 4; ++i) {
            this.ppCorner.get(i).setTo(0.0, 0.0);
            this.ppDown.get(i).setTo(0.0, 0.0);
            this.ppRight.get(i).setTo(0.0, 0.0);
        }
        this.threshCorner = 0.0;
        this.threshDown = 0.0;
        this.threshRight = 0.0;
        this.version = -1;
        this.error = ErrorLevel.L;
        this.mask = QrCodeMaskPattern.M111;
        this.alignment.reset();
        this.mode = Mode.UNKNOWN;
        this.failureCause = Failure.NONE;
        this.rawbits = null;
        this.corrected = null;
        this.message = null;
    }

    public QrCode clone() {
        QrCode c = new QrCode();
        c.set(this);
        return c;
    }

    public void set(QrCode o) {
        this.version = o.version;
        this.error = o.error;
        this.mask = o.mask;
        this.mode = o.mode;
        this.rawbits = o.rawbits == null ? null : (byte[])o.rawbits.clone();
        this.corrected = o.corrected == null ? null : (byte[])o.corrected.clone();
        this.message = o.message;
        this.threshCorner = o.threshCorner;
        this.threshDown = o.threshDown;
        this.threshRight = o.threshRight;
        this.ppCorner.setTo(o.ppCorner);
        this.ppDown.setTo(o.ppDown);
        this.ppRight.setTo(o.ppRight);
        this.failureCause = o.failureCause;
        this.bounds.setTo(o.bounds);
        this.alignment.reset();
        for (int i = 0; i < o.alignment.size; ++i) {
            this.alignment.grow().set((Alignment)o.alignment.get(i));
        }
        this.Hinv.set(o.Hinv);
    }

    static {
        QrCode.VERSION_INFO[1] = new VersionInfo(26, new int[0]);
        VERSION_INFO[1].add(ErrorLevel.L, 26, 19, 1);
        VERSION_INFO[1].add(ErrorLevel.M, 26, 16, 1);
        VERSION_INFO[1].add(ErrorLevel.Q, 26, 13, 1);
        VERSION_INFO[1].add(ErrorLevel.H, 26, 9, 1);
        QrCode.VERSION_INFO[2] = new VersionInfo(44, new int[]{6, 18});
        VERSION_INFO[2].add(ErrorLevel.L, 44, 34, 1);
        VERSION_INFO[2].add(ErrorLevel.M, 44, 28, 1);
        VERSION_INFO[2].add(ErrorLevel.Q, 44, 22, 1);
        VERSION_INFO[2].add(ErrorLevel.H, 44, 16, 1);
        QrCode.VERSION_INFO[3] = new VersionInfo(70, new int[]{6, 22});
        VERSION_INFO[3].add(ErrorLevel.L, 70, 55, 1);
        VERSION_INFO[3].add(ErrorLevel.M, 70, 44, 1);
        VERSION_INFO[3].add(ErrorLevel.Q, 35, 17, 2);
        VERSION_INFO[3].add(ErrorLevel.H, 35, 13, 2);
        QrCode.VERSION_INFO[4] = new VersionInfo(100, new int[]{6, 26});
        VERSION_INFO[4].add(ErrorLevel.L, 100, 80, 1);
        VERSION_INFO[4].add(ErrorLevel.M, 50, 32, 2);
        VERSION_INFO[4].add(ErrorLevel.Q, 50, 24, 2);
        VERSION_INFO[4].add(ErrorLevel.H, 25, 9, 4);
        QrCode.VERSION_INFO[5] = new VersionInfo(134, new int[]{6, 30});
        VERSION_INFO[5].add(ErrorLevel.L, 134, 108, 1);
        VERSION_INFO[5].add(ErrorLevel.M, 67, 43, 2);
        VERSION_INFO[5].add(ErrorLevel.Q, 33, 15, 2);
        VERSION_INFO[5].add(ErrorLevel.H, 33, 11, 2);
        QrCode.VERSION_INFO[6] = new VersionInfo(172, new int[]{6, 34});
        VERSION_INFO[6].add(ErrorLevel.L, 86, 68, 2);
        VERSION_INFO[6].add(ErrorLevel.M, 43, 27, 4);
        VERSION_INFO[6].add(ErrorLevel.Q, 43, 19, 4);
        VERSION_INFO[6].add(ErrorLevel.H, 43, 15, 4);
        QrCode.VERSION_INFO[7] = new VersionInfo(196, new int[]{6, 22, 38});
        VERSION_INFO[7].add(ErrorLevel.L, 98, 78, 2);
        VERSION_INFO[7].add(ErrorLevel.M, 49, 31, 4);
        VERSION_INFO[7].add(ErrorLevel.Q, 32, 14, 2);
        VERSION_INFO[7].add(ErrorLevel.H, 39, 13, 4);
        QrCode.VERSION_INFO[8] = new VersionInfo(242, new int[]{6, 24, 42});
        VERSION_INFO[8].add(ErrorLevel.L, 121, 97, 2);
        VERSION_INFO[8].add(ErrorLevel.M, 60, 38, 2);
        VERSION_INFO[8].add(ErrorLevel.Q, 40, 18, 4);
        VERSION_INFO[8].add(ErrorLevel.H, 40, 14, 4);
        QrCode.VERSION_INFO[9] = new VersionInfo(292, new int[]{6, 26, 46});
        VERSION_INFO[9].add(ErrorLevel.L, 146, 116, 2);
        VERSION_INFO[9].add(ErrorLevel.M, 58, 36, 3);
        VERSION_INFO[9].add(ErrorLevel.Q, 36, 16, 4);
        VERSION_INFO[9].add(ErrorLevel.H, 36, 12, 4);
        QrCode.VERSION_INFO[10] = new VersionInfo(346, new int[]{6, 28, 50});
        VERSION_INFO[10].add(ErrorLevel.L, 86, 68, 2);
        VERSION_INFO[10].add(ErrorLevel.M, 69, 43, 4);
        VERSION_INFO[10].add(ErrorLevel.Q, 43, 19, 6);
        VERSION_INFO[10].add(ErrorLevel.H, 43, 15, 6);
        QrCode.VERSION_INFO[11] = new VersionInfo(404, new int[]{6, 30, 54});
        VERSION_INFO[11].add(ErrorLevel.L, 101, 81, 4);
        VERSION_INFO[11].add(ErrorLevel.M, 80, 50, 1);
        VERSION_INFO[11].add(ErrorLevel.Q, 50, 22, 4);
        VERSION_INFO[11].add(ErrorLevel.H, 36, 12, 3);
        QrCode.VERSION_INFO[12] = new VersionInfo(466, new int[]{6, 32, 58});
        VERSION_INFO[12].add(ErrorLevel.L, 116, 92, 2);
        VERSION_INFO[12].add(ErrorLevel.M, 58, 36, 6);
        VERSION_INFO[12].add(ErrorLevel.Q, 46, 20, 4);
        VERSION_INFO[12].add(ErrorLevel.H, 42, 14, 7);
        QrCode.VERSION_INFO[13] = new VersionInfo(532, new int[]{6, 34, 62});
        VERSION_INFO[13].add(ErrorLevel.L, 133, 107, 4);
        VERSION_INFO[13].add(ErrorLevel.M, 59, 37, 8);
        VERSION_INFO[13].add(ErrorLevel.Q, 44, 20, 8);
        VERSION_INFO[13].add(ErrorLevel.H, 33, 11, 12);
        QrCode.VERSION_INFO[14] = new VersionInfo(581, new int[]{6, 26, 46, 66});
        VERSION_INFO[14].add(ErrorLevel.L, 145, 115, 3);
        VERSION_INFO[14].add(ErrorLevel.M, 64, 40, 4);
        VERSION_INFO[14].add(ErrorLevel.Q, 36, 16, 11);
        VERSION_INFO[14].add(ErrorLevel.H, 36, 12, 11);
        QrCode.VERSION_INFO[15] = new VersionInfo(655, new int[]{6, 26, 48, 70});
        VERSION_INFO[15].add(ErrorLevel.L, 109, 87, 5);
        VERSION_INFO[15].add(ErrorLevel.M, 65, 41, 5);
        VERSION_INFO[15].add(ErrorLevel.Q, 54, 24, 5);
        VERSION_INFO[15].add(ErrorLevel.H, 36, 12, 11);
        QrCode.VERSION_INFO[16] = new VersionInfo(733, new int[]{6, 26, 50, 74});
        VERSION_INFO[16].add(ErrorLevel.L, 122, 98, 5);
        VERSION_INFO[16].add(ErrorLevel.M, 73, 45, 7);
        VERSION_INFO[16].add(ErrorLevel.Q, 43, 19, 15);
        VERSION_INFO[16].add(ErrorLevel.H, 45, 15, 3);
        QrCode.VERSION_INFO[17] = new VersionInfo(815, new int[]{6, 30, 54, 78});
        VERSION_INFO[17].add(ErrorLevel.L, 135, 107, 1);
        VERSION_INFO[17].add(ErrorLevel.M, 74, 46, 10);
        VERSION_INFO[17].add(ErrorLevel.Q, 50, 22, 1);
        VERSION_INFO[17].add(ErrorLevel.H, 42, 14, 2);
        QrCode.VERSION_INFO[18] = new VersionInfo(901, new int[]{6, 30, 56, 82});
        VERSION_INFO[18].add(ErrorLevel.L, 150, 120, 5);
        VERSION_INFO[18].add(ErrorLevel.M, 69, 43, 9);
        VERSION_INFO[18].add(ErrorLevel.Q, 50, 22, 17);
        VERSION_INFO[18].add(ErrorLevel.H, 42, 14, 2);
        QrCode.VERSION_INFO[19] = new VersionInfo(991, new int[]{6, 30, 58, 86});
        VERSION_INFO[19].add(ErrorLevel.L, 141, 113, 3);
        VERSION_INFO[19].add(ErrorLevel.M, 70, 44, 3);
        VERSION_INFO[19].add(ErrorLevel.Q, 47, 21, 17);
        VERSION_INFO[19].add(ErrorLevel.H, 39, 13, 9);
        QrCode.VERSION_INFO[20] = new VersionInfo(1085, new int[]{6, 34, 62, 90});
        VERSION_INFO[20].add(ErrorLevel.L, 135, 107, 3);
        VERSION_INFO[20].add(ErrorLevel.M, 67, 41, 3);
        VERSION_INFO[20].add(ErrorLevel.Q, 54, 24, 15);
        VERSION_INFO[20].add(ErrorLevel.H, 43, 15, 15);
        QrCode.VERSION_INFO[21] = new VersionInfo(1156, new int[]{6, 28, 50, 72, 94});
        VERSION_INFO[21].add(ErrorLevel.L, 144, 116, 4);
        VERSION_INFO[21].add(ErrorLevel.M, 68, 42, 17);
        VERSION_INFO[21].add(ErrorLevel.Q, 50, 22, 17);
        VERSION_INFO[21].add(ErrorLevel.H, 46, 16, 19);
        QrCode.VERSION_INFO[22] = new VersionInfo(1258, new int[]{6, 26, 50, 74, 98});
        VERSION_INFO[22].add(ErrorLevel.L, 139, 111, 2);
        VERSION_INFO[22].add(ErrorLevel.M, 74, 46, 17);
        VERSION_INFO[22].add(ErrorLevel.Q, 54, 24, 7);
        VERSION_INFO[22].add(ErrorLevel.H, 37, 13, 34);
        QrCode.VERSION_INFO[23] = new VersionInfo(1364, new int[]{6, 30, 54, 78, 102});
        VERSION_INFO[23].add(ErrorLevel.L, 151, 121, 4);
        VERSION_INFO[23].add(ErrorLevel.M, 75, 47, 4);
        VERSION_INFO[23].add(ErrorLevel.Q, 54, 24, 11);
        VERSION_INFO[23].add(ErrorLevel.H, 45, 15, 16);
        QrCode.VERSION_INFO[24] = new VersionInfo(1474, new int[]{6, 28, 54, 80, 106});
        VERSION_INFO[24].add(ErrorLevel.L, 147, 117, 6);
        VERSION_INFO[24].add(ErrorLevel.M, 73, 45, 6);
        VERSION_INFO[24].add(ErrorLevel.Q, 54, 24, 11);
        VERSION_INFO[24].add(ErrorLevel.H, 46, 16, 30);
        QrCode.VERSION_INFO[25] = new VersionInfo(1588, new int[]{6, 32, 58, 84, 110});
        VERSION_INFO[25].add(ErrorLevel.L, 132, 106, 8);
        VERSION_INFO[25].add(ErrorLevel.M, 75, 47, 8);
        VERSION_INFO[25].add(ErrorLevel.Q, 54, 24, 7);
        VERSION_INFO[25].add(ErrorLevel.H, 45, 15, 22);
        QrCode.VERSION_INFO[26] = new VersionInfo(1706, new int[]{6, 30, 58, 86, 114});
        VERSION_INFO[26].add(ErrorLevel.L, 142, 114, 10);
        VERSION_INFO[26].add(ErrorLevel.M, 74, 46, 19);
        VERSION_INFO[26].add(ErrorLevel.Q, 50, 22, 28);
        VERSION_INFO[26].add(ErrorLevel.H, 46, 16, 33);
        QrCode.VERSION_INFO[27] = new VersionInfo(1828, new int[]{6, 34, 62, 90, 118});
        VERSION_INFO[27].add(ErrorLevel.L, 152, 122, 8);
        VERSION_INFO[27].add(ErrorLevel.M, 73, 45, 22);
        VERSION_INFO[27].add(ErrorLevel.Q, 53, 23, 8);
        VERSION_INFO[27].add(ErrorLevel.H, 45, 15, 12);
        QrCode.VERSION_INFO[28] = new VersionInfo(1921, new int[]{6, 26, 50, 74, 98, 122});
        VERSION_INFO[28].add(ErrorLevel.L, 147, 117, 3);
        VERSION_INFO[28].add(ErrorLevel.M, 73, 45, 3);
        VERSION_INFO[28].add(ErrorLevel.Q, 54, 24, 4);
        VERSION_INFO[28].add(ErrorLevel.H, 45, 15, 11);
        QrCode.VERSION_INFO[29] = new VersionInfo(2051, new int[]{6, 30, 54, 78, 102, 126});
        VERSION_INFO[29].add(ErrorLevel.L, 146, 116, 7);
        VERSION_INFO[29].add(ErrorLevel.M, 73, 45, 21);
        VERSION_INFO[29].add(ErrorLevel.Q, 53, 23, 1);
        VERSION_INFO[29].add(ErrorLevel.H, 45, 15, 19);
        QrCode.VERSION_INFO[30] = new VersionInfo(2185, new int[]{6, 26, 52, 78, 104, 130});
        VERSION_INFO[30].add(ErrorLevel.L, 145, 115, 5);
        VERSION_INFO[30].add(ErrorLevel.M, 75, 47, 19);
        VERSION_INFO[30].add(ErrorLevel.Q, 54, 24, 15);
        VERSION_INFO[30].add(ErrorLevel.H, 45, 15, 23);
        QrCode.VERSION_INFO[31] = new VersionInfo(2323, new int[]{6, 30, 56, 82, 108, 134});
        VERSION_INFO[31].add(ErrorLevel.L, 145, 115, 13);
        VERSION_INFO[31].add(ErrorLevel.M, 74, 46, 2);
        VERSION_INFO[31].add(ErrorLevel.Q, 54, 24, 42);
        VERSION_INFO[31].add(ErrorLevel.H, 45, 15, 23);
        QrCode.VERSION_INFO[32] = new VersionInfo(2465, new int[]{6, 34, 60, 86, 112, 138});
        VERSION_INFO[32].add(ErrorLevel.L, 145, 115, 17);
        VERSION_INFO[32].add(ErrorLevel.M, 74, 46, 10);
        VERSION_INFO[32].add(ErrorLevel.Q, 54, 24, 10);
        VERSION_INFO[32].add(ErrorLevel.H, 45, 15, 19);
        QrCode.VERSION_INFO[33] = new VersionInfo(2611, new int[]{6, 30, 58, 86, 114, 142});
        VERSION_INFO[33].add(ErrorLevel.L, 145, 115, 17);
        VERSION_INFO[33].add(ErrorLevel.M, 74, 46, 14);
        VERSION_INFO[33].add(ErrorLevel.Q, 54, 24, 29);
        VERSION_INFO[33].add(ErrorLevel.H, 45, 15, 11);
        QrCode.VERSION_INFO[34] = new VersionInfo(2761, new int[]{6, 34, 62, 90, 118, 146});
        VERSION_INFO[34].add(ErrorLevel.L, 145, 115, 13);
        VERSION_INFO[34].add(ErrorLevel.M, 74, 46, 14);
        VERSION_INFO[34].add(ErrorLevel.Q, 54, 24, 44);
        VERSION_INFO[34].add(ErrorLevel.H, 46, 16, 59);
        QrCode.VERSION_INFO[35] = new VersionInfo(2876, new int[]{6, 30, 54, 78, 102, 126, 150});
        VERSION_INFO[35].add(ErrorLevel.L, 151, 121, 12);
        VERSION_INFO[35].add(ErrorLevel.M, 75, 47, 12);
        VERSION_INFO[35].add(ErrorLevel.Q, 54, 24, 39);
        VERSION_INFO[35].add(ErrorLevel.H, 45, 15, 22);
        QrCode.VERSION_INFO[36] = new VersionInfo(3034, new int[]{6, 24, 50, 76, 102, 128, 154});
        VERSION_INFO[36].add(ErrorLevel.L, 151, 121, 6);
        VERSION_INFO[36].add(ErrorLevel.M, 75, 47, 6);
        VERSION_INFO[36].add(ErrorLevel.Q, 54, 24, 46);
        VERSION_INFO[36].add(ErrorLevel.H, 45, 15, 2);
        QrCode.VERSION_INFO[37] = new VersionInfo(3196, new int[]{6, 28, 54, 80, 106, 132, 158});
        VERSION_INFO[37].add(ErrorLevel.L, 152, 122, 17);
        VERSION_INFO[37].add(ErrorLevel.M, 74, 46, 29);
        VERSION_INFO[37].add(ErrorLevel.Q, 54, 24, 49);
        VERSION_INFO[37].add(ErrorLevel.H, 45, 15, 24);
        QrCode.VERSION_INFO[38] = new VersionInfo(3362, new int[]{6, 32, 58, 84, 110, 136, 162});
        VERSION_INFO[38].add(ErrorLevel.L, 152, 122, 4);
        VERSION_INFO[38].add(ErrorLevel.M, 74, 46, 13);
        VERSION_INFO[38].add(ErrorLevel.Q, 54, 24, 48);
        VERSION_INFO[38].add(ErrorLevel.H, 45, 15, 42);
        QrCode.VERSION_INFO[39] = new VersionInfo(3532, new int[]{6, 26, 54, 82, 110, 138, 166});
        VERSION_INFO[39].add(ErrorLevel.L, 147, 117, 20);
        VERSION_INFO[39].add(ErrorLevel.M, 75, 47, 40);
        VERSION_INFO[39].add(ErrorLevel.Q, 54, 24, 43);
        VERSION_INFO[39].add(ErrorLevel.H, 45, 15, 10);
        QrCode.VERSION_INFO[40] = new VersionInfo(3706, new int[]{6, 30, 58, 86, 114, 142, 170});
        VERSION_INFO[40].add(ErrorLevel.L, 148, 118, 19);
        VERSION_INFO[40].add(ErrorLevel.M, 75, 47, 18);
        VERSION_INFO[40].add(ErrorLevel.Q, 54, 24, 34);
        VERSION_INFO[40].add(ErrorLevel.H, 45, 15, 20);
        for (int version = 1; version <= 40; ++version) {
            QrCodeCodeWordLocations mask = new QrCodeCodeWordLocations(version);
            QrCode.LOCATION_BITS[version] = mask.bits;
        }
    }

    public static enum Mode {
        UNKNOWN(-1),
        MIXED(-2),
        NUMERIC(1),
        ALPHANUMERIC(2),
        BYTE(4),
        KANJI(8),
        ECI(7),
        STRUCTURE_APPENDED(3),
        FNC1_FIRST(5),
        FNC1_SECOND(9);

        final int bits;

        private Mode(int bits) {
            this.bits = bits;
        }

        public static Mode lookup(int bits) {
            if (Mode.NUMERIC.bits == bits) {
                return NUMERIC;
            }
            if (Mode.ALPHANUMERIC.bits == bits) {
                return ALPHANUMERIC;
            }
            if (Mode.BYTE.bits == bits) {
                return BYTE;
            }
            if (Mode.KANJI.bits == bits) {
                return KANJI;
            }
            if (Mode.ECI.bits == bits) {
                return ECI;
            }
            if (Mode.STRUCTURE_APPENDED.bits == bits) {
                return STRUCTURE_APPENDED;
            }
            if (Mode.FNC1_FIRST.bits == bits) {
                return FNC1_FIRST;
            }
            if (Mode.FNC1_SECOND.bits == bits) {
                return FNC1_SECOND;
            }
            return UNKNOWN;
        }

        public static Mode lookup(String name) {
            name = name.toUpperCase();
            Mode[] modes = Mode.values();
            for (int modeIdx = 0; modeIdx < modes.length; ++modeIdx) {
                Mode m = modes[modeIdx];
                if (!m.toString().equals(name)) continue;
                return m;
            }
            return null;
        }
    }

    public static enum Failure {
        NONE,
        FORMAT,
        VERSION,
        ALIGNMENT,
        READING_BITS,
        ERROR_CORRECTION,
        UNKNOWN_MODE,
        READING_PADDING,
        MESSAGE_OVERFLOW,
        DECODING_MESSAGE,
        KANJI_UNAVAILABLE,
        JIS_UNAVAILABLE;

    }

    public static class VersionInfo {
        public final int codewords;
        public final int[] alignment;
        public final Map<ErrorLevel, BlockInfo> levels = new HashMap<ErrorLevel, BlockInfo>();

        public VersionInfo(int codewords, int[] alignment) {
            this.codewords = codewords;
            this.alignment = alignment;
        }

        public void add(ErrorLevel level, int codeWords, int dataCodewords, int eccBlocks) {
            this.levels.put(level, new BlockInfo(codeWords, dataCodewords, eccBlocks));
        }

        public int totalDataBytes(ErrorLevel error) {
            BlockInfo b = this.levels.get((Object)error);
            int remaining = this.codewords - b.codewords * b.blocks;
            int blocksB = remaining / (b.codewords + 1);
            return b.dataCodewords * b.blocks + (b.dataCodewords + 1) * blocksB;
        }
    }

    public static enum ErrorLevel {
        L(1),
        M(0),
        Q(3),
        H(2);

        final int value;

        private ErrorLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ErrorLevel lookup(int value) {
            switch (value) {
                case 1: {
                    return L;
                }
                case 0: {
                    return M;
                }
                case 3: {
                    return Q;
                }
                case 2: {
                    return H;
                }
            }
            throw new IllegalArgumentException("Unknown");
        }

        public static ErrorLevel lookup(String letter) {
            switch (letter) {
                case "L": {
                    return L;
                }
                case "M": {
                    return M;
                }
                case "Q": {
                    return Q;
                }
                case "H": {
                    return H;
                }
            }
            throw new IllegalArgumentException("Unknown");
        }
    }

    public static class Alignment {
        public Point2D_F64 pixel = new Point2D_F64();
        public int moduleX;
        public int moduleY;
        Point2D_F64 moduleFound = new Point2D_F64();
        public double threshold;

        public void set(Alignment o) {
            this.pixel.setTo(o.pixel);
            this.moduleX = o.moduleX;
            this.moduleY = o.moduleY;
            this.moduleFound.setTo(o.moduleFound);
        }
    }

    public static class BlockInfo {
        public final int codewords;
        public final int dataCodewords;
        public final int blocks;

        public BlockInfo(int codewords, int dataCodewords, int blocks) {
            this.codewords = codewords;
            this.dataCodewords = dataCodewords;
            this.blocks = blocks;
        }
    }
}

