/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Area2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;

public class SquareGridTools {
    Polygon2D_F64 poly = new Polygon2D_F64(4);
    List<SquareNode> tmp = new ArrayList<SquareNode>();
    LineSegment2D_F64 lineCenters = new LineSegment2D_F64();
    LineSegment2D_F64 lineSide = new LineSegment2D_F64();
    Point2D_F64 dummy = new Point2D_F64();
    LineGeneral2D_F64 general = new LineGeneral2D_F64();
    Point2D_F64[] ordered = new Point2D_F64[4];

    public void putIntoCanonical(SquareGrid grid) {
        if (grid.rows == grid.columns) {
            int i;
            int best = -1;
            double bestDistance = Double.MAX_VALUE;
            for (i = 0; i < 4; ++i) {
                SquareNode n = grid.getCornerByIndex(i);
                double d = n.center.normSq();
                if (!(d < bestDistance)) continue;
                best = i;
                bestDistance = d;
            }
            for (i = 0; i < best; ++i) {
                this.rotateCCW(grid);
            }
        } else {
            double first = grid.get((int)0, (int)0).center.normSq();
            double last = grid.getCornerByIndex((int)2).center.normSq();
            if (last < first) {
                this.reverse(grid);
            }
        }
    }

    public void rotateCCW(SquareGrid grid) {
        this.tmp.clear();
        for (int row = 0; row < grid.rows; ++row) {
            for (int col = 0; col < grid.columns; ++col) {
                this.tmp.add(grid.get(col, grid.columns - row - 1));
            }
        }
        grid.nodes.clear();
        grid.nodes.addAll(this.tmp);
    }

    public void reverse(SquareGrid grid) {
        this.tmp.clear();
        int N = grid.columns * grid.rows;
        for (int i = 0; i < N; ++i) {
            this.tmp.add(grid.nodes.get(N - i - 1));
        }
        grid.nodes.clear();
        grid.nodes.addAll(this.tmp);
    }

    public boolean checkFlip(SquareGrid grid) {
        if (grid.columns == 1 || grid.rows == 1) {
            return false;
        }
        Point2D_F64 a = grid.get((int)0, (int)0).center;
        Point2D_F64 b = grid.get((int)0, (int)(grid.columns - 1)).center;
        Point2D_F64 c = grid.get((int)(grid.rows - 1), (int)0).center;
        double x0 = b.x - a.x;
        double y1 = c.y - a.y;
        double y0 = b.y - a.y;
        double x1 = c.x - a.x;
        double z = x0 * y1 - y0 * x1;
        return z < 0.0;
    }

    public double computeSize(SquareGrid grid) {
        ((Point2D_F64[])this.poly.vertexes.data)[0] = grid.get((int)0, (int)0).center;
        ((Point2D_F64[])this.poly.vertexes.data)[1] = grid.get((int)0, (int)(grid.columns - 1)).center;
        ((Point2D_F64[])this.poly.vertexes.data)[2] = grid.get((int)(grid.rows - 1), (int)(grid.columns - 1)).center;
        ((Point2D_F64[])this.poly.vertexes.data)[3] = grid.get((int)(grid.rows - 1), (int)0).center;
        return Area2D_F64.polygonSimple(this.poly);
    }

    public void transpose(SquareGrid grid) {
        this.tmp.clear();
        for (int col = 0; col < grid.columns; ++col) {
            for (int row = 0; row < grid.rows; ++row) {
                this.tmp.add(grid.get(row, col));
            }
        }
        grid.nodes.clear();
        grid.nodes.addAll(this.tmp);
        int a = grid.columns;
        grid.columns = grid.rows;
        grid.rows = a;
    }

    public void flipRows(SquareGrid grid) {
        this.tmp.clear();
        for (int row = 0; row < grid.rows; ++row) {
            for (int col = 0; col < grid.columns; ++col) {
                this.tmp.add(grid.nodes.get((grid.rows - row - 1) * grid.columns + col));
            }
        }
        grid.nodes.clear();
        grid.nodes.addAll(this.tmp);
    }

    public void flipColumns(SquareGrid grid) {
        this.tmp.clear();
        for (int row = 0; row < grid.rows; ++row) {
            for (int col = 0; col < grid.columns; ++col) {
                this.tmp.add(grid.get(row, grid.columns - col - 1));
            }
        }
        grid.nodes.clear();
        grid.nodes.addAll(this.tmp);
    }

    public void boundingPolygonCCW(SquareGrid grid, Polygon2D_F64 bounding) {
        int w = grid.columns;
        int h = grid.rows;
        if (w == 1 && h == 1) {
            SquareNode n = grid.get(0, 0);
            bounding.get(0).setTo(n.square.get(0));
            bounding.get(1).setTo(n.square.get(1));
            bounding.get(2).setTo(n.square.get(2));
            bounding.get(3).setTo(n.square.get(3));
        } else if (w == 1) {
            this.orderNode(grid.get(0, 0), grid.get(h - 1, 0), false);
            bounding.get(0).setTo(this.ordered[0]);
            bounding.get(1).setTo(this.ordered[1]);
            this.orderNode(grid.get(h - 1, 0), grid.get(0, 0), false);
            bounding.get(2).setTo(this.ordered[0]);
            bounding.get(3).setTo(this.ordered[1]);
        } else if (h == 1) {
            this.orderNode(grid.get(0, 0), grid.get(0, w - 1), true);
            bounding.get(0).setTo(this.ordered[0]);
            bounding.get(3).setTo(this.ordered[3]);
            this.orderNode(grid.get(0, w - 1), grid.get(0, 0), true);
            bounding.get(1).setTo(this.ordered[3]);
            bounding.get(2).setTo(this.ordered[0]);
        } else {
            this.orderNode(grid.get(0, 0), grid.get(0, w - 1), true);
            bounding.get(0).setTo(this.ordered[0]);
            this.orderNode(grid.get(0, w - 1), grid.get(h - 1, w - 1), true);
            bounding.get(1).setTo(this.ordered[0]);
            this.orderNode(grid.get(h - 1, w - 1), grid.get(h - 1, 0), true);
            bounding.get(2).setTo(this.ordered[0]);
            this.orderNode(grid.get(h - 1, 0), grid.get(0, 0), true);
            bounding.get(3).setTo(this.ordered[0]);
        }
    }

    protected void orderNodeGrid(SquareGrid grid, int row, int col) {
        SquareNode node = grid.get(row, col);
        if (grid.rows == 1 && grid.columns == 1) {
            for (int i = 0; i < 4; ++i) {
                this.ordered[i] = node.square.get(i);
            }
        } else if (grid.columns == 1) {
            if (row == grid.rows - 1) {
                this.orderNode(node, grid.get(row - 1, col), false);
                this.rotateTwiceOrdered();
            } else {
                this.orderNode(node, grid.get(row + 1, col), false);
            }
        } else if (col == grid.columns - 1) {
            this.orderNode(node, grid.get(row, col - 1), true);
            this.rotateTwiceOrdered();
        } else {
            this.orderNode(node, grid.get(row, col + 1), true);
        }
    }

    private void rotateTwiceOrdered() {
        Point2D_F64 a = this.ordered[0];
        Point2D_F64 b = this.ordered[1];
        Point2D_F64 c = this.ordered[2];
        Point2D_F64 d = this.ordered[3];
        this.ordered[0] = c;
        this.ordered[1] = d;
        this.ordered[2] = a;
        this.ordered[3] = b;
    }

    protected void orderNode(SquareNode target, SquareNode node, boolean pointingX) {
        int index0 = this.findIntersection(target, node);
        int index1 = (index0 + 1) % 4;
        int index2 = (index0 + 2) % 4;
        int index3 = (index0 + 3) % 4;
        if (index0 < 0) {
            throw new RuntimeException("Couldn't find intersection.  Probable bug");
        }
        this.lineCenters.a = target.center;
        this.lineCenters.b = node.center;
        UtilLine2D_F64.convert(this.lineCenters, this.general);
        Polygon2D_F64 poly = target.square;
        if (pointingX) {
            if (SquareGridTools.sign(this.general, poly.get(index0)) > 0) {
                this.ordered[1] = poly.get(index1);
                this.ordered[2] = poly.get(index0);
            } else {
                this.ordered[1] = poly.get(index0);
                this.ordered[2] = poly.get(index1);
            }
            if (SquareGridTools.sign(this.general, poly.get(index2)) > 0) {
                this.ordered[3] = poly.get(index2);
                this.ordered[0] = poly.get(index3);
            } else {
                this.ordered[3] = poly.get(index3);
                this.ordered[0] = poly.get(index2);
            }
        } else {
            if (SquareGridTools.sign(this.general, poly.get(index0)) > 0) {
                this.ordered[2] = poly.get(index1);
                this.ordered[3] = poly.get(index0);
            } else {
                this.ordered[2] = poly.get(index0);
                this.ordered[3] = poly.get(index1);
            }
            if (SquareGridTools.sign(this.general, poly.get(index2)) > 0) {
                this.ordered[0] = poly.get(index2);
                this.ordered[1] = poly.get(index3);
            } else {
                this.ordered[0] = poly.get(index3);
                this.ordered[1] = poly.get(index2);
            }
        }
    }

    protected int findIntersection(SquareNode target, SquareNode node) {
        this.lineCenters.a = target.center;
        this.lineCenters.b = node.center;
        for (int i = 0; i < 4; ++i) {
            int j = (i + 1) % 4;
            this.lineSide.a = target.square.get(i);
            this.lineSide.b = target.square.get(j);
            if (Intersection2D_F64.intersection(this.lineCenters, this.lineSide, this.dummy) == null) continue;
            return i;
        }
        return -1;
    }

    public boolean orderSquareCorners(SquareGrid grid) {
        for (int row = 0; row < grid.rows; ++row) {
            for (int col = 0; col < grid.columns; ++col) {
                this.orderNodeGrid(grid, row, col);
                Polygon2D_F64 square = grid.get((int)row, (int)col).square;
                for (int i = 0; i < 4; ++i) {
                    ((Point2D_F64[])square.vertexes.data)[i] = this.ordered[i];
                }
            }
        }
        return true;
    }

    public static int sign(LineGeneral2D_F64 line, Point2D_F64 p) {
        double val2 = line.A * p.x + line.B * p.y + line.C;
        if (val2 > 0.0) {
            return 1;
        }
        if (val2 < 0.0) {
            return -1;
        }
        return 0;
    }
}

