/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.SampleIntensityScalePoint;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.filter.convolve.FactoryConvolveSparse;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class SiftDetector {
    protected SiftScaleSpace scaleSpace;
    protected double pixelScaleToInput;
    double edgeThreshold;
    public int maxFeaturesAll = -1;
    protected DogArray<ScalePoint> detectionsAll = new DogArray<ScalePoint>(ScalePoint::new);
    ImageConvolveSparse<GrayF32, ?> derivXX;
    ImageConvolveSparse<GrayF32, ?> derivXY;
    ImageConvolveSparse<GrayF32, ?> derivYY;
    GrayF32 dogLower;
    GrayF32 dogTarget;
    GrayF32 dogUpper;
    double sigmaLower;
    double sigmaTarget;
    double sigmaUpper;
    private NonMaxLimiter extractor;
    private FeatureSelectLimitIntensity<ScalePoint> selectFeaturesAll;
    private FastArray<ScalePoint> selectedAll = new FastArray<ScalePoint>(ScalePoint.class);

    public SiftDetector(SiftScaleSpace scaleSpace, FeatureSelectLimitIntensity<ScalePoint> selectFeaturesAll, double edgeR, NonMaxLimiter extractor) {
        if (!extractor.getNonmax().canDetectMaximums() || !extractor.getNonmax().canDetectMinimums()) {
            throw new IllegalArgumentException("The extractor must be able to detect maximums and minimums");
        }
        if (edgeR < 1.0) {
            throw new IllegalArgumentException("R must be >= 1");
        }
        if (extractor.getNonmax().getIgnoreBorder() != 1) {
            throw new RuntimeException("Non-max should have an ignore border of 1");
        }
        this.scaleSpace = scaleSpace;
        this.extractor = extractor;
        this.edgeThreshold = (edgeR + 1.0) * (edgeR + 1.0) / edgeR;
        this.selectFeaturesAll = selectFeaturesAll;
        selectFeaturesAll.setSampler(new SampleIntensityScalePoint());
        this.createSparseDerivatives();
    }

    private void createSparseDerivatives() {
        Kernel1D_F32 kernelD = new Kernel1D_F32(new float[]{-1.0f, 0.0f, 1.0f}, 3);
        Kernel1D_F32 kernelDD = KernelMath.convolve1D_F32(kernelD, kernelD);
        Kernel2D_F32 kernelXY = KernelMath.convolve2D(kernelD, kernelD);
        this.derivXX = FactoryConvolveSparse.horizontal1D(GrayF32.class, kernelDD);
        this.derivXY = FactoryConvolveSparse.convolve2D(GrayF32.class, kernelXY);
        this.derivYY = FactoryConvolveSparse.vertical1D(GrayF32.class, kernelDD);
        Object border = FactoryImageBorder.single(BorderType.EXTENDED, GrayF32.class);
        this.derivXX.setImageBorder((ImageBorder<GrayF32>)border);
        this.derivXY.setImageBorder((ImageBorder<GrayF32>)border);
        this.derivYY.setImageBorder((ImageBorder<GrayF32>)border);
    }

    public void process(GrayF32 input) {
        this.scaleSpace.initialize(input);
        this.detectionsAll.reset();
        do {
            this.pixelScaleToInput = this.scaleSpace.pixelScaleCurrentToInput();
            for (int j = 1; j < this.scaleSpace.getNumScales() + 1; ++j) {
                this.sigmaLower = this.scaleSpace.computeSigmaScale(j - 1);
                this.sigmaTarget = this.scaleSpace.computeSigmaScale(j);
                this.sigmaUpper = this.scaleSpace.computeSigmaScale(j + 1);
                this.dogLower = this.scaleSpace.getDifferenceOfGaussian(j - 1);
                this.dogTarget = this.scaleSpace.getDifferenceOfGaussian(j);
                this.dogUpper = this.scaleSpace.getDifferenceOfGaussian(j + 1);
                this.detectFeatures(j);
            }
        } while (this.scaleSpace.computeNextOctave());
        if (this.maxFeaturesAll > 0) {
            this.selectFeaturesAll.select(null, input.width, input.height, true, null, this.detectionsAll, this.maxFeaturesAll, this.selectedAll);
        }
    }

    protected void detectFeatures(int scaleIndex) {
        this.extractor.process(this.dogTarget);
        FastAccess<NonMaxLimiter.LocalExtreme> found = this.extractor.getFeatures();
        this.derivXX.setImage(this.dogTarget);
        this.derivXY.setImage(this.dogTarget);
        this.derivYY.setImage(this.dogTarget);
        for (int i = 0; i < found.size; ++i) {
            NonMaxLimiter.LocalExtreme e = found.get(i);
            if (!this.isScaleSpaceExtremum(e.location.x, e.location.y, e.getValue(), e.max ? 1.0f : -1.0f)) continue;
            this.processFeatureCandidate(e.location.x, e.location.y, e.getValue(), e.max);
        }
    }

    boolean isScaleSpaceExtremum(int c_x, int c_y, float value, float signAdj) {
        if (c_x <= 1 || c_y <= 1 || c_x >= this.dogLower.width - 1 || c_y >= this.dogLower.height - 1) {
            return false;
        }
        value *= signAdj;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                float v = this.dogLower.unsafe_get(c_x + x, c_y + y);
                if (v * signAdj >= value) {
                    return false;
                }
                v = this.dogUpper.unsafe_get(c_x + x, c_y + y);
                if (!(v * signAdj >= value)) continue;
                return false;
            }
        }
        return true;
    }

    protected void processFeatureCandidate(int x, int y, float value, boolean maximum) {
        if (this.isEdge(x, y)) {
            return;
        }
        float signAdj = maximum ? 1.0f : -1.0f;
        value *= signAdj;
        float x0 = this.dogTarget.unsafe_get(x - 1, y) * signAdj;
        float x2 = this.dogTarget.unsafe_get(x + 1, y) * signAdj;
        float y0 = this.dogTarget.unsafe_get(x, y - 1) * signAdj;
        float y2 = this.dogTarget.unsafe_get(x, y + 1) * signAdj;
        float s0 = this.dogLower.unsafe_get(x, y) * signAdj;
        float s2 = this.dogUpper.unsafe_get(x, y) * signAdj;
        ScalePoint p = this.detectionsAll.grow();
        p.pixel.x = this.pixelScaleToInput * (double)((float)x + FastHessianFeatureDetector.polyPeak(x0, value, x2));
        p.pixel.y = this.pixelScaleToInput * (double)((float)y + FastHessianFeatureDetector.polyPeak(y0, value, y2));
        double sigmaInterp = FastHessianFeatureDetector.polyPeak(s0, value, s2);
        p.scale = sigmaInterp < 0.0 ? this.sigmaLower * -sigmaInterp + (1.0 + sigmaInterp) * this.sigmaTarget : this.sigmaUpper * sigmaInterp + (1.0 - sigmaInterp) * this.sigmaTarget;
        p.white = !maximum;
        p.intensity = maximum ? value : -value;
        this.handleDetection(p);
    }

    protected void handleDetection(ScalePoint p) {
    }

    boolean isEdge(int x, int y) {
        if (this.edgeThreshold <= 0.0) {
            return false;
        }
        double xx = this.derivXX.compute(x, y);
        double xy = this.derivXY.compute(x, y);
        double yy = this.derivYY.compute(x, y);
        double Tr = xx + yy;
        double det = xx * yy - xy * xy;
        if (det <= 0.0) {
            return true;
        }
        return Tr * Tr >= this.edgeThreshold * det;
    }

    public List<ScalePoint> getDetections() {
        return (this.maxFeaturesAll > 0 ? this.selectedAll : this.detectionsAll).toList();
    }

    public NonMaxLimiter getExtractor() {
        return this.extractor;
    }
}

