/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.struct.ListIntPoint2D;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class NonMaxCandidate {
    protected int radius;
    protected float thresholdMin;
    protected float thresholdMax;
    protected int ignoreBorder;
    protected GrayF32 input;
    protected Search search;
    protected int endBorderX;
    protected int endBorderY;
    protected Point2D_I16 pt = new Point2D_I16();

    public NonMaxCandidate(Search search) {
        this.search = search;
    }

    public void process(GrayF32 intensityImage, @Nullable ListIntPoint2D candidatesMin, @Nullable ListIntPoint2D candidatesMax, DogArray<Point2D_I16> foundMin, DogArray<Point2D_I16> foundMax) {
        this.input = intensityImage;
        this.endBorderX = intensityImage.width - this.ignoreBorder;
        this.endBorderY = intensityImage.height - this.ignoreBorder;
        this.search.initialize(intensityImage);
        if (candidatesMin != null) {
            foundMin.reset();
            this.examineMinimum(intensityImage, candidatesMin, foundMin);
        }
        if (candidatesMax != null) {
            foundMax.reset();
            this.examineMaximum(intensityImage, candidatesMax, foundMax);
        }
    }

    protected void examineMinimum(GrayF32 intensityImage, ListIntPoint2D candidates, DogArray<Point2D_I16> found) {
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        for (int pointIdx = 0; pointIdx < candidates.size(); ++pointIdx) {
            int y1;
            int x1;
            int y0;
            int x0;
            int center;
            float val2;
            Point2D_I16 pt = this.pt;
            candidates.get(pointIdx, pt);
            if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val2 = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) > this.thresholdMin || val2 == -3.4028235E38f || !this.search.searchMin(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val2)) continue;
            found.grow().setTo(pt.x, pt.y);
        }
    }

    protected void examineMaximum(GrayF32 intensityImage, ListIntPoint2D candidates, DogArray<Point2D_I16> found) {
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        for (int pointIdx = 0; pointIdx < candidates.size(); ++pointIdx) {
            int y1;
            int x1;
            int y0;
            int x0;
            int center;
            float val2;
            Point2D_I16 pt = this.pt;
            candidates.get(pointIdx, pt);
            if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val2 = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) < this.thresholdMax || val2 == Float.MAX_VALUE || !this.search.searchMax(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val2)) continue;
            found.grow().setTo(pt.x, pt.y);
        }
    }

    public void setSearchRadius(int radius) {
        this.radius = radius;
    }

    public int getSearchRadius() {
        return this.radius;
    }

    public float getThresholdMin() {
        return this.thresholdMin;
    }

    public void setThresholdMin(float thresholdMin) {
        this.thresholdMin = thresholdMin;
    }

    public float getThresholdMax() {
        return this.thresholdMax;
    }

    public void setThresholdMax(float thresholdMax) {
        this.thresholdMax = thresholdMax;
    }

    public void setBorder(int border) {
        this.ignoreBorder = border;
    }

    public int getBorder() {
        return this.ignoreBorder;
    }

    public static interface Search {
        public void initialize(GrayF32 var1);

        public boolean searchMin(int var1, int var2, int var3, int var4, int var5, float var6);

        public boolean searchMax(int var1, int var2, int var3, int var4, int var5, float var6);

        public Search newInstance();
    }

    public static class Strict
    implements Search {
        GrayF32 intensity;

        @Override
        public void initialize(GrayF32 intensity) {
            this.intensity = intensity;
        }

        @Override
        public boolean searchMin(int x0, int y0, int x1, int y1, int centerIdx, float val2) {
            for (int i = y0; i < y1; ++i) {
                int index = this.intensity.startIndex + i * this.intensity.stride + x0;
                int j = x0;
                while (j < x1) {
                    if (centerIdx != index && val2 >= this.intensity.data[index]) {
                        return false;
                    }
                    ++j;
                    ++index;
                }
            }
            return true;
        }

        @Override
        public boolean searchMax(int x0, int y0, int x1, int y1, int centerIdx, float val2) {
            for (int i = y0; i < y1; ++i) {
                int index = this.intensity.startIndex + i * this.intensity.stride + x0;
                int j = x0;
                while (j < x1) {
                    if (centerIdx != index && val2 <= this.intensity.data[index]) {
                        return false;
                    }
                    ++j;
                    ++index;
                }
            }
            return true;
        }

        @Override
        public Search newInstance() {
            return new Strict();
        }
    }

    public static class Relaxed
    implements Search {
        GrayF32 intensity;

        @Override
        public void initialize(GrayF32 intensity) {
            this.intensity = intensity;
        }

        @Override
        public boolean searchMin(int x0, int y0, int x1, int y1, int centerIdx, float val2) {
            for (int i = y0; i < y1; ++i) {
                int index = this.intensity.startIndex + i * this.intensity.stride + x0;
                int j = x0;
                while (j < x1) {
                    if (val2 > this.intensity.data[index]) {
                        return false;
                    }
                    ++j;
                    ++index;
                }
            }
            return true;
        }

        @Override
        public boolean searchMax(int x0, int y0, int x1, int y1, int centerIdx, float val2) {
            for (int i = y0; i < y1; ++i) {
                int index = this.intensity.startIndex + i * this.intensity.stride + x0;
                int j = x0;
                while (j < x1) {
                    if (val2 < this.intensity.data[index]) {
                        return false;
                    }
                    ++j;
                    ++index;
                }
            }
            return true;
        }

        @Override
        public Search newInstance() {
            return new Relaxed();
        }
    }
}

