/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.feature.describe.SurfDescribeOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sparse.SparseGradientSafe;
import boofcv.struct.sparse.SparseImageGradient;
import boofcv.struct.sparse.SparseScaleGradient;

public class DescribePointSurf<II extends ImageGray<II>> {
    protected int widthLargeGrid;
    protected int widthSubRegion;
    protected int widthSample;
    protected double weightSigma;
    protected boolean useHaar;
    protected Class<II> inputType;
    protected int featureDOF;
    protected II ii;
    protected Kernel2D_F64 weight;
    protected SparseScaleGradient<II, ?> gradient;
    protected SparseImageGradient<II, ?> gradientSafe;
    protected int radiusDescriptor;

    public DescribePointSurf(int widthLargeGrid, int widthSubRegion, int widthSample, double weightSigma, boolean useHaar, Class<II> inputType) {
        this.widthLargeGrid = widthLargeGrid;
        this.widthSubRegion = widthSubRegion;
        this.widthSample = widthSample;
        this.useHaar = useHaar;
        this.weightSigma = weightSigma;
        this.inputType = inputType;
        int radius = widthLargeGrid * widthSubRegion / 2;
        this.weight = FactoryKernelGaussian.gaussianWidth(weightSigma, radius * 2);
        double div = this.weight.get(radius, radius);
        int i = 0;
        while (i < this.weight.data.length) {
            int n = i++;
            this.weight.data[n] = this.weight.data[n] / div;
        }
        this.featureDOF = widthLargeGrid * widthLargeGrid * 4;
        this.gradient = SurfDescribeOps.createGradient(useHaar, inputType);
        this.gradientSafe = new SparseGradientSafe(this.gradient);
        this.radiusDescriptor = widthLargeGrid * widthSubRegion / 2;
    }

    public DescribePointSurf(Class<II> inputType) {
        this(4, 5, 3, 4.5, false, inputType);
    }

    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.featureDOF);
    }

    public void setImage(II integralImage) {
        this.ii = integralImage;
        this.gradient.setImage(this.ii);
    }

    public void describe(double x, double y, double angle, double scale, boolean normalize, TupleDesc_F64 ret) {
        if (ret.value.length != this.featureDOF) {
            throw new IllegalArgumentException("Provided feature must have " + this.featureDOF + " elements");
        }
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        this.gradient.setImage(this.ii);
        this.gradient.setWidth((double)this.widthSample * scale);
        boolean isInBounds = SurfDescribeOps.isInside(this.ii, x, y, this.radiusDescriptor, this.widthSample, scale, c, s);
        SparseImageGradient<II, ?> gradient = isInBounds ? this.gradient : this.gradientSafe;
        this.features(x, y, c, s, scale, gradient, ret.value);
        if (normalize) {
            UtilFeature.normalizeL2(ret);
        }
    }

    public void features(double c_x, double c_y, double c, double s, double scale, SparseImageGradient gradient, double[] features) {
        int regionSize = this.widthLargeGrid * this.widthSubRegion;
        if (this.weight.width != regionSize) {
            throw new IllegalArgumentException("Weighting kernel has an unexpected size");
        }
        int regionR = regionSize / 2;
        int regionEnd = regionSize - regionR;
        int regionIndex = 0;
        c_x += 0.5;
        c_y += 0.5;
        for (int rY = -regionR; rY < regionEnd; rY += this.widthSubRegion) {
            for (int rX = -regionR; rX < regionEnd; rX += this.widthSubRegion) {
                double sum_dx = 0.0;
                double sum_dy = 0.0;
                double sum_adx = 0.0;
                double sum_ady = 0.0;
                for (int i = 0; i < this.widthSubRegion; ++i) {
                    double regionY = (double)(rY + i) * scale;
                    for (int j = 0; j < this.widthSubRegion; ++j) {
                        double w = this.weight.get(regionR + rX + j, regionR + rY + i);
                        double regionX = (double)(rX + j) * scale;
                        int pixelX = (int)(c_x + c * regionX - s * regionY);
                        int pixelY = (int)(c_y + s * regionX + c * regionY);
                        Object g = gradient.compute(pixelX, pixelY);
                        double dx = w * g.getX();
                        double dy = w * g.getY();
                        double pdx = c * dx + s * dy;
                        double pdy = -s * dx + c * dy;
                        sum_dx += pdx;
                        sum_adx += Math.abs(pdx);
                        sum_dy += pdy;
                        sum_ady += Math.abs(pdy);
                    }
                }
                features[regionIndex++] = sum_dx;
                features[regionIndex++] = sum_adx;
                features[regionIndex++] = sum_dy;
                features[regionIndex++] = sum_ady;
            }
        }
    }

    public int getDescriptionLength() {
        return this.featureDOF;
    }

    public Class<II> getInputType() {
        return this.inputType;
    }

    public int getCanonicalWidth() {
        return this.widthLargeGrid * this.widthSubRegion + this.widthSample - this.widthSample % 2;
    }

    public DescribePointSurf<II> copy() {
        return new DescribePointSurf<II>(this.widthLargeGrid, this.widthSubRegion, this.widthSample, this.weightSigma, this.useHaar, this.inputType);
    }
}

